/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.resolver;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.internal.bridge.resolver.ContainmentClosure;
import org.eclipse.gmf.internal.bridge.resolver.NodePattern;
import org.eclipse.gmf.internal.bridge.resolver.Resolution;
import org.eclipse.gmf.internal.bridge.resolver.ResolvedItem;
import org.eclipse.gmf.internal.bridge.resolver.StructureResolver;
import org.eclipse.gmf.internal.bridge.resolver.TypeLinkPattern;
import org.eclipse.gmf.internal.bridge.resolver.TypePattern;

public class StructureBuilder {
    private StructureResolver resolver;

    public StructureBuilder(StructureResolver resolver) {
        this.resolver = resolver;
    }

    public ResolvedItem process(EPackage domainPackage, EClass diagramClass) {
        ResolvedItem item = new ResolvedItem(null, domainPackage, null, ResolvedItem.DEFAULT_RESOLUTIONS);
        TreeIterator it = domainPackage.eAllContents();
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof EClass)) continue;
            item.addChild(this.process((EClass)next, domainPackage, diagramClass));
        }
        return item;
    }

    public ResolvedItem process(EClass domainClass, EPackage domainPackage, EClass diagramClass) {
        ResolvedItem item;
        TypePattern pattern = this.resolver.resolve(domainClass, domainPackage);
        if (pattern instanceof NodePattern) {
            Resolution resolution = Resolution.NODE;
            if (diagramClass != null && !ContainmentClosure.contains(diagramClass, domainClass, domainPackage)) {
                resolution = null;
            }
            item = new ResolvedItem(resolution, domainClass, pattern, ResolvedItem.NODE_LINK_RESOLUTIONS);
            NodePattern nodePattern = (NodePattern)pattern;
            this.addLabels(item, nodePattern);
            Resolution linkResolution = item.getResolution() == null ? null : Resolution.LINK;
            int i = 0;
            while (i < nodePattern.getRefLinks().length) {
                item.addChild(new ResolvedItem(linkResolution, nodePattern.getRefLinks()[i], null, ResolvedItem.LINK_RESOLUTIONS));
                ++i;
            }
        } else if (pattern instanceof TypeLinkPattern) {
            TypeLinkPattern linkPattern;
            Resolution resolution = Resolution.LINK;
            if (diagramClass != null) {
                linkPattern = (TypeLinkPattern)pattern;
                if (linkPattern.getSource() != null && !ContainmentClosure.contains(diagramClass, linkPattern.getSource().getEReferenceType(), domainPackage)) {
                    resolution = null;
                }
                if (linkPattern.getTarget() != null && !ContainmentClosure.contains(diagramClass, linkPattern.getTarget().getEReferenceType(), domainPackage)) {
                    resolution = null;
                }
            }
            item = new ResolvedItem(resolution, domainClass, pattern, ResolvedItem.NODE_LINK_RESOLUTIONS);
            linkPattern = (TypeLinkPattern)pattern;
            this.addLabels(item, linkPattern);
        } else {
            Resolution[] resolutions = ResolvedItem.NODE_LINK_RESOLUTIONS;
            if (domainClass.isAbstract() || domainClass.isInterface()) {
                resolutions = ResolvedItem.DEFAULT_RESOLUTIONS;
            }
            item = new ResolvedItem(null, domainClass, pattern, resolutions);
        }
        return item;
    }

    protected void addLabels(ResolvedItem typeItem, TypePattern pattern) {
        Resolution resolution = typeItem.getResolution() == null ? null : Resolution.LABEL;
        int i = 0;
        while (i < pattern.getLabels().length) {
            typeItem.addChild(new ResolvedItem(resolution, pattern.getLabels()[i], null, ResolvedItem.LABEL_RESOLUTIONS));
            ++i;
        }
    }
}

