/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DuplicateRequest;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.ui.action.AbstractModelActionDelegate;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class DuplicateActionDelegate
extends AbstractModelActionDelegate
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    static /* synthetic */ Class class$0;

    protected void doRun(IProgressMonitor progressMonitor) {
        ICommand cmd;
        DuplicateRequest request;
        if (this.getWorkbenchPart() instanceof IDiagramWorkbenchPart) {
            request = new DuplicateRequest();
            cmd = DuplicateActionDelegate.getDuplicateViewCommand(this.getStructuredSelection(), this.getWorkbenchPart(), request);
        } else {
            request = new DuplicateElementsRequest(DuplicateActionDelegate.getEditingDomain(this.getStructuredSelection()));
            cmd = DuplicateActionDelegate.getDuplicateElementsCommand(this.getStructuredSelection(), (DuplicateElementsRequest)request);
        }
        if (cmd != null && cmd.canExecute()) {
            try {
                IStatus status = cmd.execute(progressMonitor, null);
                this.setStatus(status);
                if (status.isOK() && request instanceof DuplicateRequest) {
                    this.selectViews(request.getDuplicatedViews());
                }
            }
            catch (ExecutionException e) {
                Status status = new Status(4, DiagramUIPlugin.getPluginId(), 4, e.getLocalizedMessage(), (Throwable)e);
                this.setStatus((IStatus)status);
                Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"doRun", (Throwable)e);
                Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)4, (String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    static boolean canDuplicate(IStructuredSelection selection, IWorkbenchPart workbenchPart) {
        ICommand cmd;
        ICommand iCommand = cmd = workbenchPart instanceof IDiagramWorkbenchPart ? DuplicateActionDelegate.getDuplicateViewCommand(selection, workbenchPart, new DuplicateRequest()) : DuplicateActionDelegate.getDuplicateElementsCommand(selection, new DuplicateElementsRequest(DuplicateActionDelegate.getEditingDomain(selection)));
        return cmd != null && cmd.canExecute();
    }

    private static ICommand getDuplicateElementsCommand(IStructuredSelection selection, DuplicateElementsRequest request) {
        HashSet<EObject> elements = new HashSet<EObject>();
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            EObject element;
            IAdaptable iAdaptable = (IAdaptable)i.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.ecore.EObject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((element = (EObject)iAdaptable.getAdapter((Class)clazz)) == null) continue;
            elements.add(element);
        }
        if (!elements.isEmpty()) {
            request.setElementsToBeDuplicated(new ArrayList(elements));
            IElementType elementType = ElementTypeRegistry.getInstance().getElementType(request.getEditHelperContext());
            if (elementType != null) {
                return elementType.getEditCommand((IEditCommandRequest)request);
            }
        }
        return null;
    }

    private static ICommand getDuplicateViewCommand(IStructuredSelection selection, IWorkbenchPart workbenchPart, DuplicateRequest request) {
        ArrayList eps = new ArrayList();
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            Object selectedItem = i.next();
            if (!(selectedItem instanceof IGraphicalEditPart)) continue;
            eps.add(selectedItem);
        }
        if (!eps.isEmpty()) {
            request.setEditParts(eps);
            Command cmd = ((IDiagramWorkbenchPart)workbenchPart).getDiagramEditPart().getCommand((Request)request);
            if (cmd != null && cmd.canExecute()) {
                return new CommandProxy(cmd);
            }
        }
        return null;
    }

    private void selectViews(List views) {
        IDiagramGraphicalViewer viewer = ((IDiagramWorkbenchPart)this.getWorkbenchPart()).getDiagramGraphicalViewer();
        if (viewer != null && views != null && !views.isEmpty()) {
            ArrayList editparts = new ArrayList();
            Iterator iter = views.iterator();
            while (iter.hasNext()) {
                Object ep;
                Object view = iter.next();
                if (!(view instanceof View) || (ep = viewer.getEditPartRegistry().get(view)) == null) continue;
                editparts.add(ep);
            }
            if (!editparts.isEmpty()) {
                viewer.setSelection((ISelection)new StructuredSelection(editparts));
            }
        }
    }

    public static TransactionalEditingDomain getEditingDomain(IStructuredSelection selection) {
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            TransactionalEditingDomain editingDomain;
            EObject element;
            IAdaptable iAdaptable = (IAdaptable)i.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.emf.ecore.EObject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((element = (EObject)iAdaptable.getAdapter((Class)clazz)) == null || (editingDomain = TransactionUtil.getEditingDomain((EObject)element)) == null) continue;
            return editingDomain;
        }
        return null;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return DuplicateActionDelegate.getEditingDomain(this.getStructuredSelection());
    }
}

