/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.commands.core.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.CompositeChangeDescription;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;

public abstract class AbstractTransactionalCommand
extends AbstractEMFOperation
implements ICommand {
    private final List affectedFiles;
    private CommandResult commandResult;

    protected static List getWorkspaceFiles(EObject eObject) {
        IFile file;
        Resource resource;
        ArrayList<IFile> result = new ArrayList<IFile>();
        if (eObject != null && (resource = eObject.eResource()) != null && (file = WorkspaceSynchronizer.getFile((Resource)resource)) != null) {
            result.add(file);
        }
        return result;
    }

    protected static List getWorkspaceFiles(List eObjects) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        Iterator i = eObjects.iterator();
        while (i.hasNext()) {
            IFile file;
            Resource resource;
            Object next = i.next();
            if (!(next instanceof EObject) || (resource = ((EObject)next).eResource()) == null || (file = WorkspaceSynchronizer.getFile((Resource)resource)) == null) continue;
            result.add(file);
        }
        return result;
    }

    public AbstractTransactionalCommand(TransactionalEditingDomain domain, String label, List affectedFiles) {
        this(domain, label, null, affectedFiles);
    }

    public AbstractTransactionalCommand(TransactionalEditingDomain domain, String label, Map options, List affectedFiles) {
        super(domain, label, options);
        this.affectedFiles = affectedFiles == null ? new ArrayList() : affectedFiles;
    }

    public List getAffectedFiles() {
        return this.affectedFiles;
    }

    public final CommandResult getCommandResult() {
        return this.commandResult;
    }

    protected final void setResult(CommandResult result) {
        this.commandResult = result;
    }

    public ICommand compose(IUndoableOperation operation) {
        if (operation != null) {
            return new CompositeTransactionalCommand(this.getEditingDomain(), this.getLabel()).compose((IUndoableOperation)this).compose(operation);
        }
        return this;
    }

    public ICommand reduce() {
        return this;
    }

    protected abstract CommandResult doExecuteWithResult(IProgressMonitor var1, IAdaptable var2) throws ExecutionException;

    protected void didUndo(Transaction tx) {
        if (tx.getChangeDescription() != null && !tx.getChangeDescription().isEmpty()) {
            ((CompositeChangeDescription)this.getChange()).add((ChangeDescription)tx.getChangeDescription());
        }
    }

    protected void didRedo(Transaction tx) {
        if (tx.getChangeDescription() != null && !tx.getChangeDescription().isEmpty()) {
            ((CompositeChangeDescription)this.getChange()).add((ChangeDescription)tx.getChangeDescription());
        }
    }

    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        CommandResult result = this.doExecuteWithResult(monitor, info);
        this.setResult(result);
        this.cleanup();
        return result != null ? result.getStatus() : Status.OK_STATUS;
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = super.doUndo(monitor, info);
        CommandResult result = new CommandResult(status);
        this.setResult(result);
        return status;
    }

    protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = super.doRedo(monitor, info);
        CommandResult result = new CommandResult(status);
        this.setResult(result);
        return status;
    }

    protected IStatus aggregateStatuses(List statuses) {
        IStatus status = super.aggregateStatuses(statuses);
        CommandResult result = this.getCommandResult();
        if (result == null) {
            result = new CommandResult(status);
            this.setResult(result);
        } else if (status != result.getStatus()) {
            result = new CommandResult(status, result.getReturnValue());
            this.setResult(result);
        }
        return status;
    }

    protected void cleanup() {
    }
}

