/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.codegen;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StaticFieldsManager {
    private final Map myFields = new HashMap();
    private final Map myFieldsRO = Collections.unmodifiableMap(this.myFields);
    private final String myDeclaringClassPrefix;

    public StaticFieldsManager(String declaringClassName) {
        this.myDeclaringClassPrefix = declaringClassName == null || declaringClassName.length() == 0 ? "" : String.valueOf(declaringClassName) + ".";
    }

    public StaticFieldsManager() {
        this(null);
    }

    public String addStaticField(String type, String nameHint, String value) {
        String actualName;
        int suffix = 0;
        do {
            actualName = String.valueOf(nameHint) + (suffix == 0 ? "" : "_" + suffix);
            ++suffix;
        } while (this.myFields.containsKey(actualName));
        StaticField field = new StaticField(type, actualName, value);
        this.myFields.put(actualName, field);
        return String.valueOf(this.myDeclaringClassPrefix) + actualName;
    }

    public void reset() {
        this.myFields.clear();
    }

    public Iterator allFields() {
        return this.myFieldsRO.values().iterator();
    }

    public static class StaticField {
        private final String myType;
        private final String myName;
        private final String myValue;

        public StaticField(String type, String name, String value) {
            this.myType = type;
            this.myName = name;
            this.myValue = value;
        }

        public String getName() {
            return this.myName;
        }

        public String getType() {
            return this.myType;
        }

        public String getValue() {
            return this.myValue;
        }
    }
}

