/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;

public class DeferredLayoutCommand
extends AbstractTransactionalCommand {
    protected String layoutType;
    protected List viewAdapters;
    protected IGraphicalEditPart containerEP;
    protected Command layoutCmd;
    static /* synthetic */ Class class$0;

    public DeferredLayoutCommand(TransactionalEditingDomain editingDomain, List viewAdapters, IGraphicalEditPart containerEP) {
        this(editingDomain, viewAdapters, containerEP, "DEFAULT");
    }

    public DeferredLayoutCommand(TransactionalEditingDomain editingDomain, List viewAdapters, IGraphicalEditPart containerEP, String commandLayoutType) {
        super(editingDomain, DiagramUIMessages.Command_Deferred_Layout, null);
        this.layoutType = commandLayoutType != null ? commandLayoutType : "DEFAULT";
        this.viewAdapters = viewAdapters;
        this.containerEP = containerEP;
    }

    public List getAffectedFiles() {
        View view;
        if (this.containerEP != null && (view = (View)this.containerEP.getModel()) != null) {
            IFile f = WorkspaceSynchronizer.getFile((Resource)view.eResource());
            return f != null ? Collections.singletonList(f) : Collections.EMPTY_LIST;
        }
        return super.getAffectedFiles();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        RunnableWithResult refreshRunnable = new RunnableWithResult(){
            private IStatus status;
            private Object result;

            public Object getResult() {
                return this.result;
            }

            public void setStatus(IStatus status) {
                this.status = status;
            }

            public IStatus getStatus() {
                return this.status;
            }

            public void run() {
                Object ep;
                DeferredLayoutCommand.this.containerEP.refresh();
                DeferredLayoutCommand.this.getContainerFigure().invalidate();
                DeferredLayoutCommand.this.getContainerFigure().validate();
                ArrayList editParts = new ArrayList(DeferredLayoutCommand.this.viewAdapters.size());
                Map epRegistry = DeferredLayoutCommand.this.containerEP.getRoot().getViewer().getEditPartRegistry();
                Iterator iter = DeferredLayoutCommand.this.viewAdapters.iterator();
                while (iter.hasNext()) {
                    View view;
                    IAdaptable ad = (IAdaptable)iter.next();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.gmf.runtime.notation.View");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((ep = epRegistry.get(view = (View)ad.getAdapter((Class)clazz))) == null) continue;
                    editParts.add(ep);
                }
                if (editParts.isEmpty()) {
                    this.result = editParts;
                    return;
                }
                HashSet layoutSet = new HashSet(editParts.size());
                layoutSet.addAll(editParts);
                Iterator iter2 = DeferredLayoutCommand.this.containerEP.getChildren().iterator();
                while (iter2.hasNext()) {
                    Object obj = iter2.next();
                    if (layoutSet.contains(obj) || !(obj instanceof IGraphicalEditPart)) continue;
                    ep = (IGraphicalEditPart)obj;
                    ep.refresh();
                }
                this.result = editParts;
            }
        };
        EditPartUtil.synchronizeRunnableToMainThread(this.containerEP, (Runnable)refreshRunnable);
        List editParts = (List)refreshRunnable.getResult();
        if (editParts == null || editParts.isEmpty()) {
            return CommandResult.newOKCommandResult();
        }
        ArrangeRequest request = new ArrangeRequest("arrangeSelectionAction", this.layoutType);
        request.setPartsToArrange(editParts);
        this.layoutCmd = this.containerEP.getCommand(request);
        if (this.layoutCmd != null && this.layoutCmd.canExecute()) {
            this.layoutCmd.execute();
        }
        return CommandResult.newOKCommandResult();
    }

    protected void cleanup() {
        this.containerEP = null;
        this.viewAdapters = null;
        super.cleanup();
    }

    protected IFigure getContainerFigure() {
        return this.containerEP.getFigure();
    }

    protected IGraphicalEditPart getContainerEP() {
        return this.containerEP;
    }

    protected List getViewAdapters() {
        return this.viewAdapters;
    }
}

