/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editparts;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ViewportExposeHelper;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableCompartmentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.NestedResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Ratio;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;

public class NestableListItemEditPart
extends ListItemEditPart
implements IResizableCompartmentEditPart {
    static final int IS_RESIZABLE_FLAG = 64;
    WrapLabel textLabel = null;
    static /* synthetic */ Class class$0;

    public NestableListItemEditPart(EObject view) {
        super(view);
        Node node;
        Style style;
        this.setFlag(64, false);
        Object model = this.getModel();
        if (model instanceof Node && (style = (node = (Node)model).getStyle(NotationPackage.eINSTANCE.getDrawerStyle())) != null) {
            this.setFlag(64, true);
        }
    }

    public WrapLabel getLabel() {
        if (this.isResizable()) {
            if (this.textLabel == null) {
                this.textLabel = this.createWrapLabel();
            }
            return this.textLabel;
        }
        return super.getLabel();
    }

    public String getCompartmentName() {
        return this.getLabel().getText();
    }

    protected IFigure createFigure() {
        if (this.isResizable()) {
            NestedResizableCompartmentFigure compartmentFigure = new NestedResizableCompartmentFigure(this.getMapMode());
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setStretchMajorAxis(false);
            layout.setStretchMinorAxis(false);
            layout.setMinorAlignment(1);
            compartmentFigure.getContentPane().setLayoutManager((LayoutManager)layout);
            compartmentFigure.getTextPane().add((IFigure)this.getLabel());
            IMapMode mm = this.getMapMode();
            int one = mm.DPtoLP(1);
            compartmentFigure.getTextPane().setBorder((Border)new MarginBorder(one, mm.DPtoLP(15) / 2, one, mm.DPtoLP(15) / 2));
            compartmentFigure.getContentPane().setBorder((Border)new MarginBorder(one, mm.DPtoLP(15), one, mm.DPtoLP(15) / 2));
            WrapLabel label = this.getLabel();
            label.setLabelAlignment(1);
            label.setVisible(true);
            return compartmentFigure;
        }
        return super.createFigure();
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        if (this.isResizable()) {
            this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new ResizableCompartmentEditPolicy());
        }
    }

    protected final boolean isResizable() {
        return this.getFlag(64);
    }

    protected List getModelChildren() {
        if (this.getModel() instanceof View) {
            return ((View)this.getModel()).getChildren();
        }
        return Collections.EMPTY_LIST;
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.ExposeHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            ViewportExposeHelper helper = new ViewportExposeHelper((GraphicalEditPart)this);
            return helper;
        }
        return super.getAdapter(key);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        if (this.isResizable()) {
            this.refreshCollapsed();
            this.refreshRatio();
        }
    }

    private ResizableCompartmentFigure getCompartmentFigure() {
        if (this.isResizable()) {
            return (ResizableCompartmentFigure)this.getFigure();
        }
        return null;
    }

    public IFigure getContentPane() {
        if (this.getCompartmentFigure() != null) {
            return this.getCompartmentFigure().getContentPane();
        }
        return super.getContentPane();
    }

    protected void handleNotificationEvent(Notification evt) {
        Object feature = evt.getFeature();
        if (NotationPackage.eINSTANCE.getRatio_Value().equals(feature) || evt.getOldValue() instanceof Ratio || evt.getNewValue() instanceof Ratio) {
            this.refreshRatio();
        } else if (NotationPackage.eINSTANCE.getDrawerStyle_Collapsed().equals(feature)) {
            this.setCollapsed((Boolean)evt.getNewValue(), true);
            this.getFigure().revalidate();
        } else {
            super.handleNotificationEvent(evt);
        }
    }

    protected void refreshRatio() {
        if (ViewUtil.isPropertySupported((View)((View)this.getModel()), (Object)Properties.ID_RATIO)) {
            this.setRatio((Double)ViewUtil.getStructuralFeatureValue((View)((View)this.getModel()), (EStructuralFeature)NotationPackage.eINSTANCE.getRatio_Value()));
        } else {
            this.setRatio(new Double(-1.0));
        }
    }

    protected void refreshCollapsed() {
        DrawerStyle style = (DrawerStyle)((View)this.getModel()).getStyle(NotationPackage.eINSTANCE.getDrawerStyle());
        if (style != null) {
            this.setCollapsed(style.isCollapsed(), false);
        }
    }

    protected void setCollapsed(boolean collapsed, boolean animate) {
        if (this.getCompartmentFigure() != null) {
            if (collapsed) {
                if (animate) {
                    this.getCompartmentFigure().collapse();
                } else {
                    this.getCompartmentFigure().setCollapsed();
                }
            } else if (animate) {
                this.getCompartmentFigure().expand();
            } else {
                this.getCompartmentFigure().setExpanded();
            }
        }
    }

    protected void setRatio(Double ratio) {
        ((IGraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), ratio);
    }

    protected void setShowCompartmentTitle(boolean showCompartmentTitle) {
        if (this.getCompartmentFigure() != null) {
            this.getCompartmentFigure().setTitleVisibility(showCompartmentTitle);
        }
    }
}

