/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editpolicies;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class DiagramAssistantEditPolicy
extends GraphicalEditPolicy
implements MouseMotionListener {
    private Runnable hideDiagramAssistantRunnable = new Runnable(){

        public void run() {
            if (DiagramAssistantEditPolicy.this.getMouseLocation() == null || !DiagramAssistantEditPolicy.this.shouldAvoidHidingDiagramAssistant()) {
                DiagramAssistantEditPolicy.this.hideDiagramAssistant();
            }
        }
    };
    private static final int APPEARANCE_DELAY = 200;
    private static final int DISAPPEARANCE_DELAY = 2000;
    private static final int DISAPPEARANCE_DELAY_UPON_EXIT = 1000;
    private Point mouseLocation;
    private FocusListener focusListener = new FocusListener();
    private boolean avoidHidingDiagramAssistant = true;

    protected abstract boolean isDiagramAssistant(Object var1);

    protected abstract boolean isDiagramAssistantShowing();

    protected abstract void showDiagramAssistant(Point var1);

    protected abstract void hideDiagramAssistant();

    protected boolean shouldShowDiagramAssistant() {
        return this.getHost().isActive() && this.isPreferenceOn() && this.isHostEditable() && this.isHostResolvable() && this.isDiagramPartActive();
    }

    protected boolean isPreferenceOn() {
        String prefName = this.getPreferenceName();
        if (prefName == null) {
            return true;
        }
        IPreferenceStore preferenceStore = (IPreferenceStore)((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint().getPreferenceStore();
        return preferenceStore.getBoolean(prefName);
    }

    String getPreferenceName() {
        return null;
    }

    private boolean isHostEditable() {
        if (this.getHost() instanceof GraphicalEditPart) {
            return ((GraphicalEditPart)this.getHost()).isEditModeEnabled();
        }
        return true;
    }

    private boolean isHostResolvable() {
        final View view = (View)this.getHost().getModel();
        if (view.getElement() != null) {
            try {
                Boolean retval = (Boolean)((IGraphicalEditPart)this.getHost()).getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                    public void run() {
                        this.setResult(ViewUtil.resolveSemanticElement((View)view) != null ? Boolean.TRUE : Boolean.FALSE);
                    }
                });
                return retval;
            }
            catch (InterruptedException e) {
                Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"isHostResolvable", (Throwable)e);
                Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"isHostResolvable", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private boolean isDiagramPartActive() {
        IWorkbenchPart activePart;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (activePart = page.getActivePart()) instanceof IDiagramWorkbenchPart) {
            return ((IDiagramWorkbenchPart)activePart).getDiagramEditPart().getRoot().equals(((IGraphicalEditPart)this.getHost()).getRoot());
        }
        return false;
    }

    protected void showDiagramAssistantAfterDelay(int delay) {
        if (this.shouldShowDiagramAssistant()) {
            Display.getCurrent().timerExec(delay, (Runnable)new ShowDiagramAssistantRunnable(this.getMouseLocation()));
        }
    }

    protected void hideDiagramAssistantAfterDelay(int delay) {
        if (this.isDiagramAssistantShowing()) {
            Display.getCurrent().timerExec(delay, this.hideDiagramAssistantRunnable);
        }
    }

    public void activate() {
        super.activate();
        ((IGraphicalEditPart)this.getHost()).getFigure().addMouseMotionListener((MouseMotionListener)this);
        ((IGraphicalEditPart)this.getHost()).addEditPartListener((EditPartListener)this.focusListener);
    }

    public void deactivate() {
        ((IGraphicalEditPart)this.getHost()).getFigure().removeMouseMotionListener((MouseMotionListener)this);
        ((IGraphicalEditPart)this.getHost()).removeEditPartListener((EditPartListener)this.focusListener);
        this.hideDiagramAssistant();
        super.deactivate();
    }

    public void mouseEntered(MouseEvent me) {
        this.setMouseLocation(me.getLocation());
    }

    public void mouseExited(MouseEvent me) {
        this.setMouseLocation(null);
        this.hideDiagramAssistantAfterDelay(this.getDisappearanceDelayUponExit());
    }

    public void mouseMoved(MouseEvent me) {
        this.setMouseLocation(me.getLocation());
        this.setAvoidHidingDiagramAssistant(this.isDiagramAssistant(me.getSource()));
        this.showDiagramAssistantAfterDelay(this.getAppearanceDelay());
    }

    public void mouseHover(MouseEvent me) {
    }

    public void mouseDragged(MouseEvent me) {
    }

    protected int getAppearanceDelay() {
        return 200;
    }

    protected int getDisappearanceDelay() {
        return 2000;
    }

    protected int getDisappearanceDelayUponExit() {
        return 1000;
    }

    protected Point getMouseLocation() {
        return this.mouseLocation;
    }

    protected void setMouseLocation(Point mouseLocation) {
        this.mouseLocation = mouseLocation;
    }

    protected void setAvoidHidingDiagramAssistant(boolean avoidHidingDiagramAssistant) {
        this.avoidHidingDiagramAssistant = avoidHidingDiagramAssistant;
    }

    protected boolean shouldAvoidHidingDiagramAssistant() {
        return this.avoidHidingDiagramAssistant;
    }

    private class ShowDiagramAssistantRunnable
    implements Runnable {
        private Point originalMouseLocation;

        protected ShowDiagramAssistantRunnable(Point originalMouseLocation) {
            this.originalMouseLocation = originalMouseLocation;
        }

        public void run() {
            if (this.originalMouseLocation != null && this.originalMouseLocation.equals((Object)DiagramAssistantEditPolicy.this.getMouseLocation())) {
                if (DiagramAssistantEditPolicy.this.isDiagramAssistantShowing() && !DiagramAssistantEditPolicy.this.shouldAvoidHidingDiagramAssistant()) {
                    DiagramAssistantEditPolicy.this.hideDiagramAssistant();
                }
                if (DiagramAssistantEditPolicy.this.shouldShowDiagramAssistant()) {
                    DiagramAssistantEditPolicy.this.showDiagramAssistant(this.originalMouseLocation);
                }
            }
        }
    }

    private class FocusListener
    extends EditPartListener.Stub {
        private FocusListener() {
        }

        public void selectedStateChanged(EditPart part) {
            if (part.hasFocus() && DiagramAssistantEditPolicy.this.shouldShowDiagramAssistant()) {
                DiagramAssistantEditPolicy.this.showDiagramAssistant(DiagramAssistantEditPolicy.this.getMouseLocation());
            } else {
                DiagramAssistantEditPolicy.this.hideDiagramAssistant();
            }
        }
    }
}

