/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.figures;

import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ListScrollBar;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.OverlayScrollPaneLayout;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class ShapeCompartmentFigure
extends ResizableCompartmentFigure {
    public static final Font FONT_TITLE = new Font(null, new FontData("Helvetica", 9, 1));

    public ShapeCompartmentFigure(String title, IMapMode mm) {
        super(title, mm);
        this.configureFigure(mm);
    }

    protected void configureFigure() {
        this.configureFigure(MapModeUtil.getMapMode((IFigure)this));
    }

    protected void configureFigure(IMapMode mm) {
        ScrollPane scrollpane = this.getScrollPane();
        scrollpane.setViewport((Viewport)new FreeformViewport());
        Insets insets = new Insets(mm.DPtoLP(1), mm.DPtoLP(2), mm.DPtoLP(1), mm.DPtoLP(0));
        Dimension size = new Dimension(mm.DPtoLP(15), mm.DPtoLP(15));
        scrollpane.setHorizontalScrollBar((ScrollBar)new ListScrollBar(0, insets, size, mm.DPtoLP(10), mm.DPtoLP(50)));
        scrollpane.setVerticalScrollBar((ScrollBar)new ListScrollBar(1, insets, size, mm.DPtoLP(10), mm.DPtoLP(50)));
        scrollpane.setScrollBarVisibility(1);
        scrollpane.setLayoutManager((LayoutManager)new OverlayScrollPaneLayout());
        FreeformLayer contents = new FreeformLayer();
        contents.setLayoutManager((LayoutManager)new FreeformLayout());
        scrollpane.setContents((IFigure)contents);
        int MB = mm.DPtoLP(5);
        scrollpane.setBorder((Border)new MarginBorder(MB, MB, MB, MB));
        int SZ = mm.DPtoLP(10);
        scrollpane.setMinimumSize(new Dimension(SZ, SZ));
        this.setFont(FONT_TITLE);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getScrollPane().getViewport().getVerticalRangeModel().addPropertyChangeListener(listener);
        this.getScrollPane().getViewport().getHorizontalRangeModel().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getScrollPane().getViewport().getVerticalRangeModel().removePropertyChangeListener(listener);
        this.getScrollPane().getViewport().getHorizontalRangeModel().removePropertyChangeListener(listener);
    }
}

