/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.commands;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;

public class ToggleCanonicalModeCommand
extends Command {
    private boolean _enable;
    private Collection _semanticHosts = new ArrayList();

    public ToggleCanonicalModeCommand(Collection editParts, boolean enable) {
        super(DiagramUIMessages.ToggleCanonicalModeCommand_Label);
        Object[] editparts = new Object[editParts.size()];
        editParts.toArray(editparts);
        int i = 0;
        while (i < editparts.length) {
            CanonicalEditPolicy editPolicy;
            EditPart editPart = (EditPart)editparts[i];
            if (editPart != null && (editPolicy = ToggleCanonicalModeCommand.getCanonicalEditPolicy(editPart)) != null) {
                this._semanticHosts.add(new WeakReference<EObject>(editPolicy.getSemanticHost()));
            }
            ++i;
        }
        this._enable = enable;
    }

    public ToggleCanonicalModeCommand(EObject element, boolean enable) {
        super(DiagramUIMessages.ToggleCanonicalModeCommand_Label);
        this._semanticHosts.add(new WeakReference<EObject>(element));
        this._enable = enable;
    }

    public ToggleCanonicalModeCommand(EditPart target, boolean enable) {
        this(Collections.singletonList(target), enable);
    }

    public static ToggleCanonicalModeCommand getToggleCanonicalModeCommand(Collection editParts, boolean enable) {
        ToggleCanonicalModeCommand cmd = new ToggleCanonicalModeCommand(editParts, enable);
        return cmd.getSemanticHosts().isEmpty() ? null : cmd;
    }

    public static ToggleCanonicalModeCommand getToggleCanonicalModeCommand(ToggleCanonicalModeCommand tcmd, boolean enable) {
        if (tcmd == null || tcmd.getSemanticHosts().isEmpty()) {
            return null;
        }
        ToggleCanonicalModeCommand cmd = new ToggleCanonicalModeCommand(Collections.EMPTY_LIST, enable);
        cmd.setSemanticHosts(tcmd.getSemanticHosts());
        return cmd;
    }

    protected final Collection getSemanticHosts() {
        return this._semanticHosts;
    }

    private final void setSemanticHosts(Collection hosts) {
        this._semanticHosts.clear();
        this._semanticHosts.addAll(hosts);
    }

    protected static CanonicalEditPolicy getCanonicalEditPolicy(EditPart editPart) {
        return (CanonicalEditPolicy)editPart.getEditPolicy((Object)"Canonical");
    }

    public void execute() {
        this.DoEnable(this._enable);
    }

    private void DoEnable(boolean enable) {
        Iterator references = this.getSemanticHosts().iterator();
        while (references.hasNext()) {
            WeakReference wr = (WeakReference)references.next();
            EObject semanticHost = (EObject)wr.get();
            if (semanticHost == null) continue;
            List ceps = CanonicalEditPolicy.getRegisteredEditPolicies(semanticHost);
            int i = 0;
            while (i < ceps.size()) {
                CanonicalEditPolicy cep = (CanonicalEditPolicy)((Object)ceps.get(i));
                cep.enableRefresh(enable);
                ++i;
            }
        }
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        this.DoEnable(!this._enable);
    }
}

