/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies;

import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TopGraphicEditPart;

public class DelegatingMouseEventsEditPolicy
extends AbstractEditPolicy
implements MouseMotionListener {
    private final String editPolicyRole;

    public DelegatingMouseEventsEditPolicy(String editPolicyRole) {
        this.editPolicyRole = editPolicyRole;
    }

    public void activate() {
        super.activate();
        ((IGraphicalEditPart)this.getHost()).getFigure().addMouseMotionListener((MouseMotionListener)this);
    }

    public void deactivate() {
        ((IGraphicalEditPart)this.getHost()).getFigure().removeMouseMotionListener((MouseMotionListener)this);
        super.deactivate();
    }

    private MouseMotionListener getParentEditPolicy() {
        EditPart parentEP = this.getHost().getParent();
        while (parentEP != null) {
            EditPolicy editPolicy = parentEP.getEditPolicy((Object)this.editPolicyRole);
            if (editPolicy != null && editPolicy instanceof MouseMotionListener) {
                return (MouseMotionListener)editPolicy;
            }
            if (parentEP instanceof TopGraphicEditPart) {
                return null;
            }
            parentEP = parentEP.getParent();
        }
        return null;
    }

    public void mouseEntered(MouseEvent me) {
        MouseMotionListener parentPolicy = this.getParentEditPolicy();
        if (parentPolicy != null) {
            parentPolicy.mouseEntered(me);
        }
    }

    public void mouseExited(MouseEvent me) {
        MouseMotionListener parentPolicy = this.getParentEditPolicy();
        if (parentPolicy != null) {
            parentPolicy.mouseExited(me);
        }
    }

    public void mouseHover(MouseEvent me) {
        MouseMotionListener parentPolicy = this.getParentEditPolicy();
        if (parentPolicy != null) {
            parentPolicy.mouseHover(me);
        }
    }

    public void mouseMoved(MouseEvent me) {
        MouseMotionListener parentPolicy = this.getParentEditPolicy();
        if (parentPolicy != null) {
            parentPolicy.mouseMoved(me);
        }
    }

    public void mouseDragged(MouseEvent me) {
        MouseMotionListener parentPolicy = this.getParentEditPolicy();
        if (parentPolicy != null) {
            parentPolicy.mouseDragged(me);
        }
    }
}

