/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.menus;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class PopupMenu {
    private List content;
    private ILabelProvider labelProvider;
    private List resultList = new ArrayList();

    public PopupMenu(List aContent, ILabelProvider aLabelProvider) {
        this.setContent(aContent);
        this.setLabelProvider(aLabelProvider);
    }

    public boolean show(Control parent) {
        Menu menu = new Menu(parent);
        this.createMenuItems(menu, this, new ArrayList());
        menu.setVisible(true);
        Display display = menu.getDisplay();
        while (!menu.isDisposed() && menu.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!menu.isDisposed()) {
            menu.dispose();
            if (this.getResult() != null) {
                return true;
            }
        }
        return false;
    }

    protected void createMenuItems(Menu parentMenu, final PopupMenu rootMenu, final List resultThusFar) {
        Assert.isNotNull((Object)this.getContent());
        Assert.isNotNull((Object)this.getLabelProvider());
        Iterator iter = this.getContent().iterator();
        while (iter.hasNext()) {
            MenuItem menuItem;
            Object contentObject = iter.next();
            if (contentObject instanceof CascadingMenu) {
                PopupMenu subMenu = ((CascadingMenu)contentObject).getSubMenu();
                contentObject = ((CascadingMenu)contentObject).getParentMenuItem();
                ArrayList thisResult = new ArrayList(resultThusFar);
                thisResult.add(contentObject);
                menuItem = new MenuItem(parentMenu, 64);
                menuItem.setMenu(new Menu(parentMenu));
                subMenu.createMenuItems(menuItem.getMenu(), rootMenu, thisResult);
            } else {
                menuItem = new MenuItem(parentMenu, 0);
            }
            final Object fContentObject = contentObject;
            menuItem.setText(this.getLabelProvider().getText(contentObject));
            menuItem.setImage(this.getLabelProvider().getImage(contentObject));
            menuItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    resultThusFar.add(fContentObject);
                    rootMenu.setResult(resultThusFar);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    resultThusFar.add(fContentObject);
                    rootMenu.setResult(resultThusFar);
                }
            });
        }
    }

    protected List getContent() {
        return this.content;
    }

    public void setContent(List aContent) {
        this.content = aContent;
    }

    protected ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(ILabelProvider aLabelProvider) {
        this.labelProvider = aLabelProvider;
    }

    public Object getResult() {
        if (this.resultList == null || this.resultList.isEmpty()) {
            return null;
        }
        if (this.resultList.size() == 1) {
            return this.resultList.get(0);
        }
        return this.resultList;
    }

    protected void setResult(List aResultList) {
        this.resultList = aResultList;
    }

    public static class CascadingMenu {
        private Object parentMenuItem;
        private PopupMenu subMenu;

        public CascadingMenu(Object aParentMenuItem, PopupMenu aSubMenu) {
            this.parentMenuItem = aParentMenuItem;
            this.subMenu = aSubMenu;
        }

        public Object getParentMenuItem() {
            return this.parentMenuItem;
        }

        public PopupMenu getSubMenu() {
            return this.subMenu;
        }
    }
}

