/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IElementTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.IEditHelperAdviceDescriptor;

public class MultiClientContext
implements IClientContext {
    public static final String MULTI_CLIENT_CONTEXT_ID = "multi_client_context_ID";
    private final Set children;
    private IElementMatcher matcher;

    public MultiClientContext(Collection childContexts) {
        this.children = new HashSet(childContexts.size());
        Iterator i = childContexts.iterator();
        while (i.hasNext()) {
            IClientContext next = (IClientContext)i.next();
            if (next.isMultiClientContext()) {
                Collection nested = ((MultiClientContext)next).getChildren();
                this.children.addAll(nested);
                continue;
            }
            this.children.add(next);
        }
    }

    public boolean isMultiClientContext() {
        return true;
    }

    public void add(IClientContext context) {
        if (context.isMultiClientContext()) {
            this.children.addAll(context.getChildren());
        } else {
            this.children.add(context);
        }
    }

    public final String getId() {
        return MULTI_CLIENT_CONTEXT_ID;
    }

    public Collection getChildren() {
        return this.children;
    }

    public final IElementMatcher getMatcher() {
        if (this.matcher == null) {
            this.matcher = new IElementMatcher(){

                public boolean matches(EObject eObject) {
                    boolean result = !MultiClientContext.this.getChildren().isEmpty();
                    Iterator i = MultiClientContext.this.getChildren().iterator();
                    while (result && i.hasNext()) {
                        IClientContext next = (IClientContext)i.next();
                        if (next.getMatcher().matches(eObject)) continue;
                        result = false;
                    }
                    return result;
                }
            };
        }
        return this.matcher;
    }

    public void bindId(String typeId) {
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            IClientContext next = (IClientContext)i.next();
            next.bindId(typeId);
        }
    }

    public void bindPattern(Pattern pattern) {
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            IClientContext next = (IClientContext)i.next();
            next.bindPattern(pattern);
        }
    }

    public boolean includes(IElementTypeDescriptor elementTypeDescriptor) {
        boolean result = !this.getChildren().isEmpty();
        Iterator i = this.getChildren().iterator();
        while (result && i.hasNext()) {
            IClientContext next = (IClientContext)i.next();
            if (next.includes(elementTypeDescriptor)) continue;
            result = false;
        }
        return result;
    }

    public boolean includes(IElementType elementType) {
        boolean result = !this.getChildren().isEmpty();
        Iterator i = this.getChildren().iterator();
        while (result && i.hasNext()) {
            IClientContext next = (IClientContext)i.next();
            if (next.includes(elementType)) continue;
            result = false;
        }
        return result;
    }

    public boolean includes(IEditHelperAdviceDescriptor advice) {
        boolean result = !this.getChildren().isEmpty();
        Iterator i = this.getChildren().iterator();
        while (result && i.hasNext()) {
            IClientContext next = (IClientContext)i.next();
            if (next.includes(advice)) continue;
            result = false;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MultiClientContext) {
            return this.getChildren().equals(((MultiClientContext)obj).getChildren());
        }
        return false;
    }

    public int hashCode() {
        return this.getChildren().hashCode();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            b.append(((IClientContext)i.next()).getId());
            if (!i.hasNext()) continue;
            b.append(",");
        }
        return "ClientMultiContext[" + b + ']';
    }
}

