/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.graphics;

import java.awt.BasicStroke;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.Stack;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderInfo;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.image.ImageConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.GdiFont;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.DrawableRenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.RenderingListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class GraphicsToGraphics2DAdaptor
extends Graphics
implements DrawableRenderedImage {
    private SWTGraphics swtGraphics;
    private Graphics2D graphics2D;
    private BasicStroke stroke;
    private Stack states = new Stack();
    private final State currentState = new State();
    private final State appliedState = new State();
    private Rectangle relativeClipRegion;
    private org.eclipse.swt.graphics.Rectangle viewBox;
    private int transX = 0;
    private int transY = 0;
    static /* synthetic */ Class class$0;

    public GraphicsToGraphics2DAdaptor(Graphics2D graphics, Rectangle viewPort) {
        this(graphics, new org.eclipse.swt.graphics.Rectangle(viewPort.x, viewPort.y, viewPort.width, viewPort.height));
    }

    public GraphicsToGraphics2DAdaptor(Graphics2D graphics, org.eclipse.swt.graphics.Rectangle viewPort) {
        this.viewBox = viewPort;
        this.createSWTGraphics();
        this.initSVGGraphics(graphics);
        this.init();
    }

    private void createSWTGraphics() {
        org.eclipse.swt.graphics.Rectangle tempRect = new org.eclipse.swt.graphics.Rectangle(0, 0, 10, 10);
        Image image = new Image((Device)Display.getDefault(), tempRect);
        GC gc = new GC((Drawable)image);
        this.swtGraphics = new SWTGraphics(gc);
    }

    private void initSVGGraphics(Graphics2D graphics) {
        this.graphics2D = graphics;
        this.relativeClipRegion = new Rectangle(this.viewBox.x, this.viewBox.y, this.viewBox.width, this.viewBox.height);
        this.stroke = new BasicStroke(this.swtGraphics.getLineWidth(), 2, 1, 0.0f, null, 0.0f);
        this.setLineStyle(this.swtGraphics.getLineStyle());
        this.setLineWidth(this.swtGraphics.getLineWidth());
        this.getGraphics2D().setStroke(this.stroke);
    }

    private void init() {
        this.setLineStyle(this.getLineStyle());
        this.setLineWidth(1);
        this.setForegroundColor(this.getForegroundColor());
        this.setBackgroundColor(this.getBackgroundColor());
        this.setXORMode(this.getXORMode());
        this.setFont(this.getFont());
        this.currentState.font = this.appliedState.font = this.getFont();
        this.currentState.translateX = this.appliedState.translateX = this.transX;
        this.currentState.translateY = this.appliedState.translateY = this.transY;
        this.currentState.clipX = this.appliedState.clipX = this.relativeClipRegion.x;
        this.currentState.clipY = this.appliedState.clipY = this.relativeClipRegion.y;
        this.currentState.clipW = this.appliedState.clipW = this.relativeClipRegion.width;
        this.currentState.clipH = this.appliedState.clipH = this.relativeClipRegion.height;
    }

    protected void checkState() {
        if (this.appliedState.font != this.currentState.font) {
            this.appliedState.font = this.currentState.font;
            this.setFont(this.currentState.font);
        }
        if (this.appliedState.clipX != this.currentState.clipX || this.appliedState.clipY != this.currentState.clipY || this.appliedState.clipW != this.currentState.clipW || this.appliedState.clipH != this.currentState.clipH) {
            this.appliedState.clipX = this.currentState.clipX;
            this.appliedState.clipY = this.currentState.clipY;
            this.appliedState.clipW = this.currentState.clipW;
            this.appliedState.clipH = this.currentState.clipH;
            this.getGraphics2D().setClip(this.currentState.clipX - 1, this.currentState.clipY - 1, this.currentState.clipW + 2, this.currentState.clipH + 2);
        }
    }

    public void clipRect(Rectangle rect) {
        this.relativeClipRegion.intersect(rect);
        this.setClipAbsolute(this.relativeClipRegion.x + this.transX, this.relativeClipRegion.y + this.transY, this.relativeClipRegion.width, this.relativeClipRegion.height);
    }

    public void dispose() {
        this.swtGraphics.dispose();
        this.states.clear();
    }

    protected java.awt.Color getColor(Color toConvert) {
        return new java.awt.Color(toConvert.getRed(), toConvert.getGreen(), toConvert.getBlue());
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int endAngle) {
        Arc2D.Float arc = new Arc2D.Float(x + this.transX, y + this.transY, width - 1, height, startAngle, endAngle, 0);
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getForegroundColor()));
        this.getGraphics2D().draw(arc);
    }

    public void fillArc(int x, int y, int w, int h, int offset, int length) {
        Arc2D.Float arc = new Arc2D.Float(x + this.transX, y + this.transY, w, h, offset, length, 0);
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getBackgroundColor()));
        this.getGraphics2D().fill(arc);
    }

    public void drawFocus(int x, int y, int w, int h) {
        this.drawRectangle(x, y, w, h);
    }

    public void drawImage(Image srcImage, int xpos, int ypos) {
        BufferedImage toDraw = ImageConverter.convert(srcImage);
        this.checkState();
        this.getGraphics2D().drawImage(toDraw, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, xpos += this.transX, ypos += this.transY), null);
    }

    public void drawImage(Image srcImage, int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        this.drawImage(srcImage, x2, y2);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        Line2D.Float line = new Line2D.Float(x1 + this.transX, y1 + this.transY, x2 + this.transX, y2 + this.transY);
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getForegroundColor()));
        this.getGraphics2D().draw(line);
    }

    public void drawOval(int x, int y, int w, int h) {
        Ellipse2D.Float ellipse = new Ellipse2D.Float(x + this.transX, y + this.transY, w, h);
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getForegroundColor()));
        this.getGraphics2D().draw(ellipse);
    }

    public void fillOval(int x, int y, int w, int h) {
        Ellipse2D.Float ellipse = new Ellipse2D.Float(x + this.transX, y + this.transY, w - 1, h - 1);
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getBackgroundColor()));
        this.getGraphics2D().fill(ellipse);
    }

    private Polygon createPolygon(PointList pointList) {
        Polygon toCreate = new Polygon();
        int i = 0;
        while (i < pointList.size()) {
            Point pt = pointList.getPoint(i);
            toCreate.addPoint(pt.x + this.transX, pt.y + this.transY);
            ++i;
        }
        return toCreate;
    }

    public void drawPolygon(PointList pointList) {
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getForegroundColor()));
        this.getGraphics2D().draw(this.createPolygon(pointList));
    }

    public void fillPolygon(PointList pointList) {
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getBackgroundColor()));
        this.getGraphics2D().fill(this.createPolygon(pointList));
    }

    public void drawPolyline(PointList pointList) {
        int x = 1;
        while (x < pointList.size()) {
            Point p1 = pointList.getPoint(x - 1);
            Point p2 = pointList.getPoint(x);
            this.drawLine(p1.x, p1.y, p2.x, p2.y);
            ++x;
        }
    }

    public void drawRectangle(int x, int y, int w, int h) {
        Rectangle2D.Float rect = new Rectangle2D.Float(x + this.transX, y + this.transY, w + 1, h + 1);
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getForegroundColor()));
        this.getGraphics2D().draw(rect);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        Rectangle2D.Float rect = new Rectangle2D.Float(x + this.transX, y + this.transY, width, height);
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getBackgroundColor()));
        this.getGraphics2D().fill(rect);
    }

    public void drawRoundRectangle(Rectangle rect, int arcWidth, int arcHeight) {
        RoundRectangle2D.Float roundRect = new RoundRectangle2D.Float(rect.x + this.transX, rect.y + this.transY, rect.width, rect.height, arcWidth, arcHeight);
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getForegroundColor()));
        this.getGraphics2D().draw(roundRect);
    }

    public void fillRoundRectangle(Rectangle rect, int arcWidth, int arcHeight) {
        RoundRectangle2D.Float roundRect = new RoundRectangle2D.Float(rect.x + this.transX, rect.y + this.transY, rect.width, rect.height, arcWidth, arcHeight);
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getBackgroundColor()));
        this.getGraphics2D().fill(roundRect);
    }

    public void drawText(String s, int x, int y) {
        this.drawString(s, x, y);
    }

    public void drawString(String s, int x, int y) {
        int lineWidth;
        if (s == null) {
            return;
        }
        java.awt.FontMetrics metrics = this.getGraphics2D().getFontMetrics();
        int stringLength = metrics.stringWidth(s);
        float xpos = x + this.transX;
        float ypos = y + this.transY;
        this.checkState();
        this.getGraphics2D().setPaint(this.getColor(this.swtGraphics.getForegroundColor()));
        this.getGraphics2D().drawString(s, xpos, ypos += (float)metrics.getAscent());
        if (this.isFontUnderlined(this.getFont())) {
            int baseline = y + metrics.getAscent();
            lineWidth = this.getLineWidth();
            this.setLineWidth(1);
            this.drawLine(x, baseline, x + stringLength, baseline);
            this.setLineWidth(lineWidth);
        }
        if (this.isFontStrikeout(this.getFont())) {
            int strikeline = y + metrics.getHeight() / 2;
            lineWidth = this.getLineWidth();
            this.setLineWidth(1);
            this.drawLine(x, strikeline, x + stringLength, strikeline);
            this.setLineWidth(lineWidth);
        }
    }

    public void fillString(String s, int x, int y) {
    }

    public void fillText(String s, int x, int y) {
    }

    public Color getBackgroundColor() {
        return this.swtGraphics.getBackgroundColor();
    }

    public Rectangle getClip(Rectangle rect) {
        rect.setBounds(this.relativeClipRegion);
        return rect;
    }

    public Font getFont() {
        return this.swtGraphics.getFont();
    }

    public FontMetrics getFontMetrics() {
        return this.swtGraphics.getFontMetrics();
    }

    public Color getForegroundColor() {
        return this.swtGraphics.getForegroundColor();
    }

    public int getLineStyle() {
        return this.swtGraphics.getLineStyle();
    }

    public int getLineWidth() {
        return this.swtGraphics.getLineWidth();
    }

    public boolean getXORMode() {
        return this.swtGraphics.getXORMode();
    }

    public void popState() {
        this.swtGraphics.popState();
        this.restoreState((State)this.states.pop());
    }

    public void pushState() {
        this.swtGraphics.pushState();
        State toPush = new State();
        toPush.copyFrom(this.currentState);
        this.states.push(toPush);
    }

    public void restoreState() {
        this.swtGraphics.restoreState();
        this.restoreState((State)this.states.peek());
    }

    private void restoreState(State state) {
        this.setBackgroundColor(state.bgColor);
        this.setForegroundColor(state.fgColor);
        this.setLineStyle(state.lineStyle);
        this.setLineWidth(state.lineWidth);
        this.setXORMode(state.XorMode);
        this.setClipAbsolute(state.clipX, state.clipY, state.clipW, state.clipH);
        this.transX = this.currentState.translateX = state.translateX;
        this.transY = this.currentState.translateY = state.translateY;
        this.relativeClipRegion.x = state.clipX - this.transX;
        this.relativeClipRegion.y = state.clipY - this.transY;
        this.relativeClipRegion.width = state.clipW;
        this.relativeClipRegion.height = state.clipH;
        this.currentState.font = state.font;
    }

    public void scale(double amount) {
        this.swtGraphics.scale(amount);
    }

    public void setBackgroundColor(Color rgb) {
        this.currentState.bgColor = rgb;
        this.swtGraphics.setBackgroundColor(rgb);
    }

    public void setClip(Rectangle rect) {
        this.relativeClipRegion.x = rect.x;
        this.relativeClipRegion.y = rect.y;
        this.relativeClipRegion.width = rect.width;
        this.relativeClipRegion.height = rect.height;
        this.setClipAbsolute(rect.x + this.transX, rect.y + this.transY, rect.width, rect.height);
    }

    private void setClipAbsolute(int x, int y, int width, int height) {
        this.currentState.clipX = x;
        this.currentState.clipY = y;
        this.currentState.clipW = width;
        this.currentState.clipH = height;
    }

    private boolean isFontUnderlined(Font f) {
        return false;
    }

    private boolean isFontStrikeout(Font f) {
        return false;
    }

    public void setFont(Font f) {
        this.swtGraphics.setFont(f);
        this.currentState.font = f;
        FontData[] fontInfo = f.getFontData();
        if (fontInfo[0] != null) {
            int height = fontInfo[0].getHeight();
            float fsize = (float)height * (float)Display.getDefault().getDPI().x / 72.0f;
            height = Math.round(fsize);
            int style = fontInfo[0].getStyle();
            boolean bItalic = (style & 2) == 2;
            boolean bBold = (style & 1) == 1;
            String faceName = fontInfo[0].getName();
            int escapement = 0;
            boolean bUnderline = this.isFontUnderlined(f);
            boolean bStrikeout = this.isFontStrikeout(f);
            GdiFont font = new GdiFont(height, bItalic, bUnderline, bStrikeout, bBold, faceName, escapement);
            this.getGraphics2D().setFont(font.getFont());
        }
    }

    public void setForegroundColor(Color rgb) {
        this.currentState.fgColor = rgb;
        this.swtGraphics.setForegroundColor(rgb);
    }

    public void setLineDash(int[] dash) {
        float[] dashFlt = new float[dash.length];
        int i = 0;
        while (i < dash.length) {
            dashFlt[i] = dash[i];
            ++i;
        }
        this.currentState.lineDash = dashFlt;
    }

    public void setLineStyle(int style) {
        float[] dashPattern;
        this.currentState.lineStyle = style;
        this.swtGraphics.setLineStyle(style);
        float[] dash = new float[]{18.0f, 9.0f};
        float[] dash_dot = new float[]{9.0f, 3.0f, 3.0f, 3.0f};
        float[] dash_dot_dot = new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};
        float[] dot = new float[]{3.0f, 3.0f};
        switch (style) {
            case 2: {
                dashPattern = dash;
                break;
            }
            case 4: {
                dashPattern = dash_dot;
                break;
            }
            case 5: {
                dashPattern = dash_dot_dot;
                break;
            }
            case 3: {
                dashPattern = dot;
                break;
            }
            case 6: {
                dashPattern = this.currentState.lineDash;
                break;
            }
            default: {
                dashPattern = null;
            }
        }
        this.stroke = new BasicStroke(this.stroke.getLineWidth(), this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), dashPattern, 0.0f);
        this.getGraphics2D().setStroke(this.stroke);
    }

    public void setLineWidth(int width) {
        this.currentState.lineWidth = width;
        this.swtGraphics.setLineWidth(width);
        this.stroke = new BasicStroke(width, this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), 0.0f);
        this.getGraphics2D().setStroke(this.stroke);
    }

    public void setXORMode(boolean xorMode) {
        this.currentState.XorMode = xorMode;
        this.swtGraphics.setXORMode(xorMode);
    }

    private void setTranslation(int x, int y) {
        this.transX = this.currentState.translateX = x;
        this.transY = this.currentState.translateY = y;
    }

    public void translate(int dx, int dy) {
        this.swtGraphics.translate(dx, dy);
        this.setTranslation(this.transX + dx, this.transY + dy);
        this.relativeClipRegion.x -= dx;
        this.relativeClipRegion.y -= dy;
    }

    protected Graphics2D getGraphics2D() {
        return this.graphics2D;
    }

    private SWTGraphics getSWTGraphics() {
        return this.swtGraphics;
    }

    public void fillGradient(int x, int y, int w, int h, boolean vertical) {
        this.checkState();
        java.awt.Color start = this.getColor(this.getSWTGraphics().getForegroundColor());
        java.awt.Color stop = this.getColor(this.getSWTGraphics().getBackgroundColor());
        GradientPaint gradient = vertical ? new GradientPaint(x + this.transX, y + this.transY, start, x + this.transX, y + h + this.transY, stop) : new GradientPaint(x + this.transX, y + this.transY, start, x + w + this.transX, y + this.transY, stop);
        Paint oldPaint = this.getGraphics2D().getPaint();
        this.getGraphics2D().setPaint(gradient);
        this.getGraphics2D().fill(new Rectangle2D.Double(x + this.transX, y + this.transY, w, h));
        this.getGraphics2D().setPaint(oldPaint);
    }

    public RenderedImage drawRenderedImage(RenderedImage srcImage, Rectangle rect, RenderingListener listener) {
        BufferedImage bufImg;
        RenderInfo info = srcImage.getRenderInfo();
        info.setValues(rect.width, rect.height, info.shouldMaintainAspectRatio(), info.shouldAntiAlias(), info.getBackgroundColor(), info.getForegroundColor());
        RenderedImage img = srcImage.getNewRenderedImage(info);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.image.BufferedImage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((bufImg = (BufferedImage)srcImage.getAdapter((Class)clazz)) == null) {
            bufImg = ImageConverter.convert(srcImage.getSWTImage());
        }
        int x = rect.x + this.transX;
        int y = rect.y + this.transY + rect.height - bufImg.getHeight();
        this.checkState();
        this.getGraphics2D().drawImage(bufImg, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), null);
        return img;
    }

    public boolean shouldAllowDelayRender() {
        return false;
    }

    public Dimension getMaximumRenderSize() {
        return null;
    }

    protected Point getTranslationOffset() {
        return new Point(this.transX, this.transY);
    }

    public int getAntialias() {
        Object antiAlias = this.getGraphics2D().getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (antiAlias != null) {
            if (antiAlias.equals(RenderingHints.VALUE_ANTIALIAS_ON)) {
                return 1;
            }
            if (antiAlias.equals(RenderingHints.VALUE_ANTIALIAS_OFF)) {
                return 0;
            }
            if (antiAlias.equals(RenderingHints.VALUE_ANTIALIAS_DEFAULT)) {
                return -1;
            }
        }
        return -1;
    }

    public void setAntialias(int value) {
        if (value == 1) {
            this.getGraphics2D().setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else if (value == 0) {
            this.getGraphics2D().setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    private static class State {
        public int translateX = 0;
        public int translateY = 0;
        public int clipX = 0;
        public int clipY = 0;
        public int clipW = 0;
        public int clipH = 0;
        public Font font;
        public float[] lineDash = new float[]{3.0f, 3.0f};
        public int lineStyle = 1;
        public int lineWidth = 1;
        public boolean XorMode = false;
        public Color fgColor;
        public Color bgColor;

        private State() {
        }

        public void copyFrom(State state) {
            this.translateX = state.translateX;
            this.translateY = state.translateY;
            this.clipX = state.clipX;
            this.clipY = state.clipY;
            this.clipW = state.clipW;
            this.clipH = state.clipH;
            this.font = state.font;
            this.lineStyle = state.lineStyle;
            this.lineWidth = state.lineWidth;
            this.fgColor = state.fgColor;
            this.bgColor = state.bgColor;
            this.XorMode = state.XorMode;
        }
    }
}

