/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.figures;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.AnimationModel;

public class AnimatableScrollPane
extends ScrollPane {
    private AnimationModel animationModel = null;
    private boolean expanded = true;
    private static final long delay = 150L;

    private void animate() {
        this.animationModel = new AnimationModel(150L, this.expanded);
        this.animationModel.animationStarted();
        while (!this.animationModel.isFinished()) {
            this.step();
        }
        this.animationModel = null;
    }

    public void collapse() {
        if (!this.expanded) {
            return;
        }
        this.expanded = false;
        this.animate();
    }

    public void expand() {
        if (this.expanded) {
            return;
        }
        this.expanded = true;
        this.animate();
    }

    public void setExpanded(boolean value) {
        if (this.expanded == value) {
            return;
        }
        this.expanded = value;
        this.revalidate();
    }

    public final boolean isExpanded() {
        return this.expanded;
    }

    private void step() {
        this.revalidate();
        this.getUpdateManager().performUpdate();
    }

    public boolean isOpaque() {
        return false;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.animationModel == null) {
            if (this.expanded) {
                return super.getPreferredSize(wHint, hHint);
            }
            return this.getMinimumSize(wHint, hHint);
        }
        Dimension pref = super.getPreferredSize(wHint, hHint);
        Dimension min = this.getMinimumSize(wHint, hHint);
        float scale = this.animationModel.getProgress();
        return pref.equals((Object)min) ? pref : pref.getScaled((double)scale).expand(min.getScaled((double)(1.0f - scale)));
    }

    public void validate() {
        if (this.isValid()) {
            return;
        }
        this.setValid(true);
        this.layout();
        int i = 0;
        while (i < this.getChildren().size()) {
            ((IFigure)this.getChildren().get(i)).validate();
            ++i;
        }
        if (this.getHorizontalScrollBarVisibility() != 0) {
            this.getHorizontalScrollBar().validate();
        }
        if (this.getVerticalScrollBarVisibility() != 0) {
            this.getVerticalScrollBar().validate();
        }
    }
}

