/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.elementselection;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.AbstractMatchingObject;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.ElementSelectionServiceJob;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IElementSelectionInput;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IElementSelectionListener;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IElementSelectionProvider;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IMatchingObject;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IMatchingObjectEvent;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.MatchingObjectEvent;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.MatchingObjectEventType;
import org.eclipse.gmf.runtime.common.ui.services.internal.l10n.CommonUIServicesMessages;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractElementSelectionProvider
extends AbstractProvider
implements IElementSelectionProvider {
    private IElementSelectionInput elementSelectionInput;
    private IElementSelectionListener elementSelectionListener;

    public boolean provides(IOperation operation) {
        return true;
    }

    public ElementSelectionServiceJob getMatchingObjects(IElementSelectionInput input, IElementSelectionListener listener) {
        this.elementSelectionInput = input;
        this.elementSelectionListener = listener;
        ElementSelectionServiceJob job = new ElementSelectionServiceJob(this.getJobName(), this);
        job.setPriority(20);
        return job;
    }

    public Object resolve(IMatchingObject object) {
        return null;
    }

    public void run(IProgressMonitor monitor) {
    }

    protected String getJobName() {
        String providerName = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        String filter = this.getElementSelectionInput().getInput();
        return NLS.bind((String)CommonUIServicesMessages.ElementSelectionService_JobName, (Object[])new String[]{providerName, filter});
    }

    protected void fireEndOfMatchesEvent() {
        AbstractMatchingObject matchingObject = new AbstractMatchingObject(null, null, null, this);
        MatchingObjectEvent matchingObjectEvent = new MatchingObjectEvent(MatchingObjectEventType.END_OF_MATCHES, matchingObject);
        this.fireMatchingObjectEvent(matchingObjectEvent);
    }

    protected void fireMatchingObjectEvent(IMatchingObject matchingObject) {
        MatchingObjectEvent matchingObjectEvent = new MatchingObjectEvent(MatchingObjectEventType.MATCH, matchingObject);
        this.fireMatchingObjectEvent(matchingObjectEvent);
    }

    protected void fireMatchingObjectEvent(IMatchingObjectEvent matchingObjectEvent) {
        this.getElementSelectionListener().matchingObjectEvent(matchingObjectEvent);
    }

    protected IElementSelectionInput getElementSelectionInput() {
        return this.elementSelectionInput;
    }

    protected IElementSelectionListener getElementSelectionListener() {
        return this.elementSelectionListener;
    }
}

