/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.elementselection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.AbstractElementSelectionInput;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.AbstractMatchingObject;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.ElementSelectionService;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IElementSelectionListener;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IElementSelectionProvider;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IMatchingObject;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IMatchingObjectEvent;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.MatchingObjectEventType;
import org.eclipse.gmf.runtime.common.ui.services.internal.l10n.CommonUIServicesMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public abstract class ElementSelectionComposite
implements IElementSelectionListener {
    private final String title;
    private final List selectedElements = new ArrayList();
    private Text filterText = null;
    private TableViewer tableViewer = null;
    private ProgressMonitorPart progressBar;
    private AbstractElementSelectionInput input;
    private Job job;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.ui.services.elementselection.ElementSelectionComposite");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ElementSelectionComposite(String title, AbstractElementSelectionInput input) {
        this.title = title;
        this.input = input;
    }

    protected abstract boolean isValidSelection(List var1);

    protected abstract void handleSelection(boolean var1);

    public Composite createComposite(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new GridLayout());
        result.setLayoutData((Object)new GridData(1808));
        Label label = new Label(result, 0);
        label.setText(this.title);
        this.filterText = new Text(result, 2052);
        this.filterText.setLayoutData((Object)new GridData(768));
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ElementSelectionComposite.this.handleFilterChange();
            }
        });
        int selectStyle = 4;
        this.tableViewer = new TableViewer(result, selectStyle | 0x100 | 0x200 | 0x800);
        this.tableViewer.setUseHashlookup(true);
        Table table = this.tableViewer.getTable();
        GridData gridData = new GridData(1808);
        GC gc = new GC((Drawable)result);
        gc.setFont(JFaceResources.getDefaultFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        gridData.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)80);
        gridData.heightHint = table.getItemHeight() * 15;
        table.setLayoutData((Object)gridData);
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ElementSelectionComposite.this.handleSelectionChange();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.progressBar = new ProgressMonitorPart(result, (Layout)new GridLayout());
        this.progressBar.setLayoutData((Object)new GridData(768));
        this.progressBar.setVisible(false);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (!$assertionsDisabled && !(element instanceof AbstractMatchingObject)) {
                    throw new AssertionError();
                }
                return ((AbstractMatchingObject)element).getImage();
            }

            public String getText(Object element) {
                if (!$assertionsDisabled && !(element instanceof AbstractMatchingObject)) {
                    throw new AssertionError();
                }
                return ((AbstractMatchingObject)element).getDisplayName();
            }
        });
        this.tableViewer.setSorter(new ViewerSorter());
        this.createCompositeAdditions(result);
        return result;
    }

    protected void createCompositeAdditions(Composite parent) {
    }

    private void handleFilterChange() {
        this.input.setInput(this.filterText.getText());
        this.fillTableViewer();
        Object element = this.tableViewer.getElementAt(0);
        if (element != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection(element), true);
        }
        this.handleSelectionChange();
    }

    private void fillTableViewer() {
        this.tableViewer.getTable().removeAll();
        if (!this.input.getInput().equals("")) {
            this.filterText.setEnabled(false);
            this.progressBar.setVisible(true);
            this.progressBar.beginTask(CommonUIServicesMessages.ElementSelectionService_ProgressName, -1);
            this.job = ElementSelectionService.getInstance().getMatchingObjects(this.input, this);
        }
    }

    private void handleSelectionChange() {
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        if (selection.size() == 0) {
            this.selectedElements.clear();
            this.handleSelection(false);
            return;
        }
        List selectionList = selection.toList();
        ArrayList<AbstractMatchingObject> currentSelectedElements = new ArrayList<AbstractMatchingObject>();
        Iterator iter = selectionList.iterator();
        while (iter.hasNext()) {
            AbstractMatchingObject matchingObject = (AbstractMatchingObject)iter.next();
            currentSelectedElements.add(matchingObject);
        }
        boolean isValidSelection = this.isValidSelection(currentSelectedElements);
        this.selectedElements.clear();
        if (isValidSelection) {
            this.selectedElements.addAll(currentSelectedElements);
        }
        this.handleSelection(isValidSelection);
    }

    public List getSelectedElements() {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator iter = this.selectedElements.iterator();
        while (iter.hasNext()) {
            IMatchingObject matchingObject = (IMatchingObject)iter.next();
            IElementSelectionProvider provider = matchingObject.getProvider();
            Object object = provider.resolve(matchingObject);
            result.add(object);
        }
        return result;
    }

    public void matchingObjectEvent(IMatchingObjectEvent matchingObjectEvent) {
        if (!this.progressBar.isDisposed()) {
            if (matchingObjectEvent.getEventType() == MatchingObjectEventType.END_OF_MATCHES) {
                this.progressBar.done();
                this.progressBar.setVisible(false);
                this.filterText.setEnabled(true);
                this.filterText.setFocus();
            } else {
                this.progressBar.worked(1);
                this.progressBar.subTask(matchingObjectEvent.getMatchingObject().getName());
                this.tableViewer.add((Object)matchingObjectEvent.getMatchingObject());
            }
        }
    }

    public void cancel() {
        if (this.job != null) {
            this.job.cancel();
        }
    }
}

