/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.elementselection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.AbstractMatchingObject;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.ElementSelectionServiceJob;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IElementSelectionInput;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IElementSelectionListener;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IElementSelectionProvider;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IMatchingObject;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IMatchingObjectEvent;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.MatchingObjectEvent;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.MatchingObjectEventType;
import org.eclipse.gmf.runtime.common.ui.services.internal.CommonUIServicesPlugin;
import org.eclipse.gmf.runtime.common.ui.services.internal.elementselection.ElementSelectionList;
import org.eclipse.gmf.runtime.common.ui.services.internal.elementselection.MatchingObjectsOperation;
import org.eclipse.gmf.runtime.common.ui.services.internal.l10n.CommonUIServicesMessages;
import org.eclipse.gmf.runtime.common.ui.services.util.ActivityFilterProviderDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class ElementSelectionService
extends Service
implements IElementSelectionProvider,
IElementSelectionListener {
    private IElementSelectionInput elementSelectionInput;
    private IElementSelectionListener elementSelectionListener;
    private HashMap jobs = new HashMap();
    private static final ElementSelectionService instance = new ElementSelectionService();

    static {
        instance.configureProviders(CommonUIServicesPlugin.getPluginId(), "elementSelectionProviders");
    }

    protected ElementSelectionService() {
        super(true);
    }

    public static ElementSelectionService getInstance() {
        return instance;
    }

    public List getMatchingObjects(IElementSelectionInput input) {
        return new ElementSelectionList().getMatchingObjects(input);
    }

    public ElementSelectionServiceJob getMatchingObjects(IElementSelectionInput input, IElementSelectionListener listener) {
        this.elementSelectionInput = input;
        this.elementSelectionListener = listener;
        ElementSelectionServiceJob job = new ElementSelectionServiceJob(this.getJobName(), this);
        job.setPriority(20);
        job.schedule();
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor monitor) {
        block11: {
            HashMap jobsClone;
            Object provider;
            ArrayList results = new ArrayList();
            MatchingObjectsOperation operation = new MatchingObjectsOperation(this.elementSelectionInput);
            int i = 0;
            while (i < ExecutionStrategy.PRIORITIES.length) {
                List providers = ExecutionStrategy.FORWARD.getUncachedProviders((Service)this, ExecutionStrategy.PRIORITIES[i], (IOperation)operation);
                results.addAll(providers);
                ++i;
            }
            Iterator i2 = results.iterator();
            while (i2.hasNext()) {
                provider = (IElementSelectionProvider)i2.next();
                this.addJob((IElementSelectionProvider)provider);
            }
            provider = this.jobs;
            synchronized (provider) {
                jobsClone = (HashMap)this.jobs.clone();
            }
            Iterator i3 = jobsClone.entrySet().iterator();
            while (i3.hasNext()) {
                Map.Entry entry = i3.next();
                ElementSelectionServiceJob job = (ElementSelectionServiceJob)((Object)entry.getValue());
                job.schedule();
            }
            monitor.beginTask(this.getJobName(), 1000);
            do {
                HashMap hashMap = this.jobs;
                synchronized (hashMap) {
                    if (this.jobs.size() == 0) {
                        break block11;
                    }
                }
                monitor.worked(1);
            } while (!monitor.isCanceled());
            this.cancelAllJobs();
        }
        monitor.done();
    }

    public Object resolve(IMatchingObject object) {
        return null;
    }

    protected String getJobName() {
        String providerName = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        String filter = this.elementSelectionInput.getInput();
        return NLS.bind((String)CommonUIServicesMessages.ElementSelectionService_JobName, (Object[])new String[]{providerName, filter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJob(IElementSelectionProvider provider) {
        ElementSelectionServiceJob job = provider.getMatchingObjects(this.elementSelectionInput, this);
        HashMap hashMap = this.jobs;
        synchronized (hashMap) {
            this.jobs.put(provider, job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeJob(IElementSelectionProvider provider) {
        boolean end_of_matches = false;
        HashMap hashMap = this.jobs;
        synchronized (hashMap) {
            this.jobs.remove(provider);
            if (this.jobs.size() == 0) {
                end_of_matches = true;
            }
        }
        if (end_of_matches) {
            this.fireEndOfMatchesEvent();
        }
    }

    protected void fireMatchingObjectEvent(final IMatchingObjectEvent matchingObjectEvent) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ElementSelectionService.this.elementSelectionListener.matchingObjectEvent(matchingObjectEvent);
            }
        });
    }

    protected void fireEndOfMatchesEvent() {
        AbstractMatchingObject matchingObject = new AbstractMatchingObject(null, null, null, this);
        MatchingObjectEvent matchingObjectEvent = new MatchingObjectEvent(MatchingObjectEventType.END_OF_MATCHES, matchingObject);
        this.fireMatchingObjectEvent(matchingObjectEvent);
    }

    public void matchingObjectEvent(IMatchingObjectEvent matchingObjectEvent) {
        if (matchingObjectEvent.getEventType() == MatchingObjectEventType.END_OF_MATCHES) {
            this.removeJob(matchingObjectEvent.getMatchingObject().getProvider());
        } else {
            this.fireMatchingObjectEvent(matchingObjectEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelAllJobs() {
        HashMap jobsClone;
        HashMap hashMap = this.jobs;
        synchronized (hashMap) {
            jobsClone = (HashMap)this.jobs.clone();
        }
        Iterator i = jobsClone.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            IElementSelectionProvider provider = (IElementSelectionProvider)entry.getKey();
            ElementSelectionServiceJob job = (ElementSelectionServiceJob)((Object)entry.getValue());
            job.cancel();
            this.removeJob(provider);
        }
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    private static class ProviderDescriptor
    extends Service.ProviderDescriptor {
        private ActivityFilterProviderDescriptor activityFilter;

        public ProviderDescriptor(IConfigurationElement element) {
            super(element);
            this.activityFilter = new ActivityFilterProviderDescriptor(element);
        }

        public boolean provides(IOperation operation) {
            return this.activityFilter.provides(operation) && super.provides(operation);
        }
    }
}

