/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.clipboard.core;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardSupportUtil;
import org.eclipse.gmf.runtime.emf.clipboard.core.IClipboardSupport;
import org.eclipse.gmf.runtime.emf.clipboard.core.OverrideCopyOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.PasteOption;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.CopyObjects;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.ResourceInfoProcessor;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.SavingEMFResource;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.SerializationEMFResource;

public class CopyOperation
extends ClipboardOperation {
    private static final int KILOBYTE = 1024;
    private static final int BUFFER_SIZE = 131072;
    public static final String COPY = "copy";
    private static final URI COPY_URI = URI.createFileURI((String)"");
    private Map hintMap;
    private Collection eObjects;
    private CopyParentsCopier copyParentsCopierCopier;
    private OverrideCopyOperation overrideCopyOperation;

    public CopyOperation(IProgressMonitor monitor, IClipboardSupport clipboardSupport, Collection eObjects, Map hintMap) {
        super(monitor, clipboardSupport);
        this.eObjects = eObjects;
        this.hintMap = hintMap;
    }

    protected Map getEObjectsHintMap() {
        return this.hintMap;
    }

    public String copy() throws Exception {
        if (this.getClipboardOperationHelper().shouldOverrideCopyOperation(this.getEObjects(), this.getEObjectsHintMap())) {
            this.overrideCopyOperation = this.getClipboardOperationHelper().getOverrideCopyOperation(this);
            return this.overrideCopyOperation != null ? this.overrideCopyOperation.copy() : "";
        }
        CopyObjects copyObjects = this.getAuxiliaryObjects();
        if (this.isCancelled()) {
            this.throwCancelException();
        }
        return this.saveEObjects(copyObjects, COPY_URI, "UTF-8", SerializationEMFResource.SAVE_OPTIONS, this.getEObjectsHintMap());
    }

    private String saveEObjects(CopyObjects copyObjects, URI uri, String encoding, Map saveOptions, Map hints) throws Exception {
        String string;
        block4: {
            SavingEMFResource res = null;
            try {
                try {
                    res = new SavingEMFResource(uri, encoding, saveOptions, this.getCopyParentsCopier().getCopy2ObjectMap(), copyObjects, this.getClipboardOperationHelper());
                }
                catch (Exception exception) {
                    this.throwUncopyableException();
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream(131072);
                res.save(out, null);
                String dataStr = out.toString(encoding);
                String infoStr = ResourceInfoProcessor.getResourceInfo(dataStr.length(), encoding, res, hints, copyObjects);
                string = String.valueOf(dataStr) + infoStr;
                Object var10_11 = null;
                if (res == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var10_12 = null;
                    if (res == null) break block5;
                    res.unload();
                }
                throw throwable;
            }
            res.unload();
        }
        return string;
    }

    private void extractCopyAlwaysObjects(Collection mainObjects, Set combinedCopyAlwaysSet, Map copyAlwaysMap) {
        Iterator mainEObjectIt = mainObjects.iterator();
        EObject originalEObject = null;
        HashSet copyAlwaysSet = new HashSet();
        while (mainEObjectIt.hasNext()) {
            originalEObject = (EObject)mainEObjectIt.next();
            this.getCopyAlwaysObjects(originalEObject, copyAlwaysSet, combinedCopyAlwaysSet);
            TreeIterator childrenIt = originalEObject.eAllContents();
            EObject directChild = null;
            while (childrenIt.hasNext()) {
                directChild = (EObject)childrenIt.next();
                this.getCopyAlwaysObjects(directChild, copyAlwaysSet, combinedCopyAlwaysSet);
            }
            if (copyAlwaysSet.isEmpty()) continue;
            copyAlwaysMap.put(originalEObject, copyAlwaysSet);
            copyAlwaysSet = new HashSet();
        }
        this.removeNonCopyableObject(combinedCopyAlwaysSet);
        this.removeEmbeddedChildren(new ArrayList(combinedCopyAlwaysSet), combinedCopyAlwaysSet);
    }

    private void extractCopyAlwaysObjects(CopyObjects copyObjects) {
        HashSet newCopyAlwaysSet;
        this.extractCopyAlwaysObjects(copyObjects.originalObjects, copyObjects.combinedCopyAlwaysSet, copyObjects.copyAlwaysMap);
        copyObjects.combinedCopyAlwaysSet.removeAll(copyObjects.originalObjects);
        this.removeEmbeddedChildren(copyObjects.originalObjects, copyObjects.combinedCopyAlwaysSet);
        if (copyObjects.combinedCopyAlwaysSet.isEmpty()) {
            return;
        }
        HashSet nonCheckedCopyAlwaysSet = new HashSet(copyObjects.combinedCopyAlwaysSet);
        do {
            HashSet startingCopyAlwaysSet = new HashSet(copyObjects.combinedCopyAlwaysSet);
            this.extractCopyAlwaysObjects(nonCheckedCopyAlwaysSet, copyObjects.combinedCopyAlwaysSet, copyObjects.copyAlwaysMap);
            newCopyAlwaysSet = new HashSet(copyObjects.combinedCopyAlwaysSet);
            newCopyAlwaysSet.removeAll(startingCopyAlwaysSet);
        } while (!(nonCheckedCopyAlwaysSet = newCopyAlwaysSet).isEmpty());
    }

    private Map removeEmbeddedChildren(Collection parents, Collection childs) {
        HashMap<EObject, EObject> removedEmbeddedChild2Parent = new HashMap<EObject, EObject>();
        Iterator parentsIt = parents.iterator();
        EObject parent = null;
        EObject child = null;
        while (parentsIt.hasNext()) {
            parent = (EObject)parentsIt.next();
            Iterator childIt = childs.iterator();
            while (childIt.hasNext()) {
                child = (EObject)childIt.next();
                if (!ClipboardSupportUtil.isChild(parent, child)) continue;
                childIt.remove();
                removedEmbeddedChild2Parent.put(child, parent);
            }
        }
        return removedEmbeddedChild2Parent;
    }

    private void extractCopyParentsObjects(CopyObjects copyObjects) {
        ArrayList list = new ArrayList();
        list.addAll(copyObjects.originalObjects);
        list.addAll(copyObjects.combinedCopyAlwaysSet);
        Iterator it = list.iterator();
        EObject eObject = null;
        EObject copyParent = null;
        while (it.hasNext()) {
            eObject = (EObject)it.next();
            copyParent = this.getTopMostCopyParentObject(eObject);
            if (copyParent == null) continue;
            HashSet<EObject> objectSet = (HashSet<EObject>)copyObjects.copyParent2ObjectsMap.get(copyParent);
            if (objectSet == null) {
                objectSet = new HashSet<EObject>();
                copyObjects.copyParent2ObjectsMap.put(copyParent, objectSet);
            }
            objectSet.add(eObject);
            copyObjects.objectsToCopyParentMap.put(eObject, copyParent);
        }
        if (copyObjects.copyParent2ObjectsMap.isEmpty()) {
            return;
        }
        Set copyParentSet = copyObjects.copyParent2ObjectsMap.keySet();
        this.removeEmbeddedChildren(copyObjects.originalObjects, copyParentSet);
        HashSet copyParentSetCopy = new HashSet(copyParentSet);
        Map removedEmbeddedChild2Parent = this.removeEmbeddedChildren(copyParentSetCopy, copyParentSet);
        HashSet embeddedCopyParents = new HashSet();
        this.buildEmbeddedCopyParentChain(copyObjects.objectsToCopyParentMap.keySet(), embeddedCopyParents, copyParentSet);
        list.addAll(copyParentSet);
        Iterator copyParentsIt = copyParentSet.iterator();
        copyParent = null;
        EObject parentCopy = null;
        while (copyParentsIt.hasNext()) {
            copyParent = (EObject)copyParentsIt.next();
            parentCopy = this.getCopyParentsCopier().copyParent(copyParent, embeddedCopyParents, list);
            copyObjects.copyParent2CopyMap.put(copyParent, parentCopy);
        }
        this.getCopyParentsCopier().copyReferences();
        list.removeAll(copyParentSet);
        it = list.iterator();
        while (it.hasNext()) {
            eObject = (EObject)it.next();
            copyParent = (EObject)copyObjects.objectsToCopyParentMap.get(eObject);
            EObject replacementCopyParent = (EObject)removedEmbeddedChild2Parent.get(copyParent);
            if (replacementCopyParent == null) continue;
            copyObjects.objectsToCopyParentMap.put(eObject, replacementCopyParent);
        }
    }

    private void buildEmbeddedCopyParentChain(Set objectsWithCopyParent, Set embeddedCopyParents, Set copyParentSet) {
        Iterator it = objectsWithCopyParent.iterator();
        EObject eObject = null;
        while (it.hasNext()) {
            eObject = (EObject)it.next();
            while (!copyParentSet.contains(eObject.eContainer())) {
                embeddedCopyParents.add(eObject.eContainer());
                eObject = eObject.eContainer();
            }
        }
    }

    public Set getCombinedCopyAlwaysSet() {
        return this.getAuxiliaryObjects().combinedCopyAlwaysSet;
    }

    private CopyObjects getAuxiliaryObjects() {
        CopyObjects copyObjects = new CopyObjects(this.getEObjects());
        this.extractCopyAlwaysObjects(copyObjects);
        this.extractCopyParentsObjects(copyObjects);
        if (this.isCancelled()) {
            this.throwCancelException();
        }
        ArrayList originalObjectsCopy = new ArrayList(copyObjects.originalObjects);
        this.removeEmbeddedChildren(copyObjects.combinedCopyAlwaysSet, originalObjectsCopy);
        copyObjects.totalCopyObjects.addAll(originalObjectsCopy);
        copyObjects.totalCopyObjects.addAll(copyObjects.copyParent2CopyMap.values());
        copyObjects.totalCopyObjects.addAll(copyObjects.combinedCopyAlwaysSet);
        return copyObjects;
    }

    private void removeNonCopyableObject(Collection collection) {
        Iterator it = collection.iterator();
        EObject eObject = null;
        while (it.hasNext()) {
            eObject = (EObject)it.next();
            if (eObject.eContainer() != null) continue;
            it.remove();
        }
    }

    private EObject getTopMostCopyParentObject(EObject eChild) {
        if (eChild == null || eChild.eContainmentFeature() == null || eChild.eContainer() == null) {
            return null;
        }
        EObject copyParent = null;
        if (this.getClipboardOperationHelper().hasPasteOption(eChild, (EStructuralFeature)eChild.eContainmentFeature(), PasteOption.PARENT) && (copyParent = this.getTopMostCopyParentObject(eChild.eContainer())) == null && eChild.eContainer() != null && eChild.eContainer().eContainer() != null) {
            copyParent = eChild.eContainer();
        }
        return copyParent;
    }

    private void getCopyAlwaysObjects(EObject eObject, Set copyAlwaysObjects, Set combinedCopyAlwaysSet) {
        Iterator refIt = eObject.eClass().getEAllReferences().iterator();
        EReference ref = null;
        while (refIt.hasNext()) {
            ref = (EReference)refIt.next();
            if (ref.isContainment() || !eObject.eIsSet((EStructuralFeature)ref)) continue;
            Object value = eObject.eGet((EStructuralFeature)ref, true);
            if (!this.getClipboardOperationHelper().isCopyAlways(eObject, ref, value)) continue;
            if (FeatureMapUtil.isMany((EObject)eObject, (EStructuralFeature)ref)) {
                List vals = (List)value;
                if (vals.isEmpty()) continue;
                Iterator valIt = vals.iterator();
                while (valIt.hasNext()) {
                    EObject val = (EObject)valIt.next();
                    if (combinedCopyAlwaysSet.contains(val)) continue;
                    copyAlwaysObjects.add(val);
                    combinedCopyAlwaysSet.add(val);
                }
                continue;
            }
            if (value == null || combinedCopyAlwaysSet.contains(value)) continue;
            copyAlwaysObjects.add(value);
            combinedCopyAlwaysSet.add(value);
        }
    }

    private void throwCancelException() {
        this.throwCancelException(COPY);
    }

    private void throwUncopyableException() {
        this.throwException(COPY, new IllegalArgumentException("Uncopyable Object"));
    }

    private CopyParentsCopier getCopyParentsCopier() {
        if (this.copyParentsCopierCopier == null) {
            this.copyParentsCopierCopier = new CopyParentsCopier();
        }
        return this.copyParentsCopierCopier;
    }

    protected Collection getEObjects() {
        return this.eObjects;
    }

    private class CopyParentsCopier
    extends EcoreUtil.Copier {
        private static final long serialVersionUID = 6178429496879264655L;
        private Map copyToObjectMap = new HashMap();
        private Collection doNotCopyEObjects;
        private Collection embeddedCopyParents;

        private CopyParentsCopier() {
        }

        EObject copyParent(EObject eParent, Collection embeddedCopyParentsCollection, Collection doNotCopyEObjectsCollection) {
            this.embeddedCopyParents = embeddedCopyParentsCollection;
            this.doNotCopyEObjects = doNotCopyEObjectsCollection;
            EObject copiedParent = this.copy(eParent);
            this.doNotCopyEObjects = null;
            this.embeddedCopyParents = null;
            return copiedParent;
        }

        public EObject copy(EObject eObject) {
            EObject copiedObject = (EObject)this.get(eObject);
            if (copiedObject != null) {
                return copiedObject;
            }
            copiedObject = super.copy(eObject);
            this.copyToObjectMap.put(copiedObject, eObject);
            return copiedObject;
        }

        Map getObject2CopyMap() {
            return this;
        }

        Map getCopy2ObjectMap() {
            return this.copyToObjectMap;
        }

        private Collection copyAll(EObject eOwnerObject, EReference eReference) {
            EObject eObject;
            if (!eOwnerObject.eIsSet((EStructuralFeature)eReference)) {
                return Collections.EMPTY_LIST;
            }
            List list = (List)eOwnerObject.eGet((EStructuralFeature)eReference);
            ArrayList<EObject> result = new ArrayList<EObject>(list.size());
            int lowerBound = eReference.getLowerBound();
            ArrayList<EObject> noneCopied = new ArrayList<EObject>(list.size());
            Iterator it = list.iterator();
            while (it.hasNext()) {
                eObject = (EObject)it.next();
                if (this.doNotCopyEObjects != null && this.doNotCopyEObjects.contains(eObject)) continue;
                if (this.embeddedCopyParents != null && this.embeddedCopyParents.contains(eObject)) {
                    result.add(this.copy(eObject));
                    if (lowerBound == 0 || result.size() != lowerBound) continue;
                    return result;
                }
                noneCopied.add(eObject);
            }
            it = noneCopied.iterator();
            while (it.hasNext()) {
                eObject = (EObject)it.next();
                result.add(this.copy(eObject));
                if (lowerBound == 0 || result.size() != lowerBound) continue;
                return result;
            }
            return result;
        }

        protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copiedEObject) {
            super.copyAttribute(eAttribute, eObject, copiedEObject);
        }

        protected void copyContainment(EReference eReference, EObject eObject, EObject copiedEObject) {
            if (eObject.eIsSet((EStructuralFeature)eReference)) {
                if (this.doNotCopyEObjects != null && !FeatureMapUtil.isMany((EObject)eObject, (EStructuralFeature)eReference) && this.doNotCopyEObjects.contains(eObject.eGet((EStructuralFeature)eReference))) {
                    return;
                }
                if (this.isCritical(eObject, eReference)) {
                    if (FeatureMapUtil.isMany((EObject)eObject, (EStructuralFeature)eReference)) {
                        ((Collection)copiedEObject.eGet((EStructuralFeature)eReference)).addAll(this.copyAll(eObject, eReference));
                    } else {
                        EObject childEObject = (EObject)eObject.eGet((EStructuralFeature)eReference);
                        copiedEObject.eSet((EStructuralFeature)eReference, childEObject == null ? null : this.copy(childEObject));
                    }
                }
            }
        }

        protected void copyReference(EReference eReference, EObject eObject, EObject copiedEObject) {
            if (this.isCritical(eObject, eReference)) {
                super.copyReference(eReference, eObject, copiedEObject);
            }
        }

        private boolean isCritical(EObject eObject, EReference eReference) {
            int lowerBound = eReference.getLowerBound();
            int upperBound = eReference.getUpperBound();
            if (upperBound == 0) {
                return false;
            }
            if (FeatureMapUtil.isMany((EObject)eObject, (EStructuralFeature)eReference) && !eObject.eIsSet((EStructuralFeature)eReference)) {
                return false;
            }
            Object value = eObject.eGet((EStructuralFeature)eReference);
            if (value == null) {
                return false;
            }
            if (eReference.isMany()) {
                List list = (List)value;
                if (list.isEmpty()) {
                    return false;
                }
                if (this.embeddedCopyParents != null && ClipboardSupportUtil.containsAny(list, this.embeddedCopyParents)) {
                    return true;
                }
                if (lowerBound == upperBound) {
                    return true;
                }
                if (lowerBound > 0) {
                    return true;
                }
                if (!eReference.isChangeable()) {
                    return true;
                }
            } else if (!eReference.isUnsettable() || this.embeddedCopyParents != null && this.embeddedCopyParents.contains(value)) {
                return true;
            }
            return CopyOperation.this.getClipboardOperationHelper().hasPasteOption(eObject, (EStructuralFeature)eReference, PasteOption.CRITICAL);
        }
    }
}

