/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.core.service;

import com.ibm.icu.util.StringTokenizer;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.common.core.internal.CommonCorePlugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.osgi.framework.Bundle;

public class AbstractProviderConfiguration {
    protected static final String OBJECT = "object";
    protected static final String ID = "id";
    protected static final String CLASS = "class";
    protected static final String METHOD = "method";
    protected static final String STATIC_METHOD = "staticMethod";
    protected static final String NAME = "name";
    protected static final String VALUE = "value";
    protected static final String NOT_VALUE = "notValue";
    protected static final String NULL = "null";
    protected static final String contextParam = "%Context";
    private static Map isAssignableTable = new HashMap();
    private static Map isNotAssignableTable = new HashMap();
    private static ClassToMethodSignaturesSetMap passiveClasses = new ClassToMethodSignaturesSetMap();
    private static ClassToMethodSignatureToMethodCach classToMethodSignatureToMethodCach = new ClassToMethodSignatureToMethodCach();
    private static Map successLookupTable = new HashMap();
    private static Set failureLookupTable = new HashSet();

    static String getClassName(Object object) {
        String cn = object.getClass().getName();
        return cn.substring(cn.lastIndexOf(46) + 1);
    }

    protected static List getObjectList(String objectsIds, Map objectMap, IConfigurationElement configElement) {
        if (objectsIds == null) {
            return null;
        }
        StringTokenizer ids = new StringTokenizer(objectsIds.trim(), ",");
        if (!ids.hasMoreTokens()) {
            return null;
        }
        ArrayList objectList = new ArrayList();
        while (ids.hasMoreTokens()) {
            String objectId = ids.nextToken().trim();
            Object objectVal = objectMap.get(objectId);
            if (objectVal != null) {
                objectList.add(objectVal);
                continue;
            }
            Log.error(CommonCorePlugin.getDefault(), 5, String.valueOf(configElement.getDeclaringExtension().getContributor().getName()) + ".plugin.xml extension [" + configElement.getDeclaringExtension().getExtensionPointUniqueIdentifier() + "]: object id (" + objectId + ") is not in the list " + objectMap.keySet());
        }
        return objectList;
    }

    protected static Set getStrings(String s) {
        if (s == null) {
            return null;
        }
        HashSet<String> stringList = new HashSet<String>();
        StringTokenizer ids = new StringTokenizer(s.trim(), ",");
        while (ids.hasMoreTokens()) {
            stringList.add(ids.nextToken().trim());
        }
        return stringList.isEmpty() ? null : stringList;
    }

    protected static boolean objectMatches(Object object, List objects) {
        if (object != null) {
            Iterator i = objects.iterator();
            while (i.hasNext()) {
                ObjectDescriptor desc = (ObjectDescriptor)i.next();
                if (!desc.sameAs(object)) continue;
                return true;
            }
        }
        return false;
    }

    protected static Class loadClass(String className, String pluginId) {
        Class found;
        StringBuffer keyStringBuf = new StringBuffer(className.length() + pluginId.length() + 2);
        keyStringBuf.append(pluginId);
        keyStringBuf.append('.');
        keyStringBuf.append(className);
        String keyString = keyStringBuf.toString();
        WeakReference ref = (WeakReference)successLookupTable.get(keyString);
        Class clazz = found = ref != null ? (Class)ref.get() : null;
        if (found == null) {
            if (ref != null) {
                successLookupTable.remove(keyString);
            }
            if (!failureLookupTable.contains(keyString)) {
                try {
                    Bundle bundle = AbstractProviderConfiguration.getPluginBundle(pluginId);
                    if (bundle != null) {
                        found = bundle.loadClass(className);
                        successLookupTable.put(keyString, new WeakReference<Class>(found));
                    } else {
                        failureLookupTable.add(keyString);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    failureLookupTable.add(keyString);
                }
            }
        }
        return found;
    }

    protected static Bundle getPluginBundle(String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null && bundle.getState() == 32) {
            return bundle;
        }
        return null;
    }

    protected static boolean isAssignableTo(Class clazz, String className) {
        if (clazz == null) {
            return false;
        }
        if (AbstractProviderConfiguration.contains(isNotAssignableTable, clazz, className)) {
            return false;
        }
        if (AbstractProviderConfiguration.contains(isAssignableTable, clazz, className)) {
            return true;
        }
        boolean result = AbstractProviderConfiguration.isAssignableToNoCache(clazz, className);
        if (result) {
            AbstractProviderConfiguration.add(isAssignableTable, clazz, className);
        } else {
            AbstractProviderConfiguration.add(isNotAssignableTable, clazz, className);
        }
        return result;
    }

    private static boolean isAssignableToNoCache(Class clazz, String className) {
        if (clazz.getName().equals(className)) {
            return true;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (AbstractProviderConfiguration.checkInterfaceHierarchy(interfaces[i], className)) {
                return true;
            }
            ++i;
        }
        return AbstractProviderConfiguration.isAssignableTo(clazz.getSuperclass(), className);
    }

    protected static Object getAdapter(Object object, String className, String pluginId) {
        if (!(object instanceof IAdaptable)) {
            return null;
        }
        if (pluginId != null) {
            Class theClass = AbstractProviderConfiguration.loadClass(className, pluginId);
            return theClass != null ? ((IAdaptable)object).getAdapter(theClass) : null;
        }
        return null;
    }

    protected static Object invokeMethod(MethodDescriptor methodDescriptor, Object object) {
        Class<?> clazz;
        String methodSignature;
        block7: {
            block6: {
                methodSignature = null;
                clazz = null;
                try {
                    if (methodDescriptor != null && object != null) break block6;
                    return null;
                }
                catch (Exception exception) {
                    passiveClasses.addMethod(clazz, methodSignature);
                    return null;
                }
            }
            methodSignature = methodDescriptor.getSignature();
            clazz = object.getClass();
            if (!passiveClasses.contains(clazz, methodSignature)) break block7;
            return null;
        }
        Method method = classToMethodSignatureToMethodCach.getMethod(clazz, methodSignature);
        if (method == null) {
            method = clazz.getMethod(methodDescriptor.getName(), methodDescriptor.getParameterTypes());
            classToMethodSignatureToMethodCach.addMethod(clazz, methodSignature, method);
        }
        Object valueObj = method.invoke(object, methodDescriptor.getParameters());
        if (methodDescriptor.getNext() == null) {
            return valueObj == null ? NULL : valueObj;
        }
        return AbstractProviderConfiguration.invokeMethod(methodDescriptor.getNext(), valueObj);
    }

    protected static Object invokeStaticMethod(StaticMethodDescriptor methodDescriptor, Object object) {
        block7: {
            if (methodDescriptor != null) break block7;
            return null;
        }
        try {
            Object[] valuesCopy = null;
            if (methodDescriptor.getParameters() != null) {
                valuesCopy = (Object[])methodDescriptor.getParameters().clone();
                int i = 0;
                while (i < valuesCopy.length) {
                    if (valuesCopy[i].equals(contextParam)) {
                        valuesCopy[i] = object;
                    }
                    ++i;
                }
            }
            Method method = AbstractProviderConfiguration.getStaticMethod(methodDescriptor);
            Object valueObj = method.invoke(object, valuesCopy);
            if (methodDescriptor.getNext() == null) {
                return valueObj == null ? NULL : valueObj;
            }
            return AbstractProviderConfiguration.invokeMethod(methodDescriptor.getNext(), valueObj);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Method getStaticMethod(StaticMethodDescriptor staticMethodDescriptor) {
        Class theClass = AbstractProviderConfiguration.loadClass(staticMethodDescriptor.getClassName(), staticMethodDescriptor.getPluginID());
        if (theClass == null) {
            return null;
        }
        Method theMethod = null;
        try {
            String methodSignature = staticMethodDescriptor.getSignature();
            theMethod = classToMethodSignatureToMethodCach.getMethod(theClass, methodSignature);
            if (theMethod == null) {
                theMethod = theClass.getMethod(staticMethodDescriptor.getName(), staticMethodDescriptor.getParameterTypes());
                classToMethodSignatureToMethodCach.addMethod(theClass, methodSignature, theMethod);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return theMethod;
    }

    private static boolean checkInterfaceHierarchy(Class interfaceToCheck, String className) {
        if (AbstractProviderConfiguration.contains(isNotAssignableTable, interfaceToCheck, className)) {
            return false;
        }
        if (AbstractProviderConfiguration.contains(isAssignableTable, interfaceToCheck, className)) {
            return true;
        }
        boolean result = AbstractProviderConfiguration.checkInterfaceHierarchyNoCache(interfaceToCheck, className);
        if (result) {
            AbstractProviderConfiguration.add(isAssignableTable, interfaceToCheck, className);
        } else {
            AbstractProviderConfiguration.add(isNotAssignableTable, interfaceToCheck, className);
        }
        return result;
    }

    private static boolean checkInterfaceHierarchyNoCache(Class interfaceToCheck, String className) {
        if (interfaceToCheck.getName().equals(className)) {
            return true;
        }
        Class<?>[] superInterfaces = interfaceToCheck.getInterfaces();
        int i = 0;
        while (i < superInterfaces.length) {
            if (AbstractProviderConfiguration.checkInterfaceHierarchy(superInterfaces[i], className)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean contains(Map map, Object key, String value) {
        boolean result = false;
        Object val = map.get(key);
        if (val != null) {
            Set values = (Set)val;
            result = values.contains(value);
        }
        return result;
    }

    private static void add(Map map, Object key, String value) {
        HashSet<String> values = (HashSet<String>)map.get(key);
        if (values == null) {
            values = new HashSet<String>();
            map.put(key, values);
        }
        values.add(value);
    }

    private static class ClassToMethodSignaturesSetMap {
        Map classToMethodSignaturesSetMap = new HashMap();

        private ClassToMethodSignaturesSetMap() {
        }

        public void addMethod(Class clazz, String signature) {
            HashSet<String> signatures = (HashSet<String>)this.classToMethodSignaturesSetMap.get(clazz);
            if (signatures == null) {
                signatures = new HashSet<String>();
                this.classToMethodSignaturesSetMap.put(clazz, signatures);
            }
            signatures.add(signature);
        }

        public boolean contains(Class clazz, String signature) {
            Set signatures = (Set)this.classToMethodSignaturesSetMap.get(clazz);
            if (signatures == null) {
                return false;
            }
            return signatures.contains(signature);
        }
    }

    private static class ClassToMethodSignatureToMethodCach {
        Map classToMethodSignatureToMethod = new HashMap();

        private ClassToMethodSignatureToMethodCach() {
        }

        public void addMethod(Class clazz, String methodSignature, Method method) {
            HashMap<String, Method> signatureToMethodMap = (HashMap<String, Method>)this.classToMethodSignatureToMethod.get(clazz);
            if (signatureToMethodMap == null) {
                signatureToMethodMap = new HashMap<String, Method>();
                this.classToMethodSignatureToMethod.put(clazz, signatureToMethodMap);
            }
            signatureToMethodMap.put(methodSignature, method);
        }

        public Method getMethod(Class clazz, String methodSignature) {
            Map signatureToMethodMap = (Map)this.classToMethodSignatureToMethod.get(clazz);
            if (signatureToMethodMap != null) {
                return (Method)signatureToMethodMap.get(methodSignature);
            }
            return null;
        }
    }

    public static class ObjectDescriptor {
        private String contextClassName;
        private String contextClassPlugin;
        private boolean syntaxError;
        private final List methods;
        private final List staticMethods;

        public ObjectDescriptor(IConfigurationElement configElement) {
            this(configElement, AbstractProviderConfiguration.CLASS);
        }

        public ObjectDescriptor(IConfigurationElement configElement, String classNameTag) {
            ValueDescriptor value;
            MethodDescriptor methodDescriptor;
            String name;
            int i;
            String s = configElement.getAttribute(classNameTag);
            if (s != null) {
                int start = s.indexOf("(");
                if (start != -1) {
                    this.contextClassName = s.substring(0, start).trim();
                    int end = s.indexOf(")");
                    if (end != -1 && end > start + 1) {
                        this.contextClassPlugin = s.substring(start + 1, end);
                    }
                } else {
                    this.contextClassName = s.trim();
                }
            }
            IConfigurationElement[] methodConfigs = configElement.getChildren(AbstractProviderConfiguration.METHOD);
            IConfigurationElement[] staticMethodConfigs = configElement.getChildren(AbstractProviderConfiguration.STATIC_METHOD);
            if (methodConfigs.length != 0) {
                this.methods = new ArrayList(methodConfigs.length);
                i = 0;
                while (i < methodConfigs.length) {
                    name = methodConfigs[i].getAttribute(AbstractProviderConfiguration.NAME);
                    if (name != null) {
                        try {
                            methodDescriptor = new MethodDescriptor(name);
                            methodDescriptor.setCall(name.intern());
                            value = new ValueDescriptor(methodConfigs[i]);
                            if (value != null) {
                                this.methods.add(new MethodValueEntry(methodDescriptor, value));
                            }
                        }
                        catch (Exception exception) {
                            this.syntaxError = true;
                            Log.error(CommonCorePlugin.getDefault(), 5, String.valueOf(configElement.getDeclaringExtension().getContributor().getName()) + ".plugin.xml extension [" + configElement.getDeclaringExtension().getExtensionPointUniqueIdentifier() + "]: invalid syntax for method [" + name + "]");
                        }
                    } else {
                        this.syntaxError = true;
                        Log.error(CommonCorePlugin.getDefault(), 5, String.valueOf(configElement.getDeclaringExtension().getContributor().getName()) + ".plugin.xml extension [" + configElement.getDeclaringExtension().getExtensionPointUniqueIdentifier() + "] : missing method name");
                    }
                    ++i;
                }
            } else {
                this.methods = Collections.EMPTY_LIST;
            }
            if (staticMethodConfigs.length != 0) {
                this.staticMethods = new ArrayList(staticMethodConfigs.length);
                i = 0;
                while (i < staticMethodConfigs.length) {
                    name = staticMethodConfigs[i].getAttribute(AbstractProviderConfiguration.NAME);
                    if (name != null) {
                        try {
                            methodDescriptor = new StaticMethodDescriptor(name);
                            methodDescriptor.setCall(name.intern());
                            value = new ValueDescriptor(staticMethodConfigs[i]);
                            if (value != null) {
                                this.staticMethods.add(new MethodValueEntry(methodDescriptor, value));
                            }
                        }
                        catch (Exception exception) {
                            this.syntaxError = true;
                            Log.error(CommonCorePlugin.getDefault(), 5, String.valueOf(configElement.getDeclaringExtension().getContributor().getName()) + ".plugin.xml extension [" + configElement.getDeclaringExtension().getExtensionPointUniqueIdentifier() + "]: invalid syntax for method [" + name + "]");
                        }
                    } else {
                        this.syntaxError = true;
                        Log.error(CommonCorePlugin.getDefault(), 5, String.valueOf(configElement.getDeclaringExtension().getContributor().getName()) + ".plugin.xml extension [" + configElement.getDeclaringExtension().getExtensionPointUniqueIdentifier() + "] : missing method name");
                    }
                    ++i;
                }
            } else {
                this.staticMethods = Collections.EMPTY_LIST;
            }
            if (this.contextClassName != null) {
                this.contextClassName = this.contextClassName.intern();
            }
            if (this.contextClassPlugin != null) {
                this.contextClassPlugin = this.contextClassPlugin.intern();
            }
        }

        public boolean sameAs(Object object) {
            Object methodValue;
            MethodValueEntry entry;
            if (this.syntaxError) {
                return false;
            }
            Object targetObject = object;
            if (this.contextClassName != null && !AbstractProviderConfiguration.isAssignableTo(object.getClass(), this.contextClassName) && (targetObject = AbstractProviderConfiguration.getAdapter(object, this.contextClassName, this.contextClassPlugin)) == null) {
                return false;
            }
            Iterator iter = this.methods.iterator();
            while (iter.hasNext()) {
                entry = (MethodValueEntry)iter.next();
                methodValue = AbstractProviderConfiguration.invokeMethod(entry.method, targetObject);
                if (methodValue != null && entry.value.sameAs(methodValue)) continue;
                return false;
            }
            iter = this.staticMethods.iterator();
            while (iter.hasNext()) {
                entry = (MethodValueEntry)iter.next();
                methodValue = AbstractProviderConfiguration.invokeStaticMethod((StaticMethodDescriptor)entry.method, targetObject);
                if (methodValue != null && entry.value.sameAs(methodValue)) continue;
                return false;
            }
            return true;
        }
    }

    private static class MethodDescriptor {
        private String call;
        private String name;
        private Object[] parameterObjects;
        private Class[] parameterTypes;
        private MethodDescriptor next;
        private List parameters;
        private String signature = null;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;
        static /* synthetic */ Class class$3;
        static /* synthetic */ Class class$4;
        static /* synthetic */ Class class$5;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.core.service.AbstractProviderConfiguration$MethodDescriptor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        protected MethodDescriptor() {
        }

        public MethodDescriptor(String string) {
            string = this.parseName(string.trim());
            string = this.parseParameterList(string.trim());
            if (this.parameters != null && !this.parameters.isEmpty()) {
                Collections.reverse(this.parameters);
                this.parameterObjects = this.parameters.toArray();
                this.parameterTypes = new Class[this.parameterObjects.length];
                int i = 0;
                while (i < this.parameterObjects.length) {
                    block36: {
                        String value;
                        String p = (String)this.parameterObjects[i];
                        int objIndex = p.indexOf("[object]");
                        boolean isObject = objIndex >= 0;
                        int parseAsIndex = p.indexOf(":::");
                        try {
                            if (isObject && parseAsIndex >= 0 && !$assertionsDisabled && objIndex >= parseAsIndex) {
                                throw new AssertionError();
                            }
                            if (parseAsIndex >= 0) {
                                String parseAs = p.substring(isObject ? 8 : 0, parseAsIndex);
                                String value2 = p.substring(parseAsIndex + 3, p.length());
                                if (parseAs.equalsIgnoreCase("int")) {
                                    Class<?> clazz = class$1;
                                    if (clazz == null) {
                                        try {
                                            clazz = Class.forName("java.lang.Integer");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    this.parameterTypes[i] = clazz;
                                    this.parameterObjects[i] = Integer.decode(value2);
                                } else if (parseAs.equalsIgnoreCase("bool")) {
                                    Class<?> clazz = class$2;
                                    if (clazz == null) {
                                        try {
                                            clazz = Class.forName("java.lang.Boolean");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    this.parameterTypes[i] = clazz;
                                    this.parameterObjects[i] = Boolean.valueOf(value2);
                                } else if (parseAs.equalsIgnoreCase("double")) {
                                    Class<?> clazz = class$3;
                                    if (clazz == null) {
                                        try {
                                            clazz = Class.forName("java.lang.Double");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    this.parameterTypes[i] = clazz;
                                    this.parameterObjects[i] = Double.valueOf(value2);
                                }
                                if (!isObject) break block36;
                                Class<?> clazz = class$4;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("java.lang.Object");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                this.parameterTypes[i] = clazz;
                                break block36;
                            }
                            if (isObject) {
                                value = p.substring(8, p.length());
                                Class<?> clazz = class$4;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("java.lang.Object");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                this.parameterTypes[i] = clazz;
                                this.parameterObjects[i] = value;
                                break block36;
                            }
                            Class<?> clazz = class$5;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("java.lang.String");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            this.parameterTypes[i] = clazz;
                        }
                        catch (Exception exception) {
                            value = p.substring(parseAsIndex >= 0 ? parseAsIndex + 3 : 0, p.length());
                            this.parameterObjects[i] = value;
                            Class<?> clazz = class$5;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("java.lang.String");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            this.parameterTypes[i] = clazz;
                        }
                    }
                    ++i;
                }
            }
            this.parameters = null;
            if (string.length() != 0) {
                if (string.charAt(0) != '.') {
                    throw new IllegalArgumentException();
                }
                this.next = new MethodDescriptor(string.substring(1).trim());
            }
            if (this.name != null) {
                this.name = this.name.intern();
            }
        }

        protected String parseName(String string) {
            int index = string.indexOf(40);
            if (index == -1) {
                throw new IllegalArgumentException();
            }
            this.name = string.substring(0, index).trim();
            return string.substring(index + 1);
        }

        protected String parseParameterList(String string) {
            int index = -1;
            String paramStr = null;
            while (paramStr == null) {
                if ((index = string.indexOf(41, index + 1)) == -1) {
                    throw new IllegalArgumentException();
                }
                if (index != 0 && string.charAt(index - 1) == '\\') continue;
                paramStr = string.substring(0, index);
            }
            if (paramStr.length() != 0) {
                this.parameters = new ArrayList();
                this.parseParameters(paramStr.trim());
            }
            return string.substring(index + 1);
        }

        private void parseParameters(String string) {
            int index = string.indexOf(44);
            if (index != -1 && string.charAt(index - 1) != '\\') {
                this.parseParameters(string.substring(index + 1).trim());
                this.parameters.add(string.substring(0, index));
            } else {
                this.parameters.add(string);
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Object[] getParameters() {
            return this.parameterObjects;
        }

        public Class[] getParameterTypes() {
            return this.parameterTypes;
        }

        protected void setParameters(Object[] paramters) {
            this.parameterObjects = paramters;
        }

        public void setParameterTypes(Class[] paramterTypes) {
            this.parameterTypes = paramterTypes;
        }

        public MethodDescriptor getNext() {
            return this.next;
        }

        protected void setNext(MethodDescriptor next) {
            this.next = next;
        }

        public String getCall() {
            return this.call;
        }

        public void setCall(String call) {
            this.call = call;
        }

        protected List getParamtersList() {
            return this.parameters;
        }

        protected void setParamtersList(List parameters1) {
            this.parameters = parameters1;
        }

        public String getSignature() {
            if (this.signature == null) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.name);
                sb.append('(');
                if (this.parameterTypes != null) {
                    int index = 0;
                    while (index < this.parameterTypes.length) {
                        Class clazz = this.parameterTypes[index];
                        sb.append(clazz.getName());
                        if (index < this.parameterTypes.length - 1) {
                            sb.append(',');
                        }
                        ++index;
                    }
                }
                sb.append(')');
                this.signature = sb.toString();
            }
            return this.signature;
        }
    }

    private static class StaticMethodDescriptor
    extends MethodDescriptor {
        private String pluginID;
        private String className;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;
        static /* synthetic */ Class class$3;
        static /* synthetic */ Class class$4;
        static /* synthetic */ Class class$5;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.core.service.AbstractProviderConfiguration$StaticMethodDescriptor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public StaticMethodDescriptor(String string) {
            string = this.parsePluginID(string.trim());
            string = this.parseClassName(string.trim());
            string = this.parseName(string.trim());
            string = this.parseParameterList(string.trim());
            List parameters = this.getParamtersList();
            if (parameters != null && !parameters.isEmpty()) {
                Collections.reverse(parameters);
                Object[] parameterObjects = parameters.toArray();
                Class[] parameterTypes = new Class[parameterObjects.length];
                int i = 0;
                while (i < parameterObjects.length) {
                    block37: {
                        String value;
                        String p = (String)parameterObjects[i];
                        int objIndex = p.indexOf("[object]");
                        boolean isObject = objIndex >= 0;
                        int parseAsIndex = p.indexOf(":::");
                        try {
                            if (isObject && parseAsIndex >= 0 && !$assertionsDisabled && objIndex >= parseAsIndex) {
                                throw new AssertionError();
                            }
                            if (parseAsIndex >= 0) {
                                String parseAs = p.substring(isObject ? 8 : 0, parseAsIndex);
                                String value2 = p.substring(parseAsIndex + 3, p.length());
                                if (parseAs.equalsIgnoreCase("int")) {
                                    Class<?> clazz = class$1;
                                    if (clazz == null) {
                                        try {
                                            clazz = Class.forName("java.lang.Integer");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    parameterTypes[i] = clazz;
                                    parameterObjects[i] = Integer.decode(value2);
                                } else if (parseAs.equalsIgnoreCase("bool")) {
                                    Class<?> clazz = class$2;
                                    if (clazz == null) {
                                        try {
                                            clazz = Class.forName("java.lang.Boolean");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    parameterTypes[i] = clazz;
                                    parameterObjects[i] = Boolean.valueOf(value2);
                                } else if (parseAs.equalsIgnoreCase("double")) {
                                    Class<?> clazz = class$3;
                                    if (clazz == null) {
                                        try {
                                            clazz = Class.forName("java.lang.Double");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    parameterTypes[i] = clazz;
                                    parameterObjects[i] = Double.valueOf(value2);
                                }
                                if (!isObject) break block37;
                                Class<?> clazz = class$4;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("java.lang.Object");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                parameterTypes[i] = clazz;
                                break block37;
                            }
                            if (isObject) {
                                value = p.substring(8, p.length());
                                Class<?> clazz = class$4;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("java.lang.Object");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                parameterTypes[i] = clazz;
                                parameterObjects[i] = value;
                                break block37;
                            }
                            if (p.startsWith(AbstractProviderConfiguration.contextParam)) {
                                parameterTypes[i] = this.getParameterType(p);
                                parameterObjects[i] = AbstractProviderConfiguration.contextParam;
                                break block37;
                            }
                            Class<?> clazz = class$5;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("java.lang.String");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            parameterTypes[i] = clazz;
                        }
                        catch (Exception exception) {
                            value = p.substring(parseAsIndex >= 0 ? parseAsIndex + 3 : 0, p.length());
                            parameterObjects[i] = value;
                            Class<?> clazz = class$5;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("java.lang.String");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            parameterTypes[i] = clazz;
                        }
                    }
                    ++i;
                }
                this.setParameters(parameterObjects);
                this.setParameterTypes(parameterTypes);
            }
            parameters = null;
            if (string.length() != 0) {
                if (string.charAt(0) != '.') {
                    throw new IllegalArgumentException();
                }
                this.setNext(new MethodDescriptor(string.substring(1).trim()));
            }
            if (this.getName() != null) {
                this.setName(this.getName().intern());
            }
        }

        private Class getParameterType(String parameter) {
            int startIndex = parameter.indexOf("[");
            int endIndex = parameter.indexOf("]");
            if (startIndex == -1 || endIndex == -1) {
                throw new IllegalArgumentException();
            }
            String parameterTypeString = parameter.substring(startIndex + 1, endIndex).trim();
            if ((endIndex = parameterTypeString.indexOf(47)) == -1 || endIndex == parameterTypeString.length() - 1) {
                throw new IllegalArgumentException();
            }
            String parameterPluginID = parameterTypeString.substring(0, endIndex).trim();
            String parameterClassName = parameterTypeString.substring(endIndex + 1);
            Class clazz = AbstractProviderConfiguration.loadClass(parameterClassName, parameterPluginID);
            if (clazz == null) {
                Class<?> clazz2 = class$4;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$4 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                clazz = clazz2;
            }
            return clazz;
        }

        private String parsePluginID(String string) {
            int index = string.indexOf(47);
            if (index == -1) {
                throw new IllegalArgumentException();
            }
            this.pluginID = string.substring(0, index).trim();
            return string.substring(index + 1);
        }

        private String parseClassName(String string) {
            int index = string.indexOf(40);
            if (index == -1) {
                throw new IllegalArgumentException();
            }
            if ((index = string.lastIndexOf(46, index)) == -1) {
                throw new IllegalArgumentException();
            }
            this.className = string.substring(0, index).trim();
            return string.substring(index + 1);
        }

        public String getPluginID() {
            return this.pluginID;
        }

        public String getClassName() {
            return this.className;
        }
    }

    private static class ValueDescriptor {
        private Set valueLiterals = new HashSet();
        private Set notValueLiterals;
        private List valueObjects;
        private List notValueObjects;

        public ValueDescriptor(IConfigurationElement configElement) {
            String s = configElement.getAttribute(AbstractProviderConfiguration.VALUE);
            if (s != null) {
                this.parseValueLiteralString(s, this.valueLiterals);
            }
            this.notValueLiterals = new HashSet();
            s = configElement.getAttribute(AbstractProviderConfiguration.NOT_VALUE);
            if (s != null) {
                this.parseValueLiteralString(s, this.notValueLiterals);
            }
            IConfigurationElement[] valueConfigs = configElement.getChildren(AbstractProviderConfiguration.VALUE);
            this.valueObjects = new ArrayList(valueConfigs.length);
            int i = 0;
            while (i < valueConfigs.length) {
                this.valueObjects.add(new ObjectDescriptor(valueConfigs[i]));
                ++i;
            }
            IConfigurationElement[] notValueConfigs = configElement.getChildren(AbstractProviderConfiguration.NOT_VALUE);
            this.notValueObjects = new ArrayList(notValueConfigs.length);
            int i2 = 0;
            while (i2 < notValueConfigs.length) {
                this.notValueObjects.add(new ObjectDescriptor(notValueConfigs[i2]));
                ++i2;
            }
        }

        private void parseValueLiteralString(String s, Set list) {
            int start = 0;
            int end = s.indexOf(44);
            while (end != -1) {
                if (s.charAt(end - 1) == '\\') {
                    s = String.valueOf(s.substring(0, end - 1)) + s.substring(end);
                    end = s.indexOf(44, end);
                    continue;
                }
                list.add(s.substring(start, end).trim().intern());
                start = end + 1;
                end = s.indexOf(44, start);
            }
            list.add(s.substring(start).trim().intern());
        }

        public boolean sameAs(Object object) {
            if (!this.valueLiterals.isEmpty() && !this.valueLiterals.contains(object.toString())) {
                return false;
            }
            if (!this.notValueLiterals.isEmpty() && this.notValueLiterals.contains(object.toString())) {
                return false;
            }
            if (!this.valueObjects.isEmpty() && !this.isObjectinList(object, this.valueObjects)) {
                return false;
            }
            return this.notValueObjects.isEmpty() || !this.isObjectinList(object, this.notValueObjects);
        }

        private boolean isObjectinList(Object object, List list) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                if (!((ObjectDescriptor)i.next()).sameAs(object)) continue;
                return true;
            }
            return false;
        }
    }

    private static class MethodValueEntry {
        public MethodDescriptor method;
        public ValueDescriptor value;

        public MethodValueEntry(MethodDescriptor method, ValueDescriptor value) {
            this.method = method;
            this.value = value;
        }
    }
}

