/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.core.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.gmf.runtime.common.core.internal.CommonCorePlugin;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.core.util.EnumeratedType;
import org.eclipse.gmf.runtime.common.core.util.Log;

public abstract class ExecutionStrategy
extends EnumeratedType {
    public static final ProviderPriority[] PRIORITIES;
    private static int nextOrdinal;
    public static final ExecutionStrategy FIRST;
    public static final ExecutionStrategy LAST;
    public static final ExecutionStrategy FORWARD;
    public static final ExecutionStrategy REVERSE;
    private static final ExecutionStrategy[] VALUES;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        PRIORITIES = new ProviderPriority[]{ProviderPriority.HIGHEST, ProviderPriority.HIGH, ProviderPriority.MEDIUM, ProviderPriority.LOW, ProviderPriority.LOWEST};
        nextOrdinal = 0;
        FIRST = new ExecutionStrategy("First"){
            private static final long serialVersionUID = 1L;

            public List execute(Service service, IOperation operation) {
                int i = 0;
                while (i < PRIORITIES.length) {
                    List providers = service.getProviders(this, PRIORITIES[i], operation);
                    if (providers.size() != 0) {
                        return Collections.singletonList(operation.execute((IProvider)providers.get(0)));
                    }
                    ++i;
                }
                return Collections.EMPTY_LIST;
            }

            public List getUncachedProviders(Service service, ProviderPriority priority, IOperation operation) {
                List descriptors = service.getProviders(priority);
                int size = descriptors.size();
                int i = 0;
                while (i < size) {
                    Service.ProviderDescriptor descriptor = (Service.ProviderDescriptor)descriptors.get(i);
                    if (ExecutionStrategy.safeProvides(descriptor, operation)) {
                        return Collections.singletonList(descriptor.getProvider());
                    }
                    ++i;
                }
                return Collections.EMPTY_LIST;
            }
        };
        LAST = new ExecutionStrategy("Last"){
            private static final long serialVersionUID = 1L;

            public List execute(Service service, IOperation operation) {
                int i = PRIORITIES.length;
                while (--i >= 0) {
                    List providers = service.getProviders(this, PRIORITIES[i], operation);
                    int size = providers.size();
                    if (size == 0) continue;
                    return Collections.singletonList(operation.execute((IProvider)providers.get(size - 1)));
                }
                return Collections.EMPTY_LIST;
            }

            public List getUncachedProviders(Service service, ProviderPriority priority, IOperation operation) {
                List descriptors = service.getProviders(priority);
                int i = descriptors.size();
                while (--i >= 0) {
                    Service.ProviderDescriptor descriptor = (Service.ProviderDescriptor)descriptors.get(i);
                    if (!ExecutionStrategy.safeProvides(descriptor, operation)) continue;
                    return Collections.singletonList(descriptor.getProvider());
                }
                return Collections.EMPTY_LIST;
            }
        };
        FORWARD = new ExecutionStrategy("Forward"){
            private static final long serialVersionUID = 1L;

            public List execute(Service service, IOperation operation) {
                ArrayList<Object> results = new ArrayList<Object>();
                int i = 0;
                while (i < PRIORITIES.length) {
                    List providers = service.getProviders(this, PRIORITIES[i], operation);
                    int size = providers.size();
                    int j = 0;
                    while (j < size) {
                        results.add(operation.execute((IProvider)providers.get(j)));
                        ++j;
                    }
                    ++i;
                }
                return results;
            }
        };
        REVERSE = new ExecutionStrategy("Reverse"){
            private static final long serialVersionUID = 1L;

            public List execute(Service service, IOperation operation) {
                ArrayList<Object> results = new ArrayList<Object>();
                int i = PRIORITIES.length;
                while (--i >= 0) {
                    List providers = service.getProviders(this, PRIORITIES[i], operation);
                    int j = providers.size();
                    while (--j >= 0) {
                        results.add(operation.execute((IProvider)providers.get(j)));
                    }
                }
                return results;
            }
        };
        VALUES = new ExecutionStrategy[]{FIRST, LAST, FORWARD, REVERSE};
    }

    protected ExecutionStrategy(String name) {
        super(name, nextOrdinal++);
    }

    protected ExecutionStrategy(String name, int ordinal) {
        super(name, ordinal);
    }

    protected List getValues() {
        return Collections.unmodifiableList(Arrays.asList(VALUES));
    }

    public abstract List execute(Service var1, IOperation var2);

    public List getUncachedProviders(Service service, ProviderPriority priority, IOperation operation) {
        List descriptors = service.getProviders(priority);
        int size = descriptors.size();
        ArrayList<IProvider> providers = new ArrayList<IProvider>(size);
        int i = 0;
        while (i < size) {
            Service.ProviderDescriptor descriptor = (Service.ProviderDescriptor)descriptors.get(i);
            if (ExecutionStrategy.safeProvides(descriptor, operation)) {
                providers.add(descriptor.getProvider());
            }
            ++i;
        }
        return providers;
    }

    protected final List getProviders(Service service, ProviderPriority priority) {
        return service.getProviders(priority);
    }

    protected final List getProviders(Service service, ExecutionStrategy strategy, ProviderPriority priority, IOperation operation) {
        return service.getProviders(strategy, priority, operation);
    }

    private static boolean safeProvides(IProvider provider, IOperation operation) {
        if (!$assertionsDisabled && provider == null) {
            throw new AssertionError();
        }
        try {
            return provider.provides(operation);
        }
        catch (Exception e) {
            List ignoredProviders = Service.getIgnoredProviders();
            String providerClassName = provider.getClass().getName();
            if (!ignoredProviders.contains(providerClassName)) {
                ignoredProviders.add(providerClassName);
                Log.log(CommonCorePlugin.getDefault(), 4, 5, "Ignoring provider " + provider + " since it threw an exception in the provides() method", e);
            }
            return false;
        }
    }
}

