/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.validate;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.validate.AbstractValidator;
import org.eclipse.gmf.internal.validate.ConstraintAdapter;
import org.eclipse.gmf.internal.validate.DebugOptions;
import org.eclipse.gmf.internal.validate.LabelProvider;
import org.eclipse.gmf.internal.validate.Messages;
import org.eclipse.gmf.internal.validate.StatusCodes;
import org.eclipse.gmf.internal.validate.Trace;
import org.eclipse.gmf.internal.validate.expressions.ExpressionProviderRegistry;
import org.eclipse.gmf.internal.validate.expressions.IModelExpression;

public class AnnotatedOclValidator
extends AbstractValidator
implements EValidator {
    private static ConstraintHandler oclHandler = new ConstraintHandler();

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map context) {
        return this.validateOCL(eObject, diagnostics, context);
    }

    protected boolean validateOCL(EObject eObject, DiagnosticChain diagnostics, Map context) {
        if (eObject instanceof EAnnotation) {
            return oclHandler.handleEAnnotation((EAnnotation)eObject, diagnostics, context);
        }
        if (eObject.eClass().getEPackage() != EcorePackage.eINSTANCE) {
            return oclHandler.handleMetaModel(eObject.eClass(), eObject, diagnostics, context);
        }
        return true;
    }

    private static class ConstraintHandler {
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.internal.validate.AnnotatedOclValidator$ConstraintHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        protected EClass getContextType(EModelElement constrainedElement) {
            if (constrainedElement instanceof EClass) {
                return (EClass)constrainedElement;
            }
            if (constrainedElement instanceof EStructuralFeature) {
                return ((EStructuralFeature)constrainedElement).getEContainingClass();
            }
            return null;
        }

        protected boolean handleEAnnotation(EAnnotation annotation, DiagnosticChain diagnostics, Map context) {
            return this.handleEAnnotation(annotation, null, diagnostics, context);
        }

        protected boolean handleEAnnotation(EAnnotation annotation, EObject contextInstance, DiagnosticChain diagnostics, Map context) {
            if (!"http://www.eclipse.org/gmf/2005/constraints".equals(annotation.getSource())) {
                return true;
            }
            boolean isValid = true;
            Iterator it = annotation.getDetails().iterator();
            while (it.hasNext()) {
                String body;
                Map.Entry nextDetail = (Map.Entry)it.next();
                String key = String.valueOf(nextDetail.getKey());
                if (!ExpressionProviderRegistry.getInstance().getLanguages().contains(key) || (body = ConstraintHandler.readBodyDetail(nextDetail, diagnostics)) == null) continue;
                EModelElement constrainedElement = annotation.getEModelElement();
                EClass contextClass = this.getContextType(constrainedElement);
                if (contextClass != null) {
                    IModelExpression expression = AnnotatedOclValidator.getExpression(key, body, (EClassifier)contextClass, context);
                    if (!$assertionsDisabled && expression == null) {
                        throw new AssertionError();
                    }
                    ConstraintAdapter constraint = new ConstraintAdapter(expression);
                    if (contextInstance != null) {
                        isValid &= this.handleConstraintDefition(constraint, contextInstance, diagnostics);
                        isValid &= this.handleConstrainedElement(constraint, contextInstance, ConstraintHandler.getDescriptionDetail(annotation), diagnostics);
                        continue;
                    }
                    isValid &= this.handleConstraintDefition(constraint, nextDetail, diagnostics);
                    continue;
                }
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.gmf.validation", StatusCodes.INVALID_CONSTRAINT_CONTEXT, MessageFormat.format(Messages.validation_ConstraintInInvalidContext, LabelProvider.INSTANCE.getObjectLabel((EObject)constrainedElement)), new Object[]{nextDetail}));
            }
            return isValid;
        }

        private static String getDescriptionDetail(EAnnotation annotation) {
            Object val = annotation.getDetails().get((Object)"description");
            return val != null ? String.valueOf(val) : null;
        }

        private static String readBodyDetail(Map.Entry bodyEntry, DiagnosticChain diagnostics) {
            String body = (String)bodyEntry.getValue();
            if (body != null && body.trim().length() > 0) {
                return body;
            }
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.gmf.validation", StatusCodes.EMPTY_CONSTRAINT_BODY, Messages.validation_EmptyExpressionBody, new Object[]{bodyEntry}));
            return null;
        }

        protected boolean handleMetaModel(EClass eClass, EObject modelElement, DiagnosticChain diagnostics, Map context) {
            EAnnotation annotation;
            boolean isValid = true;
            Iterator it = eClass.getEAnnotations().iterator();
            while (it.hasNext()) {
                EAnnotation nextAnnocation = (EAnnotation)it.next();
                if (!"http://www.eclipse.org/gmf/2005/constraints".equals(nextAnnocation.getSource())) continue;
                this.handleEAnnotation(nextAnnocation, modelElement, diagnostics, context);
            }
            it = eClass.getEOperations().iterator();
            while (it.hasNext()) {
                EOperation nextOperation = (EOperation)it.next();
                annotation = nextOperation.getEAnnotation("http://www.eclipse.org/gmf/2005/constraints");
                if (annotation == null) continue;
                isValid &= this.handleEAnnotation(annotation, modelElement, diagnostics, context);
            }
            it = eClass.getEStructuralFeatures().iterator();
            while (it.hasNext()) {
                EStructuralFeature nextFeature = (EStructuralFeature)it.next();
                annotation = nextFeature.getEAnnotation("http://www.eclipse.org/gmf/2005/constraints");
                if (annotation == null) continue;
                isValid &= this.handleEAnnotation(annotation, modelElement, diagnostics, context);
            }
            EList superTypes = eClass.getESuperTypes();
            Iterator it2 = superTypes.iterator();
            while (it2.hasNext()) {
                EClass nextSuperType = (EClass)it2.next();
                isValid &= this.handleMetaModel(nextSuperType, modelElement, diagnostics, context);
            }
            return isValid;
        }

        protected boolean handleConstraintDefition(ConstraintAdapter constraintProxy, Object target, DiagnosticChain diagnostics) {
            IStatus constraintStatus = constraintProxy.getStatus();
            if (Trace.shouldTrace(DebugOptions.META_DEFINITIONS)) {
                String msgPtn = "[metamodel-constraint] context={0} body={1}";
                Trace.trace(MessageFormat.format(msgPtn, LabelProvider.INSTANCE.getObjectLabel((EObject)constraintProxy.getContext()), constraintProxy.getBody()));
            }
            if (!constraintStatus.isOK()) {
                String message = MessageFormat.format(Messages.invalidExpressionBody, constraintProxy.getBody(), constraintStatus.getMessage());
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.gmf.validation", constraintStatus.getCode(), message, new Object[]{target}));
                return false;
            }
            return true;
        }

        protected boolean handleConstrainedElement(ConstraintAdapter constraint, EObject constrainedElement, String description, DiagnosticChain diagnostics) {
            if (!constraint.isSatisfied(constrainedElement)) {
                String message = null;
                message = description == null ? MessageFormat.format(Messages.validation_ConstraintViolation, constraint.getBody(), LabelProvider.INSTANCE.getObjectLabel(constrainedElement)) : description;
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.gmf.validation", 225, message, new Object[]{constrainedElement}));
                return false;
            }
            return true;
        }
    }
}

