/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.popup.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.util.Generator;
import org.eclipse.gmf.internal.codegen.CodeGenUIPlugin;
import org.eclipse.gmf.internal.codegen.popup.actions.ErrorDialogEx;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ExecuteTemplatesAction
implements IObjectActionDelegate,
IRunnableWithProgress {
    private static final String ASK_OK = "ask_ok";
    private IFile mySelection;
    private IWorkbenchPart myPart;
    protected IStatus myRunStatus;
    private GenEditorGenerator myGenModel;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.internal.codegen.popup.actions.ExecuteTemplatesAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.myPart = targetPart;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IAction action) {
        try {
            block14: {
                try {
                    this.loadGenModel();
                    if (!$assertionsDisabled && this.getGenModel() == null) {
                        throw new AssertionError();
                    }
                    IStatus isGenModelValid = this.validateGenModel();
                    if (!isGenModelValid.isOK()) {
                        String[] buttons = new String[]{IDialogConstants.PROCEED_LABEL, IDialogConstants.CANCEL_LABEL};
                        int[] buttonIDs = new int[]{10, 1};
                        String msg = CodeGenUIPlugin.getBundleString("generatecode.badsrc");
                        ErrorDialogEx dlg = new ErrorDialogEx(this.getShell(), action.getText(), msg, isGenModelValid, buttons, buttonIDs, 0);
                        if (dlg.open() == 1) {
                            Object var7_7 = null;
                            this.unloadGenModel();
                            return;
                        }
                    }
                    this.doRunWithStatus();
                    if (this.getRunStatus().isOK()) {
                        if (!"always".equals(ExecuteTemplatesAction.getPreferences().getString(ASK_OK))) {
                            MessageDialogWithToggle.openInformation((Shell)this.getShell(), (String)action.getText(), (String)CodeGenUIPlugin.getBundleString("generatecode.ok"), (String)CodeGenUIPlugin.getBundleString("generatecode.neveragain"), (boolean)false, (IPreferenceStore)ExecuteTemplatesAction.getPreferences(), (String)ASK_OK);
                        }
                        break block14;
                    }
                    if (this.myRunStatus.matches(4)) {
                        CodeGenUIPlugin.getDefault().getLog().log(this.getRunStatus());
                        ErrorDialog.openError((Shell)this.getShell(), (String)action.getText(), (String)CodeGenUIPlugin.getBundleString("generatecode.err"), (IStatus)this.getRunStatus());
                        break block14;
                    }
                    if (this.myRunStatus.matches(2)) {
                        ErrorDialog.openError((Shell)this.getShell(), (String)action.getText(), (String)CodeGenUIPlugin.getBundleString("generatecode.warn"), (IStatus)this.getRunStatus());
                    } else if (this.myRunStatus.matches(1)) {
                        ErrorDialog.openError((Shell)this.getShell(), (String)action.getText(), (String)CodeGenUIPlugin.getBundleString("generatecode.info"), (IStatus)this.getRunStatus());
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
            Object var7_9 = null;
            this.unloadGenModel();
            return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.unloadGenModel();
            throw throwable;
        }
    }

    private void doRunWithStatus() throws InterruptedException {
        this.myRunStatus = Status.CANCEL_STATUS;
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)this);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            this.myRunStatus = targetException instanceof CoreException ? ((CoreException)targetException).getStatus() : new Status(4, CodeGenUIPlugin.getPluginID(), 0, "Exception occurred while generating code", targetException);
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Generator g = new Generator(this.getGenModel());
        g.run(monitor);
        this.myRunStatus = g.getRunStatus();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.mySelection = null;
        action.setEnabled(false);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        this.mySelection = (IFile)((IStructuredSelection)selection).getFirstElement();
        action.setEnabled(true);
    }

    private IStatus getRunStatus() {
        return this.myRunStatus;
    }

    protected final GenEditorGenerator getGenModel() {
        return this.myGenModel;
    }

    private void loadGenModel() {
        ResourceSetImpl srcResSet = new ResourceSetImpl();
        URI selected = URI.createPlatformResourceURI((String)this.mySelection.getFullPath().toString());
        Resource srcRes = srcResSet.getResource(selected, true);
        Object root = srcRes.getContents().get(0);
        if (root instanceof GenDiagram) {
            this.myGenModel = ((GenDiagram)root).getEditorGen();
        } else if (root instanceof GenEditorGenerator) {
            this.myGenModel = (GenEditorGenerator)root;
        }
        if (this.myGenModel != null && this.myGenModel.getDomainGenModel() != null) {
            this.myGenModel.getDomainGenModel().reconcile();
        }
    }

    private void unloadGenModel() {
        if (this.myGenModel != null && this.myGenModel.eResource() != null) {
            this.myGenModel.eResource().unload();
        }
        this.myGenModel = null;
    }

    private IStatus validateGenModel() {
        return BasicDiagnostic.toIStatus((Diagnostic)Diagnostician.INSTANCE.validate((EObject)this.getGenModel()));
    }

    private Shell getShell() {
        return this.myPart.getSite().getShell();
    }

    private static IPreferenceStore getPreferences() {
        return CodeGenUIPlugin.getDefault().getPreferenceStore();
    }
}

