/******************************************************************************
 * Copyright (c) 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - initial API and implementation 
 ****************************************************************************/

package org.eclipse.gmf.runtime.notation.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.gmf.runtime.notation.util.NotationAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class NotationItemProviderAdapterFactory extends NotationAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected Collection supportedTypes = new ArrayList();

    /**
     * This constructs an instance.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotationItemProviderAdapterFactory() {
        supportedTypes.add(IEditingDomainItemProvider.class);
        supportedTypes.add(IStructuredItemContentProvider.class);
        supportedTypes.add(ITreeItemContentProvider.class);
        supportedTypes.add(IItemLabelProvider.class);
        supportedTypes.add(IItemPropertySource.class);		
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.Edge} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected EdgeItemProvider edgeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.Edge}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createEdgeAdapter() {
        if (edgeItemProvider == null) {
            edgeItemProvider = new EdgeItemProvider(this);
        }

        return edgeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.Node} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected NodeItemProvider nodeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.Node}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createNodeAdapter() {
        if (nodeItemProvider == null) {
            nodeItemProvider = new NodeItemProvider(this);
        }

        return nodeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.FillStyle} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected FillStyleItemProvider fillStyleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.FillStyle}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createFillStyleAdapter() {
        if (fillStyleItemProvider == null) {
            fillStyleItemProvider = new FillStyleItemProvider(this);
        }

        return fillStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.LineStyle} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected LineStyleItemProvider lineStyleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.LineStyle}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createLineStyleAdapter() {
        if (lineStyleItemProvider == null) {
            lineStyleItemProvider = new LineStyleItemProvider(this);
        }

        return lineStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.FontStyle} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected FontStyleItemProvider fontStyleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.FontStyle}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createFontStyleAdapter() {
        if (fontStyleItemProvider == null) {
            fontStyleItemProvider = new FontStyleItemProvider(this);
        }

        return fontStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.TitleStyle} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected TitleStyleItemProvider titleStyleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.TitleStyle}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createTitleStyleAdapter() {
        if (titleStyleItemProvider == null) {
            titleStyleItemProvider = new TitleStyleItemProvider(this);
        }

        return titleStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.SortingStyle} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected SortingStyleItemProvider sortingStyleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.SortingStyle}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createSortingStyleAdapter() {
        if (sortingStyleItemProvider == null) {
            sortingStyleItemProvider = new SortingStyleItemProvider(this);
        }

        return sortingStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.DescriptionStyle} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected DescriptionStyleItemProvider descriptionStyleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.DescriptionStyle}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createDescriptionStyleAdapter() {
        if (descriptionStyleItemProvider == null) {
            descriptionStyleItemProvider = new DescriptionStyleItemProvider(this);
        }

        return descriptionStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.Size} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected SizeItemProvider sizeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.Size}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createSizeAdapter() {
        if (sizeItemProvider == null) {
            sizeItemProvider = new SizeItemProvider(this);
        }

        return sizeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.Location} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected LocationItemProvider locationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.Location}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createLocationAdapter() {
        if (locationItemProvider == null) {
            locationItemProvider = new LocationItemProvider(this);
        }

        return locationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.Bounds} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected BoundsItemProvider boundsItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.Bounds}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createBoundsAdapter() {
        if (boundsItemProvider == null) {
            boundsItemProvider = new BoundsItemProvider(this);
        }

        return boundsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.Ratio} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected RatioItemProvider ratioItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.Ratio}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createRatioAdapter() {
        if (ratioItemProvider == null) {
            ratioItemProvider = new RatioItemProvider(this);
        }

        return ratioItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.IdentityAnchor} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected IdentityAnchorItemProvider identityAnchorItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.IdentityAnchor}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createIdentityAnchorAdapter() {
        if (identityAnchorItemProvider == null) {
            identityAnchorItemProvider = new IdentityAnchorItemProvider(this);
        }

        return identityAnchorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.RoutingStyle} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected RoutingStyleItemProvider routingStyleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.RoutingStyle}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createRoutingStyleAdapter() {
        if (routingStyleItemProvider == null) {
            routingStyleItemProvider = new RoutingStyleItemProvider(this);
        }

        return routingStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.RelativeBendpoints} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected RelativeBendpointsItemProvider relativeBendpointsItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.RelativeBendpoints}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createRelativeBendpointsAdapter() {
        if (relativeBendpointsItemProvider == null) {
            relativeBendpointsItemProvider = new RelativeBendpointsItemProvider(this);
        }

        return relativeBendpointsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.CanonicalStyle} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected CanonicalStyleItemProvider canonicalStyleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.CanonicalStyle}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createCanonicalStyleAdapter() {
        if (canonicalStyleItemProvider == null) {
            canonicalStyleItemProvider = new CanonicalStyleItemProvider(this);
        }

        return canonicalStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.ShapeStyle} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ShapeStyleItemProvider shapeStyleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.ShapeStyle}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createShapeStyleAdapter() {
        if (shapeStyleItemProvider == null) {
            shapeStyleItemProvider = new ShapeStyleItemProvider(this);
        }

        return shapeStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.ConnectorStyle} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ConnectorStyleItemProvider connectorStyleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.ConnectorStyle}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createConnectorStyleAdapter() {
        if (connectorStyleItemProvider == null) {
            connectorStyleItemProvider = new ConnectorStyleItemProvider(this);
        }

        return connectorStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.Diagram} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected DiagramItemProvider diagramItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.Diagram}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createDiagramAdapter() {
        if (diagramItemProvider == null) {
            diagramItemProvider = new DiagramItemProvider(this);
        }

        return diagramItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.Image} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ImageItemProvider imageItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.Image}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createImageAdapter() {
        if (imageItemProvider == null) {
            imageItemProvider = new ImageItemProvider(this);
        }

        return imageItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.PageStyle} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected PageStyleItemProvider pageStyleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.PageStyle}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createPageStyleAdapter() {
        if (pageStyleItemProvider == null) {
            pageStyleItemProvider = new PageStyleItemProvider(this);
        }

        return pageStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.DrawerStyle} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected DrawerStyleItemProvider drawerStyleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.DrawerStyle}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createDrawerStyleAdapter() {
        if (drawerStyleItemProvider == null) {
            drawerStyleItemProvider = new DrawerStyleItemProvider(this);
        }

        return drawerStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.GuideStyle} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected GuideStyleItemProvider guideStyleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.GuideStyle}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createGuideStyleAdapter() {
        if (guideStyleItemProvider == null) {
            guideStyleItemProvider = new GuideStyleItemProvider(this);
        }

        return guideStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.Guide} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected GuideItemProvider guideItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.Guide}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createGuideAdapter() {
        if (guideItemProvider == null) {
            guideItemProvider = new GuideItemProvider(this);
        }

        return guideItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected NodeEntryItemProvider nodeEntryItemProvider;

    /**
     * This creates an adapter for a {@link java.util.Map.Entry}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createNodeEntryAdapter() {
        if (nodeEntryItemProvider == null) {
            nodeEntryItemProvider = new NodeEntryItemProvider(this);
        }

        return nodeEntryItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.FilteringStyle} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected FilteringStyleItemProvider filteringStyleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.FilteringStyle}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createFilteringStyleAdapter() {
        if (filteringStyleItemProvider == null) {
            filteringStyleItemProvider = new FilteringStyleItemProvider(this);
        }

        return filteringStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.DiagramStyle} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected DiagramStyleItemProvider diagramStyleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.DiagramStyle}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createDiagramStyleAdapter() {
        if (diagramStyleItemProvider == null) {
            diagramStyleItemProvider = new DiagramStyleItemProvider(this);
        }

        return diagramStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.ImageStyle} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ImageStyleItemProvider imageStyleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.ImageStyle}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createImageStyleAdapter() {
        if (imageStyleItemProvider == null) {
            imageStyleItemProvider = new ImageStyleItemProvider(this);
        }

        return imageStyleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.ImageBufferStyle} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ImageBufferStyleItemProvider imageBufferStyleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.ImageBufferStyle}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createImageBufferStyleAdapter() {
        if (imageBufferStyleItemProvider == null) {
            imageBufferStyleItemProvider = new ImageBufferStyleItemProvider(this);
        }

        return imageBufferStyleItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public ComposeableAdapterFactory getRootAdapterFactory() {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean isFactoryForType(Object type) {
        return supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Object adapt(Object object, Object type) {
        if (isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || (((Class)type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void addListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void fireNotifyChanged(Notification notification) {
        changeNotifier.fireNotifyChanged(notification);

        if (parentAdapterFactory != null) {
            parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. 
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void dispose() {
        if (edgeItemProvider != null) edgeItemProvider.dispose();
        if (nodeItemProvider != null) nodeItemProvider.dispose();
        if (fillStyleItemProvider != null) fillStyleItemProvider.dispose();
        if (lineStyleItemProvider != null) lineStyleItemProvider.dispose();
        if (fontStyleItemProvider != null) fontStyleItemProvider.dispose();
        if (titleStyleItemProvider != null) titleStyleItemProvider.dispose();
        if (sortingStyleItemProvider != null) sortingStyleItemProvider.dispose();
        if (descriptionStyleItemProvider != null) descriptionStyleItemProvider.dispose();
        if (sizeItemProvider != null) sizeItemProvider.dispose();
        if (locationItemProvider != null) locationItemProvider.dispose();
        if (boundsItemProvider != null) boundsItemProvider.dispose();
        if (ratioItemProvider != null) ratioItemProvider.dispose();
        if (identityAnchorItemProvider != null) identityAnchorItemProvider.dispose();
        if (routingStyleItemProvider != null) routingStyleItemProvider.dispose();
        if (relativeBendpointsItemProvider != null) relativeBendpointsItemProvider.dispose();
        if (diagramItemProvider != null) diagramItemProvider.dispose();
        if (imageItemProvider != null) imageItemProvider.dispose();
        if (canonicalStyleItemProvider != null) canonicalStyleItemProvider.dispose();
        if (shapeStyleItemProvider != null) shapeStyleItemProvider.dispose();
        if (connectorStyleItemProvider != null) connectorStyleItemProvider.dispose();
        if (pageStyleItemProvider != null) pageStyleItemProvider.dispose();
        if (drawerStyleItemProvider != null) drawerStyleItemProvider.dispose();
        if (guideStyleItemProvider != null) guideStyleItemProvider.dispose();
        if (guideItemProvider != null) guideItemProvider.dispose();
        if (nodeEntryItemProvider != null) nodeEntryItemProvider.dispose();
        if (filteringStyleItemProvider != null) filteringStyleItemProvider.dispose();
        if (diagramStyleItemProvider != null) diagramStyleItemProvider.dispose();
        if (imageStyleItemProvider != null) imageStyleItemProvider.dispose();
        if (imageBufferStyleItemProvider != null) imageBufferStyleItemProvider.dispose();
    }

}
