/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.type.core;

import java.util.Arrays;
import java.util.LinkedHashSet;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.emf.type.core.ClientContextManager;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IEditHelperContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelperAdvice;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.EmployeeFactory;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.EmployeePackage;

public class AbstractEMFTypeTest
extends TestCase {
    private TransactionalEditingDomain editingDomain;
    private Resource defaultResource;
    private Resource resourceWithContext;
    private EmployeePackage employeePkg;
    private EmployeeFactory employeeFactory;

    protected AbstractEMFTypeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.employeePkg = EmployeePackage.eINSTANCE;
        this.employeeFactory = (EmployeeFactory)this.employeePkg.getEFactoryInstance();
        this.editingDomain = GMFEditingDomainFactory.getInstance().createEditingDomain();
        TransactionalEditingDomain.Registry.INSTANCE.add("org.eclipse.gmf.tests.runtime.emf.type.core.EditingDomain", this.editingDomain);
        this.defaultResource = this.editingDomain.getResourceSet().createResource(URI.createURI((String)"null://org.eclipse.gmf.tests.runtime.emf.type.core"));
        this.resourceWithContext = this.editingDomain.getResourceSet().createResource(URI.createURI((String)"null://org.eclipse.gmf.tests.runtime.emf.type.core.context"));
        RecordingCommand command = new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                AbstractEMFTypeTest.this.doModelSetup(AbstractEMFTypeTest.this.defaultResource);
                AbstractEMFTypeTest.this.doModelSetupWithContext(AbstractEMFTypeTest.this.resourceWithContext);
            }
        };
        try {
            ((TransactionalCommandStack)this.editingDomain.getCommandStack()).execute((Command)command, null);
        }
        catch (RollbackException e) {
            AbstractEMFTypeTest.fail((String)("setUp() failed:" + e.getLocalizedMessage()));
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.employeeFactory = null;
        this.employeePkg = null;
        this.defaultResource.unload();
        this.resourceWithContext.unload();
        this.editingDomain.dispose();
    }

    protected void doModelSetup(Resource resource) {
    }

    protected void doModelSetupWithContext(Resource resource) {
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected EmployeePackage getEmployeePackage() {
        return this.employeePkg;
    }

    protected Resource getResource() {
        return this.defaultResource;
    }

    protected Resource getResourceWithContext() {
        return this.resourceWithContext;
    }

    protected EmployeeFactory getEmployeeFactory() {
        return this.employeeFactory;
    }

    protected IStatus execute(ICommand command) {
        AbstractEMFTypeTest.assertTrue((boolean)command.canExecute());
        try {
            IStatus result = command.execute((IProgressMonitor)new NullProgressMonitor(), null);
            AbstractEMFTypeTest.assertTrue((boolean)result.isOK());
            return result;
        }
        catch (Exception e) {
            AbstractEMFTypeTest.fail((String)("Command execution failed: " + e.getLocalizedMessage()));
            return Status.CANCEL_STATUS;
        }
    }

    protected IStatus undo(ICommand command) {
        AbstractEMFTypeTest.assertTrue((boolean)command.canUndo());
        try {
            IStatus result = command.undo((IProgressMonitor)new NullProgressMonitor(), null);
            AbstractEMFTypeTest.assertTrue((boolean)result.isOK());
            return result;
        }
        catch (Exception e) {
            AbstractEMFTypeTest.fail((String)("Command undo failed: " + e.getLocalizedMessage()));
            return Status.CANCEL_STATUS;
        }
    }

    protected IStatus redo(ICommand command) {
        AbstractEMFTypeTest.assertTrue((boolean)command.canRedo());
        try {
            IStatus result = command.redo((IProgressMonitor)new NullProgressMonitor(), null);
            AbstractEMFTypeTest.assertTrue((boolean)result.isOK());
            return result;
        }
        catch (Exception e) {
            AbstractEMFTypeTest.fail((String)("Command redo failed: " + e.getLocalizedMessage()));
            return Status.CANCEL_STATUS;
        }
    }

    protected IEditHelperAdvice[] getWildcardAdvice(IClientContext clientContext) {
        IElementType dflt = ElementTypeRegistry.getInstance().getType("org.eclipse.gmf.runtime.emf.type.core.default");
        AbstractEMFTypeTest.assertNotNull((Object)dflt);
        return ElementTypeRegistry.getInstance().getEditHelperAdvice(dflt, clientContext);
    }

    protected IEditHelperAdvice[] getNonWildcardAdvice(IElementType type) {
        IClientContext context = ClientContextManager.getInstance().getBinding(type);
        return this.getNonWildcardAdvice(type, context);
    }

    protected IEditHelperAdvice[] getNonWildcardAdvice(IElementType type, IClientContext context) {
        LinkedHashSet<IEditHelperAdvice> result = new LinkedHashSet<IEditHelperAdvice>();
        result.addAll(Arrays.asList(ElementTypeRegistry.getInstance().getEditHelperAdvice(type, context)));
        result.removeAll(Arrays.asList(this.getWildcardAdvice(context)));
        return result.toArray(new IEditHelperAdvice[result.size()]);
    }

    protected IEditHelperAdvice[] getNonWildcardAdvice(IEditHelperContext context) {
        LinkedHashSet<IEditHelperAdvice> result = new LinkedHashSet<IEditHelperAdvice>();
        result.addAll(Arrays.asList(ElementTypeRegistry.getInstance().getEditHelperAdvice((Object)context)));
        result.removeAll(Arrays.asList(this.getWildcardAdvice(context.getClientContext())));
        return result.toArray(new IEditHelperAdvice[result.size()]);
    }

    protected IEditHelperAdvice[] getNonWildcardAdvice(EObject element) {
        IClientContext context = ClientContextManager.getInstance().getClientContextFor(element);
        return this.getNonWildcardAdvice(element, context);
    }

    protected IEditHelperAdvice[] getNonWildcardAdvice(EObject element, IClientContext context) {
        LinkedHashSet<IEditHelperAdvice> result = new LinkedHashSet<IEditHelperAdvice>();
        result.addAll(Arrays.asList(ElementTypeRegistry.getInstance().getEditHelperAdvice(element, context)));
        result.removeAll(Arrays.asList(this.getWildcardAdvice(context)));
        return result.toArray(new IEditHelperAdvice[result.size()]);
    }
}

