/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.type.core;

import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.emf.type.core.ClientContext;
import org.eclipse.gmf.runtime.emf.type.core.ClientContextManager;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.NullElementMatcher;
import org.eclipse.gmf.tests.runtime.emf.type.core.AbstractEMFTypeTest;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Department;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Employee;
import org.eclipse.gmf.tests.runtime.emf.type.core.internal.EmployeeType;

public class ClientContextManagerTest
extends AbstractEMFTypeTest {
    private IClientContext clientContext1;
    private IClientContext clientContext2;
    private IClientContext unboundClientContext;
    private Department department;
    private Employee employee;
    static /* synthetic */ Class class$0;

    public ClientContextManagerTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ClientContextManagerTest.suite());
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.ClientContextManagerTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz, "ClientContextManager Test Suite");
    }

    protected void doModelSetupWithContext(Resource resource) {
        this.department = (Department)this.getEmployeeFactory().create(this.getEmployeePackage().getDepartment());
        this.department.setName("Department");
        resource.getContents().add((Object)this.department);
        this.employee = (Employee)this.getEmployeeFactory().create(this.getEmployeePackage().getEmployee());
        this.employee.setNumber(1);
        this.department.getMembers().add((Object)this.employee);
    }

    protected IClientContext getClientContext1() {
        if (this.clientContext1 == null) {
            this.clientContext1 = ClientContextManager.getInstance().getClientContext("org.eclipse.gmf.tests.runtime.emf.type.core.ClientContext1");
        }
        return this.clientContext1;
    }

    protected IClientContext getClientContext2() {
        if (this.clientContext2 == null) {
            this.clientContext2 = ClientContextManager.getInstance().getClientContext("org.eclipse.gmf.tests.runtime.emf.type.core.ClientContext2");
        }
        return this.clientContext2;
    }

    protected IClientContext getUnboundClientContext() {
        if (this.unboundClientContext == null) {
            this.unboundClientContext = ClientContextManager.getInstance().getClientContext("org.eclipse.gmf.tests.runtime.emf.type.core.UnboundClientContext");
        }
        return this.unboundClientContext;
    }

    public void test_getBinding_type() {
        IClientContext context = ClientContextManager.getInstance().getBinding(EmployeeType.CONTEXT_EMPLOYEE);
        ClientContextManagerTest.assertTrue((boolean)context.isMultiClientContext());
        ClientContextManagerTest.assertEquals((int)2, (int)context.getChildren().size());
        ClientContextManagerTest.assertTrue((boolean)context.getChildren().contains(this.getClientContext1()));
        ClientContextManagerTest.assertTrue((boolean)context.getChildren().contains(this.getClientContext2()));
    }

    public void test_getClientContext() {
        String unboundID = "org.eclipse.gmf.tests.runtime.emf.type.core.UnboundClientContext";
        IClientContext context = ClientContextManager.getInstance().getClientContext(unboundID);
        ClientContextManagerTest.assertNotNull((Object)context);
        ClientContextManagerTest.assertTrue((boolean)context.getId().equals(unboundID));
        ClientContextManagerTest.assertTrue((boolean)(context.getMatcher() instanceof NullElementMatcher));
    }

    public void test_getClientContextFor() {
        IClientContext context = ClientContextManager.getInstance().getClientContextFor((EObject)this.employee);
        ClientContextManagerTest.assertTrue((boolean)context.isMultiClientContext());
        ClientContextManagerTest.assertEquals((int)2, (int)context.getChildren().size());
        ClientContextManagerTest.assertTrue((boolean)context.getChildren().contains(this.getClientContext1()));
        ClientContextManagerTest.assertTrue((boolean)context.getChildren().contains(this.getClientContext2()));
    }

    public void test_getClientContexts() {
        Set contexts = ClientContextManager.getInstance().getClientContexts();
        ClientContextManagerTest.assertTrue((boolean)contexts.contains(this.getClientContext1()));
        ClientContextManagerTest.assertTrue((boolean)contexts.contains(this.getClientContext2()));
        ClientContextManagerTest.assertTrue((boolean)contexts.contains(this.getUnboundClientContext()));
    }

    public void test_registerClientContext() {
        ClientContext newContext = new ClientContext("ClientContextManagerTest.context", (IElementMatcher)new NullElementMatcher());
        ClientContextManager.getInstance().registerClientContext((IClientContext)newContext);
        IClientContext contextFromManager = ClientContextManager.getInstance().getClientContext("ClientContextManagerTest.context");
        ClientContextManagerTest.assertSame((Object)newContext, (Object)contextFromManager);
    }
}

