/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.type.core.commands;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.tests.runtime.emf.type.core.AbstractEMFTypeTest;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Department;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.EmployeePackage;
import org.eclipse.gmf.tests.runtime.emf.type.core.internal.EmployeeType;

public class CreateElementCommandTest
extends AbstractEMFTypeTest {
    private Department department;
    private CreateElementCommand fixture;
    static /* synthetic */ Class class$0;

    public CreateElementCommandTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)CreateElementCommandTest.suite());
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.commands.CreateElementCommandTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz, "CreateElementCommand Test Suite");
    }

    protected void doModelSetup(Resource resource) {
        this.department = (Department)this.getEmployeeFactory().create(this.getEmployeePackage().getDepartment());
        this.department.setName("Department");
        resource.getContents().add((Object)this.department);
    }

    protected CreateElementCommand getFixture() {
        return this.fixture;
    }

    protected void setFixture(CreateElementCommand fixture) {
        this.fixture = fixture;
    }

    public void test_isExecutable_noEClassToEdit() {
        CreateElementRequest request = new CreateElementRequest(this.getEditingDomain(), null, EmployeeType.EMPLOYEE, EmployeePackage.eINSTANCE.getDepartment_Members());
        this.setFixture(new CreateElementCommand(request));
        CreateElementCommandTest.assertFalse((boolean)this.getFixture().canExecute());
    }

    public void test_configureStatusPropagated_139736() {
        CreateElementRequest request = new CreateElementRequest(this.getEditingDomain(), (EObject)this.department, (IElementType)EmployeeType.EXECUTIVE, EmployeePackage.eINSTANCE.getDepartment_Members());
        CreateElementCommand command = new CreateElementCommand(request);
        IStatus status = null;
        try {
            status = command.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            CreateElementCommandTest.fail((String)("Command execution failed: " + e.getLocalizedMessage()));
        }
        CreateElementCommandTest.assertEquals((int)0, (int)command.getCommandResult().getStatus().getSeverity());
        CreateElementCommandTest.assertEquals((int)0, (int)status.getSeverity());
        request = new CreateElementRequest(this.getEditingDomain(), (EObject)this.department, (IElementType)EmployeeType.EXECUTIVE, EmployeePackage.eINSTANCE.getDepartment_Members());
        request.setParameter("fail_configuration", (Object)Boolean.TRUE);
        command = new CreateElementCommand(request);
        status = null;
        try {
            status = command.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            CreateElementCommandTest.fail((String)("Command execution failed: " + e.getLocalizedMessage()));
        }
        CreateElementCommandTest.assertEquals((int)2, (int)command.getCommandResult().getStatus().getSeverity());
        CreateElementCommandTest.assertEquals((int)2, (int)status.getSeverity());
    }
}

