/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.type.core.commands;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.tests.runtime.emf.type.core.AbstractEMFTypeTest;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Client;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Customer;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.EmployeeFactory;
import org.eclipse.gmf.tests.runtime.emf.type.core.internal.ClientDependentsAdvice;
import org.eclipse.gmf.tests.runtime.emf.type.core.internal.DestroyCustomerAdvice;

public class DestroyElementCommandTest
extends AbstractEMFTypeTest {
    static final String ANNOTATION_SOURCE = "org.eclipse.gmf.tests.runtime.emf.type.core";
    private Customer parentCompany;
    private Customer customer;
    private Client billieJo;
    private Client jimBob;
    private EAnnotation billieJoAnnotation;
    private EAnnotation jimBobAnnotation;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DestroyElementCommandTest(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.commands.DestroyElementCommandTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz, "DestroyElementCommand Tests");
    }

    public void test_destroyCommand_basic() {
        DestroyElementCommand cmd = new DestroyElementCommand(new DestroyElementRequest((EObject)this.billieJo, false));
        this.execute((ICommand)cmd);
        this.assertDestroyed(this.billieJo);
        DestroyElementCommandTest.assertSame((Object)this.billieJoAnnotation.eContainer(), (Object)this.customer);
        DestroyElementCommandTest.assertEquals((int)0, (int)this.billieJoAnnotation.getReferences().size());
        this.undo((ICommand)cmd);
        DestroyElementCommandTest.assertSame((Object)this.customer, (Object)this.billieJo.eContainer());
        DestroyElementCommandTest.assertSame((Object)this.billieJoAnnotation.eContainer(), (Object)this.customer);
        DestroyElementCommandTest.assertTrue((boolean)this.billieJoAnnotation.getReferences().contains((Object)this.billieJo));
        this.redo((ICommand)cmd);
        this.assertDestroyed(this.billieJo);
        DestroyElementCommandTest.assertSame((Object)this.billieJoAnnotation.eContainer(), (Object)this.customer);
        DestroyElementCommandTest.assertEquals((int)0, (int)this.billieJoAnnotation.getReferences().size());
    }

    public void test_destroyCommand_detached() {
        Client detachedClient = this.getEmployeeFactory().createClient();
        DestroyElementRequest req = new DestroyElementRequest((EObject)detachedClient, false);
        DestroyElementCommandTest.assertNull((Object)req.getEditHelperContext());
        DestroyElementCommand cmd = new DestroyElementCommand(req);
        DestroyElementCommandTest.assertFalse((boolean)cmd.canExecute());
    }

    public void test_destroyCommand_withDependents() {
        DestroyElementRequest req = new DestroyElementRequest((EObject)this.billieJo, false);
        IElementType type = ElementTypeRegistry.getInstance().getElementType(req.getEditHelperContext());
        DestroyElementCommandTest.assertNotNull((Object)type);
        ICommand cmd = type.getEditCommand((IEditCommandRequest)req);
        DestroyElementCommandTest.assertNotNull((Object)cmd);
        this.assertNoDuplicates(cmd);
        this.execute(cmd);
        this.assertDestroyed(this.billieJo);
        this.assertDestroyed((EObject)this.billieJoAnnotation);
        this.undo(cmd);
        DestroyElementCommandTest.assertSame((Object)this.customer, (Object)this.billieJo.eContainer());
        DestroyElementCommandTest.assertSame((Object)this.billieJoAnnotation.eContainer(), (Object)this.customer);
        DestroyElementCommandTest.assertTrue((boolean)this.billieJoAnnotation.getReferences().contains((Object)this.billieJo));
        this.redo(cmd);
        this.assertDestroyed(this.billieJo);
        this.assertDestroyed((EObject)this.billieJoAnnotation);
    }

    public void test_destroyCommand_withContainment() {
        DestroyElementRequest req = new DestroyElementRequest((EObject)this.parentCompany, false);
        IElementType type = ElementTypeRegistry.getInstance().getElementType(req.getEditHelperContext());
        DestroyElementCommandTest.assertNotNull((Object)type);
        ICommand cmd = type.getEditCommand((IEditCommandRequest)req);
        DestroyElementCommandTest.assertNotNull((Object)cmd);
        this.assertNoDuplicates(cmd);
        this.execute(cmd);
        this.assertDestroyed(this.parentCompany);
        this.assertDestroyed(this.customer);
        this.assertDestroyed(this.billieJo);
        this.assertDestroyed((EObject)this.billieJoAnnotation);
        this.assertDestroyed(this.jimBob);
        this.assertDestroyed((EObject)this.jimBobAnnotation);
        this.undo(cmd);
        DestroyElementCommandTest.assertSame((Object)this.getResource(), (Object)this.parentCompany.eResource());
        DestroyElementCommandTest.assertSame((Object)this.parentCompany, (Object)this.customer.eContainer());
        DestroyElementCommandTest.assertSame((Object)this.customer, (Object)this.billieJo.eContainer());
        DestroyElementCommandTest.assertSame((Object)this.billieJoAnnotation.eContainer(), (Object)this.customer);
        DestroyElementCommandTest.assertTrue((boolean)this.billieJoAnnotation.getReferences().contains((Object)this.billieJo));
        DestroyElementCommandTest.assertSame((Object)this.customer, (Object)this.jimBob.eContainer());
        DestroyElementCommandTest.assertSame((Object)this.jimBobAnnotation.eContainer(), (Object)this.customer);
        DestroyElementCommandTest.assertTrue((boolean)this.jimBobAnnotation.getReferences().contains((Object)this.jimBob));
        this.redo(cmd);
        this.assertDestroyed(this.parentCompany);
        this.assertDestroyed(this.customer);
        this.assertDestroyed(this.billieJo);
        this.assertDestroyed((EObject)this.billieJoAnnotation);
        this.assertDestroyed(this.jimBob);
        this.assertDestroyed((EObject)this.jimBobAnnotation);
    }

    public void test_destroy_crossResourceContained_136738() {
        final Resource res1 = this.getEditingDomain().getResourceSet().createResource(URI.createURI((String)"null://res1.ecore"));
        final Resource res2 = this.getEditingDomain().getResourceSet().createResource(URI.createURI((String)"null://res2.ecore"));
        final EPackage pkg1 = EcoreFactory.eINSTANCE.createEPackage();
        pkg1.setName("package1");
        final EClass class1 = EcoreFactory.eINSTANCE.createEClass();
        class1.setName("Class1");
        final EClass class2 = EcoreFactory.eINSTANCE.createEClass();
        class2.setName("Class2");
        RecordingCommand command = new RecordingCommand(this.getEditingDomain()){

            protected void doExecute() {
                res1.getContents().add((Object)pkg1);
                pkg1.getEClassifiers().add((Object)class1);
                pkg1.getEClassifiers().add((Object)class2);
                class2.getESuperTypes().add((Object)class1);
                res2.getContents().add((Object)class2);
            }
        };
        this.getEditingDomain().getCommandStack().execute((Command)command);
        DestroyElementCommandTest.assertSame((Object)pkg1, (Object)class2.eContainer());
        DestroyElementCommandTest.assertSame((Object)res2, (Object)class2.eResource());
        DestroyElementRequest req = new DestroyElementRequest((EObject)class2, false);
        IElementType type = ElementTypeRegistry.getInstance().getElementType(req.getEditHelperContext());
        DestroyElementCommandTest.assertNotNull((Object)type);
        ICommand cmd = type.getEditCommand((IEditCommandRequest)req);
        DestroyElementCommandTest.assertNotNull((Object)cmd);
        this.assertNoDuplicates(cmd);
        this.execute(cmd);
        this.assertDestroyed((EObject)class2);
        DestroyElementCommandTest.assertNull((Object)class2.eResource());
        this.undo(cmd);
        DestroyElementCommandTest.assertSame((Object)pkg1, (Object)class2.eContainer());
        DestroyElementCommandTest.assertSame((Object)res2, (Object)class2.eResource());
        DestroyElementCommandTest.assertTrue((boolean)class2.getESuperTypes().contains((Object)class1));
        this.redo(cmd);
        this.assertDestroyed((EObject)class2);
        DestroyElementCommandTest.assertNull((Object)class2.eResource());
    }

    public void test_preserveElementToDestroy_142561() {
        DestroyElementRequest req = new DestroyElementRequest((EObject)this.parentCompany, false);
        IElementType type = ElementTypeRegistry.getInstance().getElementType(req.getEditHelperContext());
        req.setParameter(DestroyCustomerAdvice.BEFORE, new ArrayList());
        req.setParameter(DestroyCustomerAdvice.AFTER, new ArrayList());
        DestroyElementCommandTest.assertNotNull((Object)type);
        ICommand cmd = type.getEditCommand((IEditCommandRequest)req);
        DestroyElementCommandTest.assertNotNull((Object)cmd);
        this.assertNoDuplicates(cmd);
        this.execute(cmd);
        this.assertDestroyed(this.parentCompany);
        List before = (List)req.getParameter(DestroyCustomerAdvice.BEFORE);
        List after = (List)req.getParameter(DestroyCustomerAdvice.AFTER);
        Collections.reverse(after);
        DestroyElementCommandTest.assertEquals((Object)before, (Object)after);
    }

    public void test_initialElementToBeDestroyed_146559() {
        DestroyElementRequest req = new DestroyElementRequest((EObject)this.parentCompany, false);
        IElementType type = ElementTypeRegistry.getInstance().getElementType(req.getEditHelperContext());
        DestroyElementCommandTest.assertNotNull((Object)type);
        ICommand cmd = type.getEditCommand((IEditCommandRequest)req);
        DestroyElementCommandTest.assertNotNull((Object)cmd);
        this.assertNoDuplicates(cmd);
        this.execute(cmd);
        this.assertDestroyed(this.parentCompany);
        DestroyDependentsRequest dependentsRequest = (DestroyDependentsRequest)req.getParameter("DestroyElementRequest.destroyDependentsRequest");
        Object initial = dependentsRequest.getParameter(ClientDependentsAdvice.INITIAL);
        DestroyElementCommandTest.assertEquals((Object)this.parentCompany, (Object)initial);
    }

    protected void doModelSetup(Resource resource) {
        this.parentCompany = this.getEmployeeFactory().createCustomer();
        this.parentCompany.setName("GlobalMega");
        resource.getContents().add((Object)this.parentCompany);
        this.customer = this.getEmployeeFactory().createCustomer();
        this.customer.setName("Acme");
        this.parentCompany.getSubsidiaries().add((Object)this.customer);
        this.billieJo = this.createClient("Billie Jo", "Swanson", this.customer);
        this.billieJoAnnotation = this.createAnnotation(this.billieJo);
        this.jimBob = this.createClient("Jim Bob", "Jones", this.customer);
        this.jimBobAnnotation = this.createAnnotation(this.jimBob);
    }

    protected Client createClient(String firstName, String lastName, Customer customer) {
        Client result = EmployeeFactory.eINSTANCE.createClient();
        result.setFirstName(firstName);
        result.setLastName(lastName);
        customer.getRepresentatives().add((Object)result);
        return result;
    }

    protected EAnnotation createAnnotation(Client client) {
        EAnnotation result = EcoreFactory.eINSTANCE.createEAnnotation();
        result.setSource(ANNOTATION_SOURCE);
        result.getReferences().add((Object)client);
        client.getRepresents().getEAnnotations().add((Object)result);
        return result;
    }

    protected void assertDestroyed(EObject eObject) {
        DestroyElementCommandTest.assertTrue((eObject.eContainer() == null || eObject.eContainer() instanceof ChangeDescription ? 1 : 0) != 0);
        Iterator iter = eObject.eClass().getEAllReferences().iterator();
        while (iter.hasNext()) {
            EReference next = (EReference)iter.next();
            DestroyElementCommandTest.assertFalse((boolean)eObject.eIsSet((EStructuralFeature)next));
        }
        DestroyElementCommandTest.assertFalse((boolean)this.getResource().getContents().contains((Object)eObject));
    }

    private void assertNoDuplicates(ICommand cmd) {
        this.assertNoDuplicatesImpl(cmd, new ArrayList());
    }

    private void assertNoDuplicatesImpl(ICommand cmd, List toDestroy) {
        if (cmd instanceof DestroyElementCommand) {
            try {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Method getElementToDestroy = clazz.getDeclaredMethod("getElementToDestroy", null);
                getElementToDestroy.setAccessible(true);
                EObject element = (EObject)getElementToDestroy.invoke((Object)((DestroyElementCommand)cmd), null);
                if (toDestroy.contains(element)) {
                    DestroyElementCommandTest.fail((String)("Duplicate destroy command for: " + element));
                }
                toDestroy.add(element);
            }
            catch (NoSuchMethodException nsme) {
                DestroyElementCommandTest.fail((String)("Unexpected exception: " + nsme));
            }
            catch (IllegalAccessException iae) {
                DestroyElementCommandTest.fail((String)("Unexpected exception: " + iae));
            }
            catch (InvocationTargetException ite) {
                DestroyElementCommandTest.fail((String)("Unexpected exception: " + ite));
            }
        } else if (cmd instanceof ICompositeCommand) {
            Iterator i = ((ICompositeCommand)cmd).iterator();
            while (i.hasNext()) {
                ICommand next = (ICommand)i.next();
                this.assertNoDuplicatesImpl(next, toDestroy);
            }
        }
    }
}

