/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.type.core.commands;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.tests.runtime.emf.type.core.AbstractEMFTypeTest;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Department;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Employee;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.EmployeePackage;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Office;

public class SetValueCommandTest
extends AbstractEMFTypeTest {
    private Department department;
    private Employee manager;
    private Office managerOffice;
    static /* synthetic */ Class class$0;

    public SetValueCommandTest(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.commands.SetValueCommandTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    protected void doModelSetup(Resource resource) {
        this.department = (Department)this.getEmployeeFactory().create(this.getEmployeePackage().getDepartment());
        this.department.setName("Department");
        resource.getContents().add((Object)this.department);
        this.manager = (Employee)this.getEmployeeFactory().create(this.getEmployeePackage().getEmployee());
        this.managerOffice = (Office)this.getEmployeeFactory().create(this.getEmployeePackage().getOffice());
    }

    public void test_isExecutable() {
        SetRequest request = new SetRequest(this.getEditingDomain(), (EObject)this.department, (EStructuralFeature)EmployeePackage.eINSTANCE.getDepartment_Manager(), (Object)this.manager);
        SetValueCommand command = new SetValueCommand(request);
        SetValueCommandTest.assertTrue((boolean)command.canExecute());
        request = new SetRequest(this.getEditingDomain(), (EObject)this.department, (EStructuralFeature)EmployeePackage.eINSTANCE.getDepartment_Manager(), null);
        command = new SetValueCommand(request);
        SetValueCommandTest.assertTrue((boolean)command.canExecute());
        request = new SetRequest(this.getEditingDomain(), (EObject)this.department, (EStructuralFeature)EmployeePackage.eINSTANCE.getDepartment_Manager(), (Object)this.managerOffice);
        command = new SetValueCommand(request);
        SetValueCommandTest.assertFalse((boolean)command.canExecute());
        request = new SetRequest(this.getEditingDomain(), (EObject)this.department, (EStructuralFeature)EmployeePackage.eINSTANCE.getEmployee_Office(), (Object)this.manager);
        command = new SetValueCommand(request);
        SetValueCommandTest.assertFalse((boolean)command.canExecute());
        request = new SetRequest(this.getEditingDomain(), (EObject)this.department, (EStructuralFeature)EmployeePackage.eINSTANCE.getDepartment_Members(), null);
        command = new SetValueCommand(request);
        SetValueCommandTest.assertFalse((boolean)command.canExecute());
        request = new SetRequest(this.getEditingDomain(), (EObject)this.manager, (EStructuralFeature)EmployeePackage.eINSTANCE.getDepartment_Manager(), null);
        command = new SetValueCommand(request);
        SetValueCommandTest.assertFalse((boolean)command.canExecute());
        EReference managerFeature = EmployeePackage.eINSTANCE.getDepartment_Manager();
        managerFeature.setChangeable(false);
        request = new SetRequest(this.getEditingDomain(), (EObject)this.department, (EStructuralFeature)managerFeature, (Object)this.manager);
        command = new SetValueCommand(request);
        SetValueCommandTest.assertFalse((boolean)command.canExecute());
    }
}

