/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.type.core.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.AbstractElementTypeFactory;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.SpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.GetEditContextCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelper;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelper;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Employee;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.EmployeePackage;
import org.eclipse.gmf.tests.runtime.emf.type.core.internal.EmployeeType;
import org.eclipse.gmf.tests.runtime.emf.type.core.internal.ISecurityCleared;

public class SecurityClearedElementTypeFactory
extends AbstractElementTypeFactory {
    private static final String SECURITY_CLEARANCE_PARAM_NAME = "securityClearance";

    public ISpecializationType createSpecializationType(ISpecializationTypeDescriptor descriptor) {
        return new SecurityClearedSpecializationType(descriptor, descriptor.getParamValue(SECURITY_CLEARANCE_PARAM_NAME));
    }

    public static final class CreateSecretEmployeeCommand
    extends CreateElementCommand {
        public CreateSecretEmployeeCommand(CreateElementRequest req) {
            super(req);
        }

        protected EObject doDefaultElementCreation() {
            Employee result = (Employee)super.doDefaultElementCreation();
            result.setSecurityClearance(true);
            return result;
        }
    }

    public static final class SecurityClearedEditHelper
    extends AbstractEditHelper {
        protected ICommand getEditContextCommand(GetEditContextRequest req) {
            CreateElementRequest createRequest;
            GetEditContextCommand result = null;
            if (req.getEditCommandRequest() instanceof CreateElementRequest && (createRequest = (CreateElementRequest)req.getEditCommandRequest()).getElementType() == EmployeeType.TOP_SECRET) {
                result = new GetEditContextCommand(req);
                result.setEditContext((Object)EmployeeType.SECRET_DEPARTMENT);
            }
            return result;
        }

        protected ICommand getCreateCommand(CreateElementRequest req) {
            if (req.getElementType() == EmployeeType.TOP_SECRET) {
                req.setContainmentFeature(EmployeePackage.eINSTANCE.getDepartment_Members());
                return new CreateSecretEmployeeCommand(req);
            }
            return super.getCreateCommand(req);
        }
    }

    private static final class SecurityClearedSpecializationType
    extends SpecializationType
    implements ISecurityCleared {
        private final String securityClearance;
        private final IEditHelper editHelper = new SecurityClearedEditHelper();

        public SecurityClearedSpecializationType(ISpecializationTypeDescriptor descriptor, String securityClearance) {
            super(descriptor);
            this.securityClearance = securityClearance;
        }

        public String getSecurityClearance() {
            return this.securityClearance;
        }

        public IEditHelper getEditHelper() {
            return this.editHelper;
        }
    }
}

