/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.logic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Circuit;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.LED;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Terminal;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.logic.CanonicalTestFixture;

public class LogicTransientViewsTests
extends AbstractTestBase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.diagram.ui.logic.LogicTransientViewsTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite s = new TestSuite((Class)clazz);
        return s;
    }

    public LogicTransientViewsTests() {
        super("Transient View Test Suite");
    }

    protected void setTestFixture() {
        this.testFixture = new CanonicalTestFixture();
    }

    protected CanonicalTestFixture getCanonicalTestFixture() {
        return (CanonicalTestFixture)this.getTestFixture();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testTransientWiresCreation_AcrossTransientLeds() {
        try {
            LogicTransientViewsTests.println("testTransientWiresCreation_AcrossTransientLeds() starting ...");
            CanonicalTestFixture _testFixture = this.getCanonicalTestFixture();
            IGraphicalEditPart logicCompartment = _testFixture.getCanonicalCompartment(0);
            LED led1 = _testFixture.createLED(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView()));
            LED led2 = _testFixture.createLED(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView()));
            Terminal term1 = (Terminal)led1.getOutputTerminals().get(0);
            Terminal term2 = (Terminal)led2.getInputTerminals().get(0);
            IElementType typeWire = ElementTypeRegistry.getInstance().getType("logic.wire");
            IElementType typeCircuit = ElementTypeRegistry.getInstance().getType("logic.circuit");
            CreateRelationshipRequest crr = new CreateRelationshipRequest(this.getTestFixture().getEditingDomain(), (EObject)term1, (EObject)term2, typeWire);
            ICommand createWire = typeCircuit.getEditHelper().getEditCommand((IEditCommandRequest)crr);
            _testFixture.execute(createWire);
            this.flushEventQueue();
            List connectorEPs = this.getDiagramEditPart().getConnections();
            LogicTransientViewsTests.assertEquals((String)"Unexpected Wire count.", (int)1, (int)connectorEPs.size());
            final ConnectionEditPart ep = (ConnectionEditPart)connectorEPs.get(0);
            this.assertTransient((View)ep.getSource().getModel());
            this.assertTransient((View)ep.getTarget().getModel());
            this.assertTransient((View)ep.getModel());
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)ep).getEditingDomain();
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, ""){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    ((View)ep.getModel()).setVisible(false);
                    return Status.OK_STATUS;
                }
            };
            try {
                OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                LogicTransientViewsTests.assertFalse((boolean)false);
            }
            this.assertPersisted((View)ep.getSource().getModel());
            this.assertPersisted((View)ep.getTarget().getModel());
            this.assertPersisted((View)ep.getModel());
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            LogicTransientViewsTests.println("testTransientWiresCreation_AcrossTransientLeds() complete.");
            throw throwable;
        }
        {
            Object var16_18 = null;
        }
        LogicTransientViewsTests.println("testTransientWiresCreation_AcrossTransientLeds() complete.");
    }

    private GraphicalEditPart _editPartForSemanticElement(GraphicalEditPart container, Object element) {
        List children = container.getChildren();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            GraphicalEditPart ep = (GraphicalEditPart)iter.next();
            if (ep.getNotationView().getElement() == element) {
                return ep;
            }
            if ((ep = this._editPartForSemanticElement(ep, element)) == null) continue;
            return ep;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testTransientWiresCreation_AcrossPersistedLeds() {
        try {
            LogicTransientViewsTests.println("testTransientWiresCreation_AcrossPersistedLeds() starting ...");
            CanonicalTestFixture _testFixture = this.getCanonicalTestFixture();
            IGraphicalEditPart logicCompartment = _testFixture.getCanonicalCompartment(0);
            LED led1 = _testFixture.createLED(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView()));
            LED led2 = _testFixture.createLED(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView()));
            GraphicalEditPart ledEditPart = (GraphicalEditPart)this.getDiagramEditPart().getChildren().get(0);
            Terminal term1 = (Terminal)led1.getOutputTerminals().get(0);
            Terminal term2 = (Terminal)led2.getInputTerminals().get(0);
            this.flushEventQueue();
            final GraphicalEditPart ep1 = this._editPartForSemanticElement(ledEditPart, term1);
            TransactionalEditingDomain editingDomain = ledEditPart.getEditingDomain();
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, ""){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    ((View)((View)ep1.getModel()).eContainer()).persistChildren();
                    return Status.OK_STATUS;
                }
            };
            try {
                this.getDiagramEditPart().getDiagramEditDomain().getActionManager().getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                LogicTransientViewsTests.assertFalse((boolean)false);
            }
            this.assertPersisted((View)ep1.getModel());
            IElementType typeWire = ElementTypeRegistry.getInstance().getType("logic.wire");
            IElementType typeCircuit = ElementTypeRegistry.getInstance().getType("logic.circuit");
            CreateRelationshipRequest crr = new CreateRelationshipRequest(editingDomain, (EObject)term1, (EObject)term2, typeWire);
            ICommand createWire = typeCircuit.getEditHelper().getEditCommand((IEditCommandRequest)crr);
            _testFixture.execute(createWire);
            this.flushEventQueue();
            List connectorEPs = this.getDiagramEditPart().getConnections();
            LogicTransientViewsTests.assertEquals((String)"Unexpected Wire count.", (int)1, (int)connectorEPs.size());
            ConnectionEditPart ep = (ConnectionEditPart)connectorEPs.get(0);
            this.assertTransient((View)ep.getModel());
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            LogicTransientViewsTests.println("testTransientWiresCreation_AcrossPersistedLeds() complete.");
            throw throwable;
        }
        {
            Object var17_20 = null;
        }
        LogicTransientViewsTests.println("testTransientWiresCreation_AcrossPersistedLeds() complete.");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testTransientLEDsCreation() {
        try {
            Iterator iter;
            LED led;
            LogicTransientViewsTests.println("testTransientLEDsCreation() starting ...");
            CanonicalTestFixture _testFixture = this.getCanonicalTestFixture();
            IGraphicalEditPart logicCompartment = _testFixture.getCanonicalCompartment(0);
            ArrayList<LED> properties = new ArrayList<LED>();
            int size = logicCompartment.getChildren().size();
            int count = 5;
            int i = 0;
            while (true) {
                if (i >= count) {
                    this.assertTransient(logicCompartment.getChildren());
                    Rectangle rect = new Rectangle(logicCompartment.getFigure().getBounds());
                    logicCompartment.getFigure().translateToAbsolute((Translatable)rect);
                    IElementType typeLED = ElementTypeRegistry.getInstance().getType("logic.led");
                    this.getCanonicalTestFixture().createShapeUsingTool(typeLED, rect.getCenter(), logicCompartment);
                    this.assertPersisted(logicCompartment.getChildren());
                    led = _testFixture.createLED(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView()));
                    List children = logicCompartment.getChildren();
                    iter = children.iterator();
                    break;
                }
                properties.add(_testFixture.createLED(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView())));
                LogicTransientViewsTests.assertEquals((String)"Unexpected LED count.", (int)(++size), (int)logicCompartment.getChildren().size());
                ++i;
            }
            while (iter.hasNext()) {
                GraphicalEditPart element = (GraphicalEditPart)iter.next();
                View view = element.getNotationView();
                if (view == null) continue;
                EObject _led = view.getElement();
                if (_led == led) {
                    this.assertTransient(view);
                    continue;
                }
                this.assertPersisted(view);
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            LogicTransientViewsTests.println("testTransientLEDsCreation() complete.");
            throw throwable;
        }
        {
            Object var14_17 = null;
        }
        LogicTransientViewsTests.println("testTransientLEDsCreation() complete.");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testTransientCircuitsCreation() {
        try {
            Iterator iter;
            Circuit circuit;
            LogicTransientViewsTests.println("testTransientCircuitsCreation() starting ...");
            CanonicalTestFixture _testFixture = this.getCanonicalTestFixture();
            IGraphicalEditPart logicCompartment = _testFixture.getCanonicalCompartment(0);
            ArrayList<Circuit> properties = new ArrayList<Circuit>();
            int size = logicCompartment.getChildren().size();
            int count = 5;
            int i = 0;
            while (true) {
                if (i >= count) {
                    this.assertTransient(logicCompartment.getChildren());
                    Rectangle rect = new Rectangle(logicCompartment.getFigure().getBounds());
                    logicCompartment.getFigure().translateToAbsolute((Translatable)rect);
                    IElementType typeCircuit = ElementTypeRegistry.getInstance().getType("logic.circuit");
                    this.getCanonicalTestFixture().createShapeUsingTool(typeCircuit, rect.getCenter(), logicCompartment);
                    this.assertPersisted(logicCompartment.getChildren());
                    circuit = _testFixture.createCircuit(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView()));
                    List children = logicCompartment.getChildren();
                    iter = children.iterator();
                    break;
                }
                properties.add(_testFixture.createCircuit(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView())));
                LogicTransientViewsTests.assertEquals((String)"Unexpected Circuit count.", (int)(++size), (int)logicCompartment.getChildren().size());
                ++i;
            }
            while (iter.hasNext()) {
                GraphicalEditPart element = (GraphicalEditPart)iter.next();
                View view = element.getNotationView();
                if (view == null) continue;
                EObject _circuit = view.getElement();
                if (_circuit == circuit) {
                    this.assertTransient(view);
                    continue;
                }
                this.assertPersisted(view);
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            LogicTransientViewsTests.println("testTransientCircuitsCreation() complete.");
            throw throwable;
        }
        {
            Object var14_17 = null;
        }
        LogicTransientViewsTests.println("testTransientCircuitsCreation() complete.");
    }

    private void assertPersisted(View view) {
        EStructuralFeature feature;
        if (view != null && (feature = view.eContainingFeature()) != null) {
            LogicTransientViewsTests.assertFalse((String)"Expected a Persisted View", (boolean)feature.isTransient());
        }
    }

    private void assertTransient(View view) {
        EStructuralFeature feature;
        if (view != null && (feature = view.eContainingFeature()) != null) {
            LogicTransientViewsTests.assertTrue((String)"Expected a Transient View", (boolean)feature.isTransient());
        }
    }

    private void assertPersisted(List children) {
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            EStructuralFeature feature;
            GraphicalEditPart element = (GraphicalEditPart)iter.next();
            View view = element.getNotationView();
            if (view == null || (feature = view.eContainingFeature()) == null) continue;
            LogicTransientViewsTests.assertFalse((String)"Expected a Persisted View", (boolean)feature.isTransient());
        }
    }

    private void assertTransient(List children) {
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            EStructuralFeature feature;
            GraphicalEditPart element = (GraphicalEditPart)iter.next();
            View view = element.getNotationView();
            if (view == null || (feature = view.eContainingFeature()) == null) continue;
            LogicTransientViewsTests.assertTrue((String)"Expected a Transient View", (boolean)feature.isTransient());
        }
    }
}

