/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.lite.gef;

import java.util.Arrays;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.rt.RuntimeDiagramTestBase;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class DiagramElementTest
extends RuntimeDiagramTestBase {
    private static final Rectangle NODE_1_BOUNDS = new Rectangle(10, 10, 100, 100);
    private static final Rectangle NODE_2_BOUNDS = new Rectangle(200, 200, 150, 150);
    private static final Rectangle NODE_3_BOUNDS = new Rectangle(400, 570, 70, 70);
    static /* synthetic */ Class class$0;

    public DiagramElementTest(String name) {
        super(name);
    }

    public void testAlignNodes() {
        Node createdNode1 = this.createNode((GenCommonBase)this.getGenModel().getNodeA(), (View)this.getCanvasInstance().getCanvas());
        DiagramElementTest.assertNotNull((String)"Node not created", (Object)createdNode1);
        this.moveNode(createdNode1, NODE_1_BOUNDS);
        EditPart ep1 = this.findEditPart((View)createdNode1);
        Node createdNode2 = this.createNode((GenCommonBase)this.getGenModel().getNodeA(), (View)this.getCanvasInstance().getCanvas());
        DiagramElementTest.assertNotNull((String)"Node not created", (Object)createdNode2);
        this.moveNode(createdNode2, NODE_2_BOUNDS);
        EditPart ep2 = this.findEditPart((View)createdNode2);
        Node createdNode3 = this.createNode((GenCommonBase)this.getGenModel().getNodeA(), (View)this.getCanvasInstance().getCanvas());
        DiagramElementTest.assertNotNull((String)"Node not created", (Object)createdNode3);
        this.moveNode(createdNode3, NODE_3_BOUNDS);
        EditPart ep3 = this.findEditPart((View)createdNode3);
        this.align(Arrays.asList(ep2, ep3, ep1), 1);
        this.checkBounds(createdNode1, NODE_1_BOUNDS);
        this.checkBounds(createdNode2, new Rectangle(10, 200, 150, 150));
        this.checkBounds(createdNode3, new Rectangle(10, 570, 70, 70));
        this.getCommandStack().undo();
        this.align(Arrays.asList(ep1, ep3, ep2), 4);
        this.checkBounds(createdNode1, new Rectangle(250, 10, 100, 100));
        this.checkBounds(createdNode2, NODE_2_BOUNDS);
        this.checkBounds(createdNode3, new Rectangle(280, 570, 70, 70));
        this.getCommandStack().undo();
        this.align(Arrays.asList(ep1, ep2, ep3), 32);
        this.checkBounds(createdNode1, new Rectangle(10, 540, 100, 100));
        this.checkBounds(createdNode2, new Rectangle(200, 490, 150, 150));
        this.checkBounds(createdNode3, NODE_3_BOUNDS);
        this.getCommandStack().undo();
    }

    private void layout(IFigure parentFigure) {
        parentFigure.getLayoutManager().layout(parentFigure);
    }

    private void moveNode(Node node, Rectangle bounds) {
        DiagramElementTest.assertTrue((String)"Unexpected layout constraint", (boolean)(node.getLayoutConstraint() instanceof Bounds));
        Bounds nodeBounds = (Bounds)node.getLayoutConstraint();
        Rectangle original = new Rectangle(nodeBounds.getX(), nodeBounds.getY(), nodeBounds.getWidth(), nodeBounds.getHeight());
        GraphicalEditPart editPart = (GraphicalEditPart)this.findEditPart((View)node);
        DiagramElementTest.assertNotNull((String)"Missing editpart for the node", (Object)editPart);
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize");
        req.setMoveDelta(bounds.getTopLeft().translate(original.getTopLeft().negate()));
        req.setSizeDelta(bounds.getSize().getDifference(original.getSize()));
        req.setEditParts((EditPart)editPart);
        req.setResizeDirection(9);
        Command cmd = editPart.getCommand((Request)req);
        DiagramElementTest.assertNotNull((String)"No resize command", (Object)cmd);
        DiagramElementTest.assertTrue((String)"Can't execute resize command", (boolean)cmd.canExecute());
        this.getCommandStack().execute(cmd);
        this.checkBounds(node, bounds);
    }

    private void align(List nodes, int alignment) {
        this.layout(((GraphicalEditPart)nodes.get(0)).getFigure().getParent());
        AlignmentAction action = new AlignmentAction((IWorkbenchPart)new ViewPart(){

            public Object getAdapter(Class adapter) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.gef.commands.CommandStack");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == adapter) {
                    return DiagramElementTest.this.getCommandStack();
                }
                return super.getAdapter(adapter);
            }

            public void createPartControl(Composite parent) {
            }

            public void setFocus() {
            }
        }, alignment);
        StructuredSelection selection = new StructuredSelection(nodes);
        action.setSelectionProvider(new ISelectionProvider((IStructuredSelection)selection){
            private final /* synthetic */ IStructuredSelection val$selection;
            {
                this.val$selection = iStructuredSelection;
            }

            public void setSelection(ISelection selection) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return this.val$selection;
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }
        });
        action.update();
        action.run();
    }

    private void checkBounds(Node node, Rectangle bounds) {
        DiagramElementTest.assertTrue((String)"Unexpected layout constraint", (boolean)(node.getLayoutConstraint() instanceof Bounds));
        Bounds nodeBounds = (Bounds)node.getLayoutConstraint();
        this.checkBounds(nodeBounds, bounds);
    }

    private void checkBounds(Bounds nodeBounds, Rectangle bounds) {
        DiagramElementTest.assertEquals((int)nodeBounds.getX(), (int)bounds.x);
        DiagramElementTest.assertEquals((int)nodeBounds.getY(), (int)bounds.y);
        DiagramElementTest.assertEquals((int)nodeBounds.getWidth(), (int)bounds.width);
        DiagramElementTest.assertEquals((int)nodeBounds.getHeight(), (int)bounds.height);
    }
}

