/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.lite.gef;

import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.rt.RuntimeDiagramTestBase;

public class DiagramLinksTest
extends RuntimeDiagramTestBase {
    public DiagramLinksTest(String name) {
        super(name);
    }

    public void testBendpoints() throws Exception {
        Node createdNode1 = this.createNode((GenCommonBase)this.getGenModel().getNodeA(), (View)this.getCanvasInstance().getCanvas());
        DiagramLinksTest.assertNotNull((String)"Node not created", (Object)createdNode1);
        Node createdNode2 = this.createNode((GenCommonBase)this.getGenModel().getNodeB(), (View)this.getCanvasInstance().getCanvas());
        DiagramLinksTest.assertNotNull((String)"Node not created", (Object)createdNode2);
        Edge link = this.createLink(this.getGenModel().getLinkC(), (View)createdNode1, (View)createdNode2);
        DiagramLinksTest.assertNotNull((String)"Link not created", (Object)link);
        ConnectionEditPart linkEp = (ConnectionEditPart)this.findEditPart((View)link);
        DiagramLinksTest.assertNotNull((String)"Could not find editpart that represents link", (Object)linkEp);
        this.modifyBendpoints("create bendpoint", 0, new Point(500, 500), linkEp);
        this.checkBendpointsSize(link, 1);
        this.modifyBendpoints("move bendpoint", 0, new Point(400, 400), linkEp);
        this.checkBendpointsSize(link, 1);
        this.modifyBendpoints("create bendpoint", 1, new Point(700, 700), linkEp);
        this.checkBendpointsSize(link, 2);
        this.modifyBendpoints("move bendpoint", 1, new Point(401, 400), linkEp);
        this.checkBendpointsSize(link, 1);
    }

    private void modifyBendpoints(String requestType, int index, Point point, ConnectionEditPart linkEp) {
        ((PolylineConnection)linkEp.getFigure()).layout();
        BendpointRequest bendpointRequest = new BendpointRequest();
        bendpointRequest.setType((Object)requestType);
        bendpointRequest.setIndex(index);
        bendpointRequest.setLocation(point);
        bendpointRequest.setSource(linkEp);
        linkEp.showSourceFeedback((Request)bendpointRequest);
        Command command = linkEp.getCommand((Request)bendpointRequest);
        DiagramLinksTest.assertNotNull((String)"No command", (Object)command);
        DiagramLinksTest.assertTrue((String)"Unexecutable command", (boolean)command.canExecute());
        linkEp.eraseSourceFeedback((Request)bendpointRequest);
        command.execute();
    }

    private void checkBendpointsSize(Edge link, int expectedSize) {
        Bendpoints bendpoints = link.getBendpoints();
        DiagramLinksTest.assertNotNull((Object)bendpoints);
        DiagramLinksTest.assertTrue((boolean)(bendpoints instanceof RelativeBendpoints));
        RelativeBendpoints relativeBendpoints = (RelativeBendpoints)bendpoints;
        DiagramLinksTest.assertEquals((int)expectedSize, (int)relativeBendpoints.getPoints().size());
    }
}

