/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.properties.sections;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.l10n.DiagramUIPropertiesMessages;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AbstractBasicTextPropertySection;
import org.eclipse.gmf.runtime.notation.DescriptionStyle;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DiagramGeneralSection
extends AbstractBasicTextPropertySection {
    protected static final String NAME_LABEL = DiagramUIPropertiesMessages.DiagramGeneralDetails_nameLabel_text;
    protected static final String DIAGRAM_TYPE_LABEL = DiagramUIPropertiesMessages.DiagramGeneralDetails_diagramTypeLabel_text;
    protected static final String DESCRIPTION_LABEL = DiagramUIPropertiesMessages.DiagramGeneralDetails_diagramDescriptionLabel_text;
    public static final String[] GENERAL_DIAGRAM_LABELS = new String[]{NAME_LABEL, DIAGRAM_TYPE_LABEL, DESCRIPTION_LABEL};
    protected static final String NAME = DiagramUIPropertiesMessages.DiagramGeneralDetails_nameChangeCommand_text;
    protected static final String DESCRIPTION = DiagramUIPropertiesMessages.DiagramGeneralDetails_diagramDescriptionChangeCommand_text;
    private static final String NAME_PROPERTY_CHANGE_COMMAND_NAME = String.valueOf(NAME) + VALUE_CHANGED_STRING;
    private static final String DESCRIPTION_PROPERTY_CHANGE_COMMAND_NAME = String.valueOf(DESCRIPTION) + VALUE_CHANGED_STRING;
    private CLabel typeText;
    private Text descriptionText;
    private String descriptionCache;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected synchronized void setDescription() {
        final String newDescription = this.descriptionText.getText();
        if (!newDescription.equals(this.descriptionCache)) {
            ArrayList<ICommand> commands = new ArrayList<ICommand>();
            Iterator i = this.getEObjectList().iterator();
            while (i.hasNext()) {
                final EObject next = (EObject)i.next();
                commands.add(this.createCommand(DESCRIPTION_PROPERTY_CHANGE_COMMAND_NAME, next, new Runnable(){

                    public void run() {
                        DescriptionStyle description = (DescriptionStyle)((Diagram)next).getStyle(NotationPackage.eINSTANCE.getDescriptionStyle());
                        if (description != null) {
                            description.setDescription(newDescription);
                        }
                    }
                }));
            }
            this.executeAsCompositeCommand(DESCRIPTION_PROPERTY_CHANGE_COMMAND_NAME, commands);
            this.descriptionCache = newDescription;
        }
    }

    public void dispose() {
        this.getListener().stopListeningTo((Control)this.descriptionText);
        super.dispose();
    }

    protected void refreshUI() {
        super.refreshUI();
        Diagram diagram = (Diagram)this.getEObject();
        this.typeText.setText(this.getDiagramType(diagram));
        DescriptionStyle description = (DescriptionStyle)diagram.getStyle(NotationPackage.eINSTANCE.getDescriptionStyle());
        if (description != null) {
            this.descriptionText.setText(description.getDescription());
        }
    }

    protected String getDiagramType(Diagram diagram) {
        return diagram.getType();
    }

    protected EObject unwrap(Object object) {
        EObject o = super.unwrap(object);
        if (o instanceof Diagram) {
            return o;
        }
        return null;
    }

    protected EObject adapt(Object object) {
        if (object instanceof IAdaptable) {
            if (object instanceof IGraphicalEditPart) {
                IAdaptable iAdaptable = (IAdaptable)object;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.notation.View");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return (EObject)iAdaptable.getAdapter((Class)clazz);
            }
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.emf.ecore.EObject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (EObject)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    protected boolean isCurrentSelection(Notification notification, EObject element) {
        if (this.getEObjectList().size() > 0) {
            EObject eventObject = element;
            if (element instanceof EAnnotation || element instanceof Diagram) {
                eventObject = element.eContainer();
            }
            if (eventObject == null) {
                Object tmpObj = notification.getOldValue();
                if (tmpObj != null && tmpObj instanceof EObject) {
                    eventObject = (EObject)tmpObj;
                } else {
                    return false;
                }
            }
            return this.getEObjectList().contains(eventObject);
        }
        return false;
    }

    protected String getPropertyNameLabel() {
        return NAME_LABEL;
    }

    protected void setPropertyValue(Control control) {
        if (control == this.getTextWidget()) {
            super.setPropertyValue(control);
        } else {
            this.setDescription();
        }
    }

    protected void setPropertyValue(EObject object, Object value) {
        ((Diagram)object).setName((String)value);
    }

    protected String getPropertyValueString() {
        return ((Diagram)this.getEObject()).getName();
    }

    protected String getPropertyChangeCommandName() {
        return NAME_PROPERTY_CHANGE_COMMAND_NAME;
    }

    protected String[] getPropertyNameStringsArray() {
        return GENERAL_DIAGRAM_LABELS;
    }

    public void doCreateControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.doCreateControls(parent, aTabbedPropertySheetPage);
        this.typeText = this.getWidgetFactory().createCLabel(this.getSectionComposite(), "");
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.getTextWidget(), 0, 16384);
        data.right = new FormAttachment((Control)this.getTextWidget(), 0, 131072);
        data.top = new FormAttachment((Control)this.getTextWidget(), 4, 1024);
        this.typeText.setLayoutData((Object)data);
        CLabel typeLabel = this.getWidgetFactory().createCLabel(this.getSectionComposite(), DIAGRAM_TYPE_LABEL);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.typeText, -5);
        data.top = new FormAttachment((Control)this.typeText, 0, 0x1000000);
        typeLabel.setLayoutData((Object)data);
        this.descriptionText = this.getWidgetFactory().createText(this.getSectionComposite(), "", 834);
        data = new FormData();
        data.left = new FormAttachment((Control)this.typeText, 0, 16384);
        data.right = new FormAttachment((Control)this.typeText, 0, 131072);
        data.top = new FormAttachment((Control)this.typeText, 4, 1024);
        data.bottom = new FormAttachment(100, 0);
        data.height = 100;
        data.width = 100;
        this.descriptionText.setLayoutData((Object)data);
        CLabel descriptionLabel = this.getWidgetFactory().createCLabel(this.getSectionComposite(), DESCRIPTION_LABEL);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.descriptionText, -5);
        data.top = new FormAttachment((Control)this.typeText, 0, 16384);
        descriptionLabel.setLayoutData((Object)data);
        this.getListener().startListeningTo((Control)this.descriptionText);
        this.getListener().startListeningForEnter((Control)this.descriptionText);
        if (this.isReadOnly()) {
            this.descriptionText.setEditable(false);
        }
    }
}

