/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.core.internal.command;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.operations.IOperationApprover2;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.command.FileModificationValidator;
import org.eclipse.gmf.runtime.common.core.command.ICommand;

public class FileModificationApprover
implements IOperationApprover2 {
    public IStatus proceedExecuting(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
        if (operation instanceof ICommand) {
            return this.approveFileModification((ICommand)operation);
        }
        return Status.OK_STATUS;
    }

    public IStatus proceedRedoing(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
        if (operation instanceof ICommand) {
            return this.approveFileModification((ICommand)operation);
        }
        return Status.OK_STATUS;
    }

    public IStatus proceedUndoing(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
        if (operation instanceof ICommand) {
            return this.approveFileModification((ICommand)operation);
        }
        return Status.OK_STATUS;
    }

    private IStatus approveFileModification(ICommand fileModifier) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        Iterator i = fileModifier.getAffectedFiles().iterator();
        while (i.hasNext()) {
            IFile nextFile = (IFile)i.next();
            if (nextFile == null) continue;
            if (nextFile.exists()) {
                files.add(nextFile);
                continue;
            }
            IPath path = nextFile.getRawLocation();
            if (path == null) {
                return Status.CANCEL_STATUS;
            }
            File file = path.toFile();
            if (file == null || !file.exists() || file.canWrite()) continue;
            return Status.CANCEL_STATUS;
        }
        return FileModificationValidator.approveFileModification(files.toArray(new IFile[0]));
    }
}

