/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.commands;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;

public class SetValueCommand
extends EditElementCommand {
    private final EStructuralFeature feature;
    private final Object value;

    public SetValueCommand(SetRequest request) {
        super(request.getLabel(), request.getElementToEdit(), request);
        this.feature = request.getFeature();
        this.value = request.getValue();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (FeatureMapUtil.isMany((EObject)this.getElementToEdit(), (EStructuralFeature)this.feature)) {
            ((Collection)this.getElementToEdit().eGet(this.feature)).add(this.value);
        } else {
            this.getElementToEdit().eSet(this.feature, this.value);
        }
        return CommandResult.newOKCommandResult();
    }

    public boolean canExecute() {
        if (this.getElementToEdit() == null || !super.canExecute()) {
            return false;
        }
        if (this.value == null && FeatureMapUtil.isMany((EObject)this.getElementToEdit(), (EStructuralFeature)this.feature)) {
            return false;
        }
        EList allFeatures = this.getElementToEdit().eClass().getEAllStructuralFeatures();
        return allFeatures.contains(this.feature) && this.feature.isChangeable() && (this.value == null || this.feature.getEType().isInstance(this.value));
    }
}

