/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.image;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.Draw2dRenderPlugin;

public class ImageExporter {
    public static final String JPEG_FILE = "JPEG";
    public static final String PNG_FILE = "PNG";

    public static void exportToFile(IPath destination, BufferedImage image, String imageFormat, IProgressMonitor monitor) throws CoreException {
        ImageExporter.createFile(destination);
        monitor.worked(1);
        try {
            FileOutputStream os = new FileOutputStream(destination.toOSString());
            monitor.worked(1);
            JPEGTranscoder imageTranscoder = null;
            BufferedImage newImg = image;
            if (imageFormat == JPEG_FILE) {
                imageTranscoder = new JPEGTranscoder();
                if (image.getType() != 1) {
                    newImg = new BufferedImage(image.getWidth(), image.getHeight(), 1);
                    Graphics g = newImg.getGraphics();
                    g.drawImage(image, 0, 0, null);
                    g.dispose();
                }
                imageTranscoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.65));
            } else if (imageFormat == PNG_FILE) {
                imageTranscoder = new PNGTranscoder();
            } else {
                throw new IllegalArgumentException();
            }
            TranscoderOutput to = new TranscoderOutput((OutputStream)os);
            try {
                imageTranscoder.writeImage(newImg, to);
            }
            catch (TranscoderException e) {
                Log.error((Plugin)Draw2dRenderPlugin.getInstance(), (int)4, (String)e.getMessage(), (Throwable)e);
                Status status = new Status(4, "exportToFile", 0, e.getMessage(), null);
                throw new CoreException((IStatus)status);
            }
            monitor.worked(1);
            os.close();
            monitor.worked(1);
            ImageExporter.refreshLocal(destination);
        }
        catch (IOException ex) {
            Log.error((Plugin)Draw2dRenderPlugin.getInstance(), (int)4, (String)ex.getMessage(), (Throwable)ex);
            Status status = new Status(4, "exportToFile", 0, ex.getMessage(), null);
            throw new CoreException((IStatus)status);
        }
    }

    private static void createFile(IPath destination) throws CoreException {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(destination);
        if (file != null && !file.exists()) {
            File osFile = new File(destination.toOSString());
            if (osFile.exists()) {
                file.refreshLocal(0, null);
            } else {
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
                ByteArrayInputStream input = new ByteArrayInputStream(new byte[0]);
                file.create((InputStream)input, false, null);
            }
        }
    }

    private static void refreshLocal(IPath destination) throws CoreException {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(destination);
        if (file != null) {
            file.refreshLocal(0, null);
        }
    }
}

