/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.commands;

import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;

public class CommandUtilities {
    public static boolean canRedo(Command command) {
        if (command == null) {
            return false;
        }
        if (command instanceof IUndoableOperation) {
            return ((IUndoableOperation)command).canRedo();
        }
        if (command instanceof CompoundCommand) {
            Iterator iter = ((CompoundCommand)command).getCommands().iterator();
            while (iter.hasNext()) {
                try {
                    if (CommandUtilities.canRedo((Command)iter.next())) continue;
                    return false;
                }
                catch (ClassCastException classCastException) {
                    return false;
                }
            }
            return true;
        }
        if (command instanceof ICommandProxy) {
            return ((ICommandProxy)command).getICommand().canRedo();
        }
        return command.canUndo();
    }
}

