/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.core.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;

public abstract class AbstractCommand
extends AbstractOperation
implements ICommand {
    private final List affectedFiles;
    private CommandResult commandResult;

    public AbstractCommand(String label) {
        this(label, null);
    }

    public AbstractCommand(String label, List affectedFiles) {
        super(label);
        this.affectedFiles = affectedFiles == null ? new ArrayList(2) : affectedFiles;
    }

    public List getAffectedFiles() {
        return this.affectedFiles;
    }

    public CommandResult getCommandResult() {
        return this.commandResult;
    }

    protected final void setResult(CommandResult result) {
        this.commandResult = result;
    }

    public ICommand compose(IUndoableOperation operation) {
        if (operation != null) {
            return new CompositeCommand(this.getLabel()).compose(this).compose(operation);
        }
        return this;
    }

    public ICommand reduce() {
        return this;
    }

    public IStatus execute(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        CommandResult result = this.doExecuteWithResult(monitor, info);
        this.setResult(result);
        return result != null ? result.getStatus() : Status.OK_STATUS;
    }

    protected abstract CommandResult doExecuteWithResult(IProgressMonitor var1, IAdaptable var2) throws ExecutionException;

    public IStatus redo(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        CommandResult result = this.doRedoWithResult(monitor, info);
        this.setResult(result);
        return result != null ? result.getStatus() : Status.OK_STATUS;
    }

    protected abstract CommandResult doRedoWithResult(IProgressMonitor var1, IAdaptable var2) throws ExecutionException;

    public IStatus undo(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        CommandResult result = this.doUndoWithResult(monitor, info);
        this.setResult(result);
        return result != null ? result.getStatus() : Status.OK_STATUS;
    }

    protected abstract CommandResult doUndoWithResult(IProgressMonitor var1, IAdaptable var2) throws ExecutionException;

    public void dispose() {
        super.dispose();
        IUndoContext[] contexts = this.getContexts();
        int i = 0;
        while (i < contexts.length) {
            this.removeContext(contexts[i]);
            ++i;
        }
    }
}

