/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.gmf.codegen.gmfgen.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.gmf.codegen.gmfgen.util.GMFGenAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class GMFGenItemProviderAdapterFactory extends GMFGenAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection supportedTypes = new ArrayList();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GMFGenItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);		
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenEditorGeneratorItemProvider genEditorGeneratorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenEditorGeneratorAdapter() {
		if (genEditorGeneratorItemProvider == null) {
			genEditorGeneratorItemProvider = new GenEditorGeneratorItemProvider(this);
		}

		return genEditorGeneratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenDiagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenDiagramItemProvider genDiagramItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenDiagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenDiagramAdapter() {
		if (genDiagramItemProvider == null) {
			genDiagramItemProvider = new GenDiagramItemProvider(this);
		}

		return genDiagramItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenEditorView} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenEditorViewItemProvider genEditorViewItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenEditorView}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenEditorViewAdapter() {
		if (genEditorViewItemProvider == null) {
			genEditorViewItemProvider = new GenEditorViewItemProvider(this);
		}

		return genEditorViewItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenPlugin} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenPluginItemProvider genPluginItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenPlugin}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenPluginAdapter() {
		if (genPluginItemProvider == null) {
			genPluginItemProvider = new GenPluginItemProvider(this);
		}

		return genPluginItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenTopLevelNodeItemProvider genTopLevelNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenTopLevelNodeAdapter() {
		if (genTopLevelNodeItemProvider == null) {
			genTopLevelNodeItemProvider = new GenTopLevelNodeItemProvider(this);
		}

		return genTopLevelNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenChildNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenChildNodeItemProvider genChildNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenChildNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenChildNodeAdapter() {
		if (genChildNodeItemProvider == null) {
			genChildNodeItemProvider = new GenChildNodeItemProvider(this);
		}

		return genChildNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenChildLabelNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenChildLabelNodeItemProvider genChildLabelNodeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenChildLabelNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenChildLabelNodeAdapter() {
		if (genChildLabelNodeItemProvider == null) {
			genChildLabelNodeItemProvider = new GenChildLabelNodeItemProvider(this);
		}

		return genChildLabelNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenCompartment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenCompartmentItemProvider genCompartmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenCompartment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenCompartmentAdapter() {
		if (genCompartmentItemProvider == null) {
			genCompartmentItemProvider = new GenCompartmentItemProvider(this);
		}

		return genCompartmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenLink} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenLinkItemProvider genLinkItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenLink}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenLinkAdapter() {
		if (genLinkItemProvider == null) {
			genLinkItemProvider = new GenLinkItemProvider(this);
		}

		return genLinkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenNodeLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenNodeLabelItemProvider genNodeLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenNodeLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenNodeLabelAdapter() {
		if (genNodeLabelItemProvider == null) {
			genNodeLabelItemProvider = new GenNodeLabelItemProvider(this);
		}

		return genNodeLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenExternalNodeLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenExternalNodeLabelItemProvider genExternalNodeLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenExternalNodeLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenExternalNodeLabelAdapter() {
		if (genExternalNodeLabelItemProvider == null) {
			genExternalNodeLabelItemProvider = new GenExternalNodeLabelItemProvider(this);
		}

		return genExternalNodeLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenLinkLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenLinkLabelItemProvider genLinkLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenLinkLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenLinkLabelAdapter() {
		if (genLinkLabelItemProvider == null) {
			genLinkLabelItemProvider = new GenLinkLabelItemProvider(this);
		}

		return genLinkLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.MetamodelType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MetamodelTypeItemProvider metamodelTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.MetamodelType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createMetamodelTypeAdapter() {
		if (metamodelTypeItemProvider == null) {
			metamodelTypeItemProvider = new MetamodelTypeItemProvider(this);
		}

		return metamodelTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.SpecializationType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SpecializationTypeItemProvider specializationTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.SpecializationType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createSpecializationTypeAdapter() {
		if (specializationTypeItemProvider == null) {
			specializationTypeItemProvider = new SpecializationTypeItemProvider(this);
		}

		return specializationTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.NotationType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NotationTypeItemProvider notationTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.NotationType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createNotationTypeAdapter() {
		if (notationTypeItemProvider == null) {
			notationTypeItemProvider = new NotationTypeItemProvider(this);
		}

		return notationTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.TypeModelFacet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeModelFacetItemProvider typeModelFacetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.TypeModelFacet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createTypeModelFacetAdapter() {
		if (typeModelFacetItemProvider == null) {
			typeModelFacetItemProvider = new TypeModelFacetItemProvider(this);
		}

		return typeModelFacetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.FeatureModelFacet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FeatureModelFacetItemProvider featureModelFacetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.FeatureModelFacet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createFeatureModelFacetAdapter() {
		if (featureModelFacetItemProvider == null) {
			featureModelFacetItemProvider = new FeatureModelFacetItemProvider(this);
		}

		return featureModelFacetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.CompositeFeatureModelFacet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CompositeFeatureModelFacetItemProvider compositeFeatureModelFacetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.CompositeFeatureModelFacet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createCompositeFeatureModelFacetAdapter() {
		if (compositeFeatureModelFacetItemProvider == null) {
			compositeFeatureModelFacetItemProvider = new CompositeFeatureModelFacetItemProvider(this);
		}

		return compositeFeatureModelFacetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.TypeLinkModelFacet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeLinkModelFacetItemProvider typeLinkModelFacetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.TypeLinkModelFacet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createTypeLinkModelFacetAdapter() {
		if (typeLinkModelFacetItemProvider == null) {
			typeLinkModelFacetItemProvider = new TypeLinkModelFacetItemProvider(this);
		}

		return typeLinkModelFacetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.FeatureLinkModelFacet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FeatureLinkModelFacetItemProvider featureLinkModelFacetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.FeatureLinkModelFacet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createFeatureLinkModelFacetAdapter() {
		if (featureLinkModelFacetItemProvider == null) {
			featureLinkModelFacetItemProvider = new FeatureLinkModelFacetItemProvider(this);
		}

		return featureLinkModelFacetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.FeatureLabelModelFacet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FeatureLabelModelFacetItemProvider featureLabelModelFacetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.FeatureLabelModelFacet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createFeatureLabelModelFacetAdapter() {
		if (featureLabelModelFacetItemProvider == null) {
			featureLabelModelFacetItemProvider = new FeatureLabelModelFacetItemProvider(this);
		}

		return featureLabelModelFacetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.CompositeFeatureLabelModelFacet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CompositeFeatureLabelModelFacetItemProvider compositeFeatureLabelModelFacetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.CompositeFeatureLabelModelFacet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createCompositeFeatureLabelModelFacetAdapter() {
		if (compositeFeatureLabelModelFacetItemProvider == null) {
			compositeFeatureLabelModelFacetItemProvider = new CompositeFeatureLabelModelFacetItemProvider(this);
		}

		return compositeFeatureLabelModelFacetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.DesignLabelModelFacet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DesignLabelModelFacetItemProvider designLabelModelFacetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.DesignLabelModelFacet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDesignLabelModelFacetAdapter() {
		if (designLabelModelFacetItemProvider == null) {
			designLabelModelFacetItemProvider = new DesignLabelModelFacetItemProvider(this);
		}

		return designLabelModelFacetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.ColorAttributes} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ColorAttributesItemProvider colorAttributesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.ColorAttributes}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createColorAttributesAdapter() {
		if (colorAttributesItemProvider == null) {
			colorAttributesItemProvider = new ColorAttributesItemProvider(this);
		}

		return colorAttributesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.StyleAttributes} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StyleAttributesItemProvider styleAttributesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.StyleAttributes}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createStyleAttributesAdapter() {
		if (styleAttributesItemProvider == null) {
			styleAttributesItemProvider = new StyleAttributesItemProvider(this);
		}

		return styleAttributesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.ResizeConstraints} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResizeConstraintsItemProvider resizeConstraintsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.ResizeConstraints}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createResizeConstraintsAdapter() {
		if (resizeConstraintsItemProvider == null) {
			resizeConstraintsItemProvider = new ResizeConstraintsItemProvider(this);
		}

		return resizeConstraintsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.DefaultSizeAttributes} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DefaultSizeAttributesItemProvider defaultSizeAttributesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.DefaultSizeAttributes}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDefaultSizeAttributesAdapter() {
		if (defaultSizeAttributesItemProvider == null) {
			defaultSizeAttributesItemProvider = new DefaultSizeAttributesItemProvider(this);
		}

		return defaultSizeAttributesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.LabelOffsetAttributes} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabelOffsetAttributesItemProvider labelOffsetAttributesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.LabelOffsetAttributes}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createLabelOffsetAttributesAdapter() {
		if (labelOffsetAttributesItemProvider == null) {
			labelOffsetAttributesItemProvider = new LabelOffsetAttributesItemProvider(this);
		}

		return labelOffsetAttributesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.FigureViewmap} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FigureViewmapItemProvider figureViewmapItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.FigureViewmap}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createFigureViewmapAdapter() {
		if (figureViewmapItemProvider == null) {
			figureViewmapItemProvider = new FigureViewmapItemProvider(this);
		}

		return figureViewmapItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.SnippetViewmap} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SnippetViewmapItemProvider snippetViewmapItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.SnippetViewmap}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createSnippetViewmapAdapter() {
		if (snippetViewmapItemProvider == null) {
			snippetViewmapItemProvider = new SnippetViewmapItemProvider(this);
		}

		return snippetViewmapItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.InnerClassViewmap} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InnerClassViewmapItemProvider innerClassViewmapItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.InnerClassViewmap}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createInnerClassViewmapAdapter() {
		if (innerClassViewmapItemProvider == null) {
			innerClassViewmapItemProvider = new InnerClassViewmapItemProvider(this);
		}

		return innerClassViewmapItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.ParentAssignedViewmap} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParentAssignedViewmapItemProvider parentAssignedViewmapItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.ParentAssignedViewmap}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createParentAssignedViewmapAdapter() {
		if (parentAssignedViewmapItemProvider == null) {
			parentAssignedViewmapItemProvider = new ParentAssignedViewmapItemProvider(this);
		}

		return parentAssignedViewmapItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.Palette} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PaletteItemProvider paletteItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.Palette}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createPaletteAdapter() {
		if (paletteItemProvider == null) {
			paletteItemProvider = new PaletteItemProvider(this);
		}

		return paletteItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.ToolEntry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ToolEntryItemProvider toolEntryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.ToolEntry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createToolEntryAdapter() {
		if (toolEntryItemProvider == null) {
			toolEntryItemProvider = new ToolEntryItemProvider(this);
		}

		return toolEntryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.Separator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SeparatorItemProvider separatorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.Separator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createSeparatorAdapter() {
		if (separatorItemProvider == null) {
			separatorItemProvider = new SeparatorItemProvider(this);
		}

		return separatorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.ToolGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ToolGroupItemProvider toolGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.ToolGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createToolGroupAdapter() {
		if (toolGroupItemProvider == null) {
			toolGroupItemProvider = new ToolGroupItemProvider(this);
		}

		return toolGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenFeatureSeqInitializer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenFeatureSeqInitializerItemProvider genFeatureSeqInitializerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenFeatureSeqInitializer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenFeatureSeqInitializerAdapter() {
		if (genFeatureSeqInitializerItemProvider == null) {
			genFeatureSeqInitializerItemProvider = new GenFeatureSeqInitializerItemProvider(this);
		}

		return genFeatureSeqInitializerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenFeatureValueSpec} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenFeatureValueSpecItemProvider genFeatureValueSpecItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenFeatureValueSpec}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenFeatureValueSpecAdapter() {
		if (genFeatureValueSpecItemProvider == null) {
			genFeatureValueSpecItemProvider = new GenFeatureValueSpecItemProvider(this);
		}

		return genFeatureValueSpecItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenLinkConstraints} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenLinkConstraintsItemProvider genLinkConstraintsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenLinkConstraints}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenLinkConstraintsAdapter() {
		if (genLinkConstraintsItemProvider == null) {
			genLinkConstraintsItemProvider = new GenLinkConstraintsItemProvider(this);
		}

		return genLinkConstraintsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenAuditContainer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenAuditContainerItemProvider genAuditContainerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenAuditContainer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenAuditContainerAdapter() {
		if (genAuditContainerItemProvider == null) {
			genAuditContainerItemProvider = new GenAuditContainerItemProvider(this);
		}

		return genAuditContainerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenAuditRule} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenAuditRuleItemProvider genAuditRuleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenAuditRule}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenAuditRuleAdapter() {
		if (genAuditRuleItemProvider == null) {
			genAuditRuleItemProvider = new GenAuditRuleItemProvider(this);
		}

		return genAuditRuleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenDomainElementTarget} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenDomainElementTargetItemProvider genDomainElementTargetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenDomainElementTarget}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenDomainElementTargetAdapter() {
		if (genDomainElementTargetItemProvider == null) {
			genDomainElementTargetItemProvider = new GenDomainElementTargetItemProvider(this);
		}

		return genDomainElementTargetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenDiagramElementTarget} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenDiagramElementTargetItemProvider genDiagramElementTargetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenDiagramElementTarget}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenDiagramElementTargetAdapter() {
		if (genDiagramElementTargetItemProvider == null) {
			genDiagramElementTargetItemProvider = new GenDiagramElementTargetItemProvider(this);
		}

		return genDiagramElementTargetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenDomainAttributeTarget} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenDomainAttributeTargetItemProvider genDomainAttributeTargetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenDomainAttributeTarget}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenDomainAttributeTargetAdapter() {
		if (genDomainAttributeTargetItemProvider == null) {
			genDomainAttributeTargetItemProvider = new GenDomainAttributeTargetItemProvider(this);
		}

		return genDomainAttributeTargetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenNotationElementTarget} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenNotationElementTargetItemProvider genNotationElementTargetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenNotationElementTarget}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenNotationElementTargetAdapter() {
		if (genNotationElementTargetItemProvider == null) {
			genNotationElementTargetItemProvider = new GenNotationElementTargetItemProvider(this);
		}

		return genNotationElementTargetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenMetricContainer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenMetricContainerItemProvider genMetricContainerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenMetricContainer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenMetricContainerAdapter() {
		if (genMetricContainerItemProvider == null) {
			genMetricContainerItemProvider = new GenMetricContainerItemProvider(this);
		}

		return genMetricContainerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenMetricRule} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenMetricRuleItemProvider genMetricRuleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenMetricRule}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenMetricRuleAdapter() {
		if (genMetricRuleItemProvider == null) {
			genMetricRuleItemProvider = new GenMetricRuleItemProvider(this);
		}

		return genMetricRuleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenAuditedMetricTarget} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenAuditedMetricTargetItemProvider genAuditedMetricTargetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenAuditedMetricTarget}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenAuditedMetricTargetAdapter() {
		if (genAuditedMetricTargetItemProvider == null) {
			genAuditedMetricTargetItemProvider = new GenAuditedMetricTargetItemProvider(this);
		}

		return genAuditedMetricTargetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderContainer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenExpressionProviderContainerItemProvider genExpressionProviderContainerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderContainer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenExpressionProviderContainerAdapter() {
		if (genExpressionProviderContainerItemProvider == null) {
			genExpressionProviderContainerItemProvider = new GenExpressionProviderContainerItemProvider(this);
		}

		return genExpressionProviderContainerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenJavaExpressionProvider} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenJavaExpressionProviderItemProvider genJavaExpressionProviderItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenJavaExpressionProvider}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenJavaExpressionProviderAdapter() {
		if (genJavaExpressionProviderItemProvider == null) {
			genJavaExpressionProviderItemProvider = new GenJavaExpressionProviderItemProvider(this);
		}

		return genJavaExpressionProviderItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenExpressionInterpreter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenExpressionInterpreterItemProvider genExpressionInterpreterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenExpressionInterpreter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenExpressionInterpreterAdapter() {
		if (genExpressionInterpreterItemProvider == null) {
			genExpressionInterpreterItemProvider = new GenExpressionInterpreterItemProvider(this);
		}

		return genExpressionInterpreterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.ValueExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ValueExpressionItemProvider valueExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.ValueExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createValueExpressionAdapter() {
		if (valueExpressionItemProvider == null) {
			valueExpressionItemProvider = new ValueExpressionItemProvider(this);
		}

		return valueExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.codegen.gmfgen.GenConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenConstraintItemProvider genConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmf.codegen.gmfgen.GenConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGenConstraintAdapter() {
		if (genConstraintItemProvider == null) {
			genConstraintItemProvider = new GenConstraintItemProvider(this);
		}

		return genConstraintItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class) || (((Class)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (genEditorGeneratorItemProvider != null) genEditorGeneratorItemProvider.dispose();
		if (genDiagramItemProvider != null) genDiagramItemProvider.dispose();
		if (genEditorViewItemProvider != null) genEditorViewItemProvider.dispose();
		if (genPluginItemProvider != null) genPluginItemProvider.dispose();
		if (genTopLevelNodeItemProvider != null) genTopLevelNodeItemProvider.dispose();
		if (genChildNodeItemProvider != null) genChildNodeItemProvider.dispose();
		if (genChildLabelNodeItemProvider != null) genChildLabelNodeItemProvider.dispose();
		if (genCompartmentItemProvider != null) genCompartmentItemProvider.dispose();
		if (genLinkItemProvider != null) genLinkItemProvider.dispose();
		if (genNodeLabelItemProvider != null) genNodeLabelItemProvider.dispose();
		if (genExternalNodeLabelItemProvider != null) genExternalNodeLabelItemProvider.dispose();
		if (genLinkLabelItemProvider != null) genLinkLabelItemProvider.dispose();
		if (metamodelTypeItemProvider != null) metamodelTypeItemProvider.dispose();
		if (specializationTypeItemProvider != null) specializationTypeItemProvider.dispose();
		if (notationTypeItemProvider != null) notationTypeItemProvider.dispose();
		if (typeModelFacetItemProvider != null) typeModelFacetItemProvider.dispose();
		if (featureModelFacetItemProvider != null) featureModelFacetItemProvider.dispose();
		if (compositeFeatureModelFacetItemProvider != null) compositeFeatureModelFacetItemProvider.dispose();
		if (typeLinkModelFacetItemProvider != null) typeLinkModelFacetItemProvider.dispose();
		if (featureLinkModelFacetItemProvider != null) featureLinkModelFacetItemProvider.dispose();
		if (featureLabelModelFacetItemProvider != null) featureLabelModelFacetItemProvider.dispose();
		if (compositeFeatureLabelModelFacetItemProvider != null) compositeFeatureLabelModelFacetItemProvider.dispose();
		if (designLabelModelFacetItemProvider != null) designLabelModelFacetItemProvider.dispose();
		if (colorAttributesItemProvider != null) colorAttributesItemProvider.dispose();
		if (styleAttributesItemProvider != null) styleAttributesItemProvider.dispose();
		if (resizeConstraintsItemProvider != null) resizeConstraintsItemProvider.dispose();
		if (defaultSizeAttributesItemProvider != null) defaultSizeAttributesItemProvider.dispose();
		if (labelOffsetAttributesItemProvider != null) labelOffsetAttributesItemProvider.dispose();
		if (figureViewmapItemProvider != null) figureViewmapItemProvider.dispose();
		if (snippetViewmapItemProvider != null) snippetViewmapItemProvider.dispose();
		if (innerClassViewmapItemProvider != null) innerClassViewmapItemProvider.dispose();
		if (parentAssignedViewmapItemProvider != null) parentAssignedViewmapItemProvider.dispose();
		if (valueExpressionItemProvider != null) valueExpressionItemProvider.dispose();
		if (genConstraintItemProvider != null) genConstraintItemProvider.dispose();
		if (paletteItemProvider != null) paletteItemProvider.dispose();
		if (toolEntryItemProvider != null) toolEntryItemProvider.dispose();
		if (separatorItemProvider != null) separatorItemProvider.dispose();
		if (toolGroupItemProvider != null) toolGroupItemProvider.dispose();
		if (genFeatureSeqInitializerItemProvider != null) genFeatureSeqInitializerItemProvider.dispose();
		if (genFeatureValueSpecItemProvider != null) genFeatureValueSpecItemProvider.dispose();
		if (genLinkConstraintsItemProvider != null) genLinkConstraintsItemProvider.dispose();
		if (genAuditContainerItemProvider != null) genAuditContainerItemProvider.dispose();
		if (genAuditRuleItemProvider != null) genAuditRuleItemProvider.dispose();
		if (genDomainElementTargetItemProvider != null) genDomainElementTargetItemProvider.dispose();
		if (genDiagramElementTargetItemProvider != null) genDiagramElementTargetItemProvider.dispose();
		if (genDomainAttributeTargetItemProvider != null) genDomainAttributeTargetItemProvider.dispose();
		if (genNotationElementTargetItemProvider != null) genNotationElementTargetItemProvider.dispose();
		if (genMetricContainerItemProvider != null) genMetricContainerItemProvider.dispose();
		if (genMetricRuleItemProvider != null) genMetricRuleItemProvider.dispose();
		if (genAuditedMetricTargetItemProvider != null) genAuditedMetricTargetItemProvider.dispose();
		if (genExpressionProviderContainerItemProvider != null) genExpressionProviderContainerItemProvider.dispose();
		if (genJavaExpressionProviderItemProvider != null) genJavaExpressionProviderItemProvider.dispose();
		if (genExpressionInterpreterItemProvider != null) genExpressionInterpreterItemProvider.dispose();
	}

}
