/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gef;

import java.util.Iterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenLabel;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.gmfgraph.Color;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.Font;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.LineStyle;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.gef.DiagramNodeTest;
import org.eclipse.gmf.tests.gef.DiagramTestBase;
import org.eclipse.gmf.tests.gen.GenericFigureCheck;
import org.eclipse.gmf.tests.setup.CompartmentsSessionSetup;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.swt.graphics.RGB;

public class DiagramNodeTest
extends DiagramTestBase {
    private final GenericFigureCheck.ColorTransformer ourColorTransformer = new GenericFigureCheck.ColorTransformer();
    private final Point myMoveDelta = new Point(10, 20);
    private final Dimension mySizeDelta = new Dimension(100, 50);
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.gef.DiagramNodeTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DiagramNodeTest(String name) {
        super(name);
    }

    public void testCanCreateLink() {
        Node nodeA = this.getNotation(this.getNodeEditPartA());
        Node nodeB = this.getNotation(this.getNodeEditPartB());
        ConnectionEditPart linkByClass = this.createAndCheckLink((View)nodeA, (View)nodeB, this.getSetup().getGenModel().getLinkC());
        DiagramNodeTest.assertNotNull((Object)linkByClass);
        nodeB = this.createNode((GenCommonBase)this.getSetup().getGenModel().getNodeB(), (View)this.getDiagram());
        ConnectionEditPart linkByRef = this.createAndCheckLink((View)nodeA, (View)nodeB, this.getSetup().getGenModel().getLinkD());
        DiagramNodeTest.assertNotNull((Object)linkByRef);
    }

    public void testNotColoredLink() {
        Node nodeA = this.getNotation(this.getNodeEditPartA());
        Node nodeB = this.getNotation(this.getNodeEditPartB());
        ConnectionEditPart linkByClass = this.createAndCheckLink((View)nodeA, (View)nodeB, this.getSetup().getGenModel().getLinkC());
        this.checkLinkColor(linkByClass, this.getSetup().getMapModel().getClassLink().getDiagramLink());
    }

    public void testColoredLink() {
        Node nodeA = this.createNode((GenCommonBase)this.getSetup().getGenModel().getNodeA(), (View)this.getDiagram());
        Node nodeB = this.createNode((GenCommonBase)this.getSetup().getGenModel().getNodeB(), (View)this.getDiagram());
        ConnectionEditPart linkByRef = this.createAndCheckLink((View)nodeA, (View)nodeB, this.getSetup().getGenModel().getLinkD());
        this.checkLinkColor(linkByRef, this.getSetup().getMapModel().getReferenceLink().getDiagramLink());
    }

    public void testLabelFonts() {
        class FontChecker
        extends GenericFigureCheck {
            final /* synthetic */ DiagramNodeTest this$0;

            public FontChecker(DiagramNodeTest diagramNodeTest) {
                this.this$0 = diagramNodeTest;
                super(null);
            }

            public void createAndCheckLabels(GenNode prototype, DiagramLabel eLabel, View notationContainer) {
                FontChecker.assertFalse((boolean)prototype.getLabels().isEmpty());
                Node node = DiagramNodeTest.access$0(this.this$0, (GenCommonBase)prototype, notationContainer);
                Iterator allLabels = prototype.getLabels().iterator();
                while (allLabels.hasNext()) {
                    GenLabel nextLabelType = (GenLabel)allLabels.next();
                    View notationLabel = DiagramNodeTest.findChildView((View)node, (GenCommonBase)nextLabelType);
                    FontChecker.assertNotNull((Object)notationLabel);
                    GraphicalEditPart labelEditPart = (GraphicalEditPart)DiagramNodeTest.access$1(this.this$0, notationLabel);
                    FontChecker.assertNotNull((Object)labelEditPart);
                    this.checkFont(labelEditPart, (Figure)eLabel.getFigure());
                }
            }

            public void checkFont(GraphicalEditPart editPart, Figure eFigure) {
                IFigure d2dFgure = editPart.getFigure();
                FontChecker.assertNotNull((Object)d2dFgure);
                Font font = eFigure.getFont();
                if (font == null) {
                    font = this.this$0.getViewerConfiguration().getDefaultFont();
                }
                this.checkFont(font, d2dFgure.getFont());
            }
        }
        FontChecker fontChecker = new FontChecker(this);
        DiaGenSource gmfGen = this.getSetup().getGenModel();
        CompartmentsSessionSetup.DiaDefSourceExtension gmfGraph = (CompartmentsSessionSetup.DiaDefSourceExtension)this.getSetup().getGraphDefModel();
        fontChecker.createAndCheckLabels(gmfGen.getNodeB(), gmfGraph.getDecoratedDiagramLabel(), (View)this.getDiagram());
    }

    private ConnectionEditPart createAndCheckLink(View source, View target, GenLink genLinkType) {
        Edge newLink = this.createLink(genLinkType, source, target);
        DiagramNodeTest.assertNotNull((Object)newLink);
        DiagramNodeTest.assertEquals((Object)source, (Object)newLink.getSource());
        DiagramNodeTest.assertEquals((Object)target, (Object)newLink.getTarget());
        this.getDiagramEditPart().refresh();
        ConnectionEditPart newLinkEditPart = (ConnectionEditPart)this.findEditPart((View)newLink);
        DiagramNodeTest.assertNotNull((Object)newLinkEditPart);
        return newLinkEditPart;
    }

    private void checkLinkColor(ConnectionEditPart newLinkEditPart, Connection gmfGraphConnection) {
        IFigure actual = newLinkEditPart.getFigure();
        DiagramNodeTest.assertTrue((boolean)(actual instanceof PolylineConnection));
        Figure gmfFigure = (Figure)gmfGraphConnection.getFigure();
        Color gmfColor = gmfFigure.getForegroundColor();
        RGB expectedRGB = gmfColor == null ? this.getViewerConfiguration().getDefaultLinkColor() : this.ourColorTransformer.gmf2swt(gmfColor);
        DiagramNodeTest.assertEquals((Object)expectedRGB, (Object)actual.getForegroundColor().getRGB());
    }

    public void testChangeBounds() {
        EditPart editPart = this.getNodeEditPartA();
        Node notation = this.getNotation(editPart);
        Point originalLocation = this.getLocation(notation);
        Dimension originalSize = this.getSize(notation);
        Point expectedLocation = originalLocation.getTranslated(this.myMoveDelta);
        Dimension expectedNewSize = originalSize.getExpanded(this.mySizeDelta);
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize");
        req.setMoveDelta(this.myMoveDelta);
        req.setSizeDelta(this.mySizeDelta);
        req.setEditParts(editPart);
        req.setResizeDirection(9);
        Command cmd = editPart.getCommand((Request)req);
        DiagramNodeTest.assertNotNull((String)"No resize command", (Object)cmd);
        DiagramNodeTest.assertTrue((String)"Can't execute resize command", (boolean)cmd.canExecute());
        this.getCommandStack().execute(cmd);
        this.assertBoundValues(notation, expectedLocation, expectedNewSize, "exec");
        DiagramNodeTest.assertTrue((String)"Can't undo resize command", (boolean)this.getCommandStack().canUndo());
        this.getCommandStack().undo();
        this.assertBoundValues(notation, originalLocation, originalSize, "undo");
        DiagramNodeTest.assertTrue((String)"Can't redo resize command", (boolean)this.getCommandStack().canRedo());
        this.getCommandStack().redo();
        this.assertBoundValues(notation, expectedLocation, expectedNewSize, "redo");
    }

    private void assertBoundValues(Node notation, Point expectedLocation, Dimension expectedSize, String assertTag) {
        DiagramNodeTest.assertEquals((String)("Location doesn't match one set after [" + assertTag + ']'), (Object)expectedLocation, (Object)this.getLocation(notation));
        DiagramNodeTest.assertEquals((String)("Size doesn't match one set after [" + assertTag + ']'), (Object)expectedSize, (Object)this.getSize(notation));
    }

    private int getForegroundColor(Node notation) {
        LineStyle ls = (LineStyle)notation.getStyle(NotationPackage.eINSTANCE.getLineStyle());
        return ls.getLineColor();
    }

    private int getBackgroundColor(Node notation) {
        FillStyle fs = (FillStyle)notation.getStyle(NotationPackage.eINSTANCE.getFillStyle());
        return fs.getFillColor();
    }

    private Dimension getSize(Node notation) {
        Size b = (Size)notation.getLayoutConstraint();
        return new Dimension(b.getWidth(), b.getHeight());
    }

    private Point getLocation(Node notation) {
        Location l = (Location)notation.getLayoutConstraint();
        return new Point(l.getX(), l.getY());
    }

    public void testChangeColors() {
        Node notation = this.getNotation(this.getNodeEditPartA());
        int originalBackgroundColor = this.getBackgroundColor(notation);
        int originalForegroundColor = this.getForegroundColor(notation);
        int newBackgroundColor = FigureUtilities.RGBToInteger((RGB)new RGB(255, 0, 0));
        int newForegroundColor = FigureUtilities.RGBToInteger((RGB)new RGB(0, 255, 255));
        if (!$assertionsDisabled && newBackgroundColor == originalBackgroundColor) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && newForegroundColor == originalForegroundColor) {
            throw new AssertionError();
        }
        Command foreCmd = this.createChangeColorCommand(notation, newForegroundColor, true);
        DiagramNodeTest.assertNotNull((String)"No changeForegroundColor command", (Object)foreCmd);
        DiagramNodeTest.assertTrue((String)"Can't execute changeForegroundColor command", (boolean)foreCmd.canExecute());
        this.getCommandStack().execute(foreCmd);
        this.assertColorValues(notation, newForegroundColor, originalBackgroundColor, "exec(fore)");
        DiagramNodeTest.assertTrue((String)"Can't undo changeForegroundColor command", (boolean)this.getCommandStack().canUndo());
        this.getCommandStack().undo();
        this.assertColorValues(notation, originalForegroundColor, originalBackgroundColor, "undo(fore)");
        DiagramNodeTest.assertTrue((String)"Can't redo changeForegroundColor command", (boolean)this.getCommandStack().canRedo());
        this.getCommandStack().redo();
        this.assertColorValues(notation, newForegroundColor, originalBackgroundColor, "redo(fore)");
        Command backCmd = this.createChangeColorCommand(notation, newBackgroundColor, false);
        DiagramNodeTest.assertNotNull((String)"No changeBackgroundColor command", (Object)backCmd);
        DiagramNodeTest.assertTrue((String)"Can't execute changeBackgroundColor command", (boolean)backCmd.canExecute());
        this.getCommandStack().execute(backCmd);
        this.assertColorValues(notation, newForegroundColor, newBackgroundColor, "exec(back)");
        DiagramNodeTest.assertTrue((String)"Can't undo changeBackgroundColor command", (boolean)this.getCommandStack().canUndo());
        this.getCommandStack().undo();
        this.assertColorValues(notation, newForegroundColor, originalBackgroundColor, "undo(back)");
        DiagramNodeTest.assertTrue((String)"Can't redo changeBackgroundColor command", (boolean)this.getCommandStack().canRedo());
        this.getCommandStack().redo();
        this.assertColorValues(notation, newForegroundColor, newBackgroundColor, "redo(back)");
    }

    private Command createChangeColorCommand(Node notation, int newColor, boolean isForeground) {
        return this.getViewerConfiguration().getSetNotationalElementStructuralFeature((View)notation, (EStructuralFeature)(isForeground ? NotationPackage.eINSTANCE.getLineStyle_LineColor() : NotationPackage.eINSTANCE.getFillStyle_FillColor()), new Integer(newColor));
    }

    private void assertColorValues(Node notation, int expectedForegroundColor, int expectedBackgroundColor, String assertTag) {
        DiagramNodeTest.assertEquals((String)("Foreground color doesn't match after [" + assertTag + ']'), (int)expectedForegroundColor, (int)this.getForegroundColor(notation));
        DiagramNodeTest.assertEquals((String)("Background color doesn't match after [" + assertTag + ']'), (int)expectedBackgroundColor, (int)this.getBackgroundColor(notation));
    }

    static /* synthetic */ Node access$0(DiagramNodeTest diagramNodeTest, GenCommonBase genCommonBase, View view) {
        return diagramNodeTest.createNode(genCommonBase, view);
    }

    static /* synthetic */ EditPart access$1(DiagramNodeTest diagramNodeTest, View view) {
        return diagramNodeTest.findEditPart(view);
    }
}

