/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import org.eclipse.gmf.common.codegen.ImportAssistant;
import org.eclipse.gmf.gmfgraph.Dimension;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.RoundedRectangle;
import org.eclipse.gmf.gmfgraph.util.FigureQualifiedNameSwitch;
import org.eclipse.gmf.gmfgraph.util.RuntimeFQNSwitch;
import org.eclipse.gmf.graphdef.codegen.FigureGenerator;
import org.eclipse.gmf.graphdef.codegen.MapModeCodeGenStrategy;
import org.eclipse.gmf.tests.gen.FigureCodegenTestBase;

public class MapModeStrategyTest
extends FigureCodegenTestBase {
    public MapModeStrategyTest(String name) {
        super(name);
    }

    public void testPreferredSize() {
        this.checkAllStrategies(this.createFigureWithPrefferedSize());
    }

    public void testRoundedRectangleCorners() {
        RoundedRectangle rounded = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
        rounded.setName("RoundedRectangleWithCorners");
        rounded.setCornerWidth(23);
        rounded.setCornerHeight(14);
        this.checkAllStrategies((Figure)rounded);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkAllStrategies(Figure figure) {
        String baseName = figure.getName();
        try {
            this.setCustomFigureGenerator(this.createGenerator(this.createStaticIdentity()));
            figure.setName(String.valueOf(baseName) + "_StaticIdentity");
            this.performTests(figure);
            this.setCustomFigureGenerator(this.createGenerator(this.createDefaultStrategy()));
            figure.setName(String.valueOf(baseName) + "_DefaultMapMode");
            this.performTests(figure);
            figure.setName(String.valueOf(baseName) + "_StandaloneMapMode");
            this.setCustomFigureGenerator(this.createGenerator(this.createStandaloneStrategy(this.createImportManager(figure))));
            this.performTests(figure);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            figure.setName(baseName);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        figure.setName(baseName);
    }

    private Figure createFigureWithPrefferedSize() {
        Figure figure = this.figure2();
        figure.setName("Figure2WithPreferredSize");
        Dimension preferredSize = GMFGraphFactory.eINSTANCE.createDimension();
        preferredSize.setDx(234);
        preferredSize.setDy(567);
        figure.setPreferredSize(preferredSize);
        return figure;
    }

    private MapModeCodeGenStrategy createStaticIdentity() {
        return new MapModeCodeGenStrategy.StaticIdentityMapMode();
    }

    private MapModeCodeGenStrategy createDefaultStrategy() {
        return new MapModeCodeGenStrategy.RuntimeUnspecifiedMapMode();
    }

    private MapModeCodeGenStrategy createStandaloneStrategy(ImportAssistant assistant) {
        return new MapModeCodeGenStrategy.RuntimeMapModeFromPluginClass(assistant, this.getPluginActivatorClassFQN());
    }

    private FigureGenerator createGenerator(MapModeCodeGenStrategy strategy) {
        return new FigureGenerator((FigureQualifiedNameSwitch)new RuntimeFQNSwitch(), strategy, false);
    }
}

