/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.common.core.internal.command;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;

public class AbstractCommandTest
extends TestCase {
    private IOperationHistory history;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        TestRunner.run((Test)AbstractCommandTest.suite());
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.common.core.internal.command.AbstractCommandTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public AbstractCommandTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.history = OperationHistoryFactory.getOperationHistory();
    }

    private List getFiles(String str) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = workspaceRoot.findFilesForLocationURI(URI.create(str));
        return Arrays.asList(files);
    }

    public void test_execute_undo_redo() {
        String name = "test_execute_undo_redo";
        TestCommand c = new TestCommand(name, null);
        ObjectUndoContext ctx = new ObjectUndoContext((Object)this);
        try {
            c.addContext((IUndoContext)ctx);
            this.history.execute((IUndoableOperation)c, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            AbstractCommandTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
        }
        c.assertExecuted();
        try {
            AbstractCommandTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            AbstractCommandTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
        }
        c.assertUndone();
        try {
            AbstractCommandTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            AbstractCommandTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
        }
        c.assertRedone();
    }

    public void test_compose() {
        String name = "test_compose";
        UndoContext ctx1 = new UndoContext();
        UndoContext ctx2 = new UndoContext();
        TestCommand c1 = new TestCommand(name, this.getFiles("null:/compose1"));
        c1.addContext((IUndoContext)ctx1);
        TestCommand c2 = new TestCommand(name, this.getFiles("null:/compose2"));
        c2.addContext((IUndoContext)ctx2);
        ICommand composition = c1.compose((IUndoableOperation)c2);
        List affectedFiles = composition.getAffectedFiles();
        AbstractCommandTest.assertTrue((boolean)affectedFiles.containsAll(c1.getAffectedFiles()));
        AbstractCommandTest.assertTrue((boolean)affectedFiles.containsAll(c2.getAffectedFiles()));
        AbstractCommandTest.assertEquals((int)(c1.getAffectedFiles().size() + c2.getAffectedFiles().size()), (int)affectedFiles.size());
        List<IUndoContext> contexts = Arrays.asList(composition.getContexts());
        AbstractCommandTest.assertTrue((boolean)contexts.contains(ctx1));
        AbstractCommandTest.assertTrue((boolean)contexts.contains(ctx2));
    }

    public void test_reduce() {
        String name = "test_reduce";
        TestCommand c = new TestCommand(name, null);
        ICommand reduction = c.reduce();
        AbstractCommandTest.assertSame((Object)((Object)c), (Object)reduction);
    }

    public void test_getAffectedFiles() {
        String fixtureName = "test_getAffectedFiles";
        TestCommand c = new TestCommand(fixtureName, null);
        AbstractCommandTest.assertTrue((boolean)c.getAffectedFiles().isEmpty());
        List affectedFiles = this.getFiles("null:/AbstractCommandTest");
        c = new TestCommand(fixtureName, affectedFiles);
        AbstractCommandTest.assertEquals((int)affectedFiles.size(), (int)c.getAffectedFiles().size());
        AbstractCommandTest.assertTrue((boolean)c.getAffectedFiles().containsAll(affectedFiles));
    }

    public void test_noCommandResult_146064() {
        String name = "test_noCommandResult_146064";
        TestCommandNoResults c = new TestCommandNoResults(name, null);
        ObjectUndoContext ctx = new ObjectUndoContext((Object)this);
        try {
            c.addContext((IUndoContext)ctx);
            this.history.execute((IUndoableOperation)c, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            AbstractCommandTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
        }
        ((TestCommand)c).assertExecuted();
        try {
            AbstractCommandTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            AbstractCommandTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
        }
        ((TestCommand)c).assertUndone();
        try {
            AbstractCommandTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            AbstractCommandTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
        }
        ((TestCommand)c).assertRedone();
    }

    public void test_nullMonitor_149057() {
        TestCommandWithProgress c = new TestCommandWithProgress("test_nullMonitor_149057");
        ObjectUndoContext ctx = new ObjectUndoContext((Object)this);
        try {
            c.addContext((IUndoContext)ctx);
            this.history.execute((IUndoableOperation)c, null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            AbstractCommandTest.fail((String)("Should not have thrown: " + e.getCause()));
        }
        c.assertExecuted();
        try {
            AbstractCommandTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            AbstractCommandTest.fail((String)("Should not have thrown: " + e.getCause()));
        }
        c.assertUndone();
        try {
            AbstractCommandTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            AbstractCommandTest.fail((String)("Should not have thrown: " + e.getCause()));
        }
        c.assertRedone();
    }

    protected static class TestCommand
    extends AbstractCommand {
        private static final String EXECUTED = "executed";
        private static final String UNDONE = "undone";
        private static final String REDONE = "redone";
        protected boolean executed;
        protected boolean undone;
        protected boolean redone;

        public TestCommand(String label, List affectedFiles) {
            super(label, affectedFiles);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            this.executed = true;
            this.undone = false;
            this.redone = false;
            return CommandResult.newOKCommandResult((Object)EXECUTED);
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            this.executed = false;
            this.undone = false;
            this.redone = true;
            return CommandResult.newOKCommandResult((Object)REDONE);
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            this.executed = false;
            this.undone = true;
            this.redone = false;
            return CommandResult.newOKCommandResult((Object)UNDONE);
        }

        public void assertExecuted() {
            AbstractCommandTest.assertTrue((boolean)this.executed);
            AbstractCommandTest.assertFalse((boolean)this.undone);
            AbstractCommandTest.assertFalse((boolean)this.redone);
            AbstractCommandTest.assertEquals((int)0, (int)this.getCommandResult().getStatus().getSeverity());
            AbstractCommandTest.assertSame((Object)EXECUTED, (Object)this.getCommandResult().getReturnValue());
        }

        public void assertUndone() {
            AbstractCommandTest.assertTrue((boolean)this.undone);
            AbstractCommandTest.assertFalse((boolean)this.executed);
            AbstractCommandTest.assertFalse((boolean)this.redone);
            AbstractCommandTest.assertEquals((int)0, (int)this.getCommandResult().getStatus().getSeverity());
            AbstractCommandTest.assertSame((Object)UNDONE, (Object)this.getCommandResult().getReturnValue());
        }

        public void assertRedone() {
            AbstractCommandTest.assertTrue((boolean)this.redone);
            AbstractCommandTest.assertFalse((boolean)this.undone);
            AbstractCommandTest.assertFalse((boolean)this.executed);
            AbstractCommandTest.assertEquals((int)0, (int)this.getCommandResult().getStatus().getSeverity());
            AbstractCommandTest.assertSame((Object)REDONE, (Object)this.getCommandResult().getReturnValue());
        }
    }

    protected static class TestCommandNoResults
    extends TestCommand {
        public TestCommandNoResults(String label, List affectedFiles) {
            super(label, affectedFiles);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            super.doExecuteWithResult(progressMonitor, info);
            return null;
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            super.doRedoWithResult(progressMonitor, info);
            return null;
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            super.doUndoWithResult(progressMonitor, info);
            return null;
        }

        public void assertExecuted() {
            AbstractCommandTest.assertTrue((boolean)this.executed);
            AbstractCommandTest.assertFalse((boolean)this.undone);
            AbstractCommandTest.assertFalse((boolean)this.redone);
            AbstractCommandTest.assertNull((Object)this.getCommandResult());
        }

        public void assertUndone() {
            AbstractCommandTest.assertTrue((boolean)this.undone);
            AbstractCommandTest.assertFalse((boolean)this.executed);
            AbstractCommandTest.assertFalse((boolean)this.redone);
            AbstractCommandTest.assertNull((Object)this.getCommandResult());
        }

        public void assertRedone() {
            AbstractCommandTest.assertTrue((boolean)this.redone);
            AbstractCommandTest.assertFalse((boolean)this.undone);
            AbstractCommandTest.assertFalse((boolean)this.executed);
            AbstractCommandTest.assertNull((Object)this.getCommandResult());
        }
    }

    protected static class TestCommandWithProgress
    extends TestCommand {
        public TestCommandWithProgress(String label) {
            super(label, null);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            progressMonitor.worked(1);
            return super.doExecuteWithResult(progressMonitor, info);
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            progressMonitor.worked(1);
            return super.doRedoWithResult(progressMonitor, info);
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            progressMonitor.worked(1);
            return super.doUndoWithResult(progressMonitor, info);
        }
    }
}

