/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.type.core;

import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ClientContextManager;
import org.eclipse.gmf.runtime.emf.type.core.EditHelperContext;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeAddedEvent;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IEditHelperContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IElementTypeFactory;
import org.eclipse.gmf.runtime.emf.type.core.IElementTypeRegistryListener;
import org.eclipse.gmf.runtime.emf.type.core.IMetamodelType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.MetamodelType;
import org.eclipse.gmf.runtime.emf.type.core.SpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.internal.impl.DefaultMetamodelType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.tests.runtime.emf.type.core.AbstractEMFTypeTest;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Department;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Employee;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.EmployeePackage;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.HighSchoolStudent;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Office;
import org.eclipse.gmf.tests.runtime.emf.type.core.employee.Student;
import org.eclipse.gmf.tests.runtime.emf.type.core.internal.EmployeeType;
import org.eclipse.gmf.tests.runtime.emf.type.core.internal.SecurityClearedElementTypeFactory;

public class ElementTypeRegistryTest
extends AbstractEMFTypeTest {
    private ElementTypeRegistry fixture = null;
    private IClientContext clientContext;
    private IClientContext unboundClientContext;
    private Department department;
    private Department executiveDepartment;
    private Department financeDepartment;
    private Employee employee;
    private Employee financeEmployee;
    private Employee financeManager;
    private Student student;
    private HighSchoolStudent highSchoolStudent;
    private Office employeeOffice;
    private Office studentOffice;
    private Employee manager;
    private Office managerOffice;
    private Employee executive;
    private Office executiveOffice;
    private Department cDepartment;
    private Department cExecutiveDepartment;
    private Department cFinanceDepartment;
    private Employee cEmployee;
    private Employee cFinanceEmployee;
    private Employee cFinanceManager;
    private Student cStudent;
    private Office cEmployeeOffice;
    private Office cStudentOffice;
    private Employee cManager;
    private Office cManagerOffice;
    private Employee cExecutive;
    private Office cExecutiveOffice;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public ElementTypeRegistryTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ElementTypeRegistryTest.suite());
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.ElementTypeRegistryTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    protected void doModelSetup(Resource resource) {
        this.setFixture(ElementTypeRegistry.getInstance());
        this.department = (Department)this.getEmployeeFactory().create(this.getEmployeePackage().getDepartment());
        this.department.setName("Department");
        resource.getContents().add((Object)this.department);
        this.executiveDepartment = (Department)this.getEmployeeFactory().create(this.getEmployeePackage().getDepartment());
        this.executiveDepartment.setName("ExecutiveDepartment");
        resource.getContents().add((Object)this.executiveDepartment);
        this.financeDepartment = (Department)this.getEmployeeFactory().create(this.getEmployeePackage().getDepartment());
        this.financeDepartment.setName("Finance");
        resource.getContents().add((Object)this.financeDepartment);
        this.employee = (Employee)this.getEmployeeFactory().create(this.getEmployeePackage().getEmployee());
        this.employee.setNumber(1);
        this.department.getMembers().add((Object)this.employee);
        this.employeeOffice = (Office)this.getEmployeeFactory().create(this.getEmployeePackage().getOffice());
        this.employee.setOffice(this.employeeOffice);
        this.financeEmployee = (Employee)this.getEmployeeFactory().create(this.getEmployeePackage().getEmployee());
        this.financeEmployee.setDepartment(this.financeDepartment);
        this.financeManager = (Employee)this.getEmployeeFactory().create(this.getEmployeePackage().getEmployee());
        this.financeDepartment.setManager(this.financeManager);
        Office financeManagerOffice = (Office)this.getEmployeeFactory().create(this.getEmployeePackage().getOffice());
        financeManagerOffice.setNumberOfWindows(1);
        financeManagerOffice.setHasDoor(false);
        this.financeManager.setOffice(financeManagerOffice);
        this.student = (Student)this.getEmployeeFactory().create(this.getEmployeePackage().getStudent());
        this.student.setNumber(2);
        this.department.getMembers().add((Object)this.student);
        this.studentOffice = (Office)this.getEmployeeFactory().create(this.getEmployeePackage().getOffice());
        this.student.setOffice(this.studentOffice);
        this.manager = (Employee)this.getEmployeeFactory().create(this.getEmployeePackage().getEmployee());
        this.department.setManager(this.manager);
        this.managerOffice = (Office)this.getEmployeeFactory().create(this.getEmployeePackage().getOffice());
        this.managerOffice.setNumberOfWindows(1);
        this.managerOffice.setHasDoor(false);
        this.manager.setOffice(this.managerOffice);
        this.executive = (Employee)this.getEmployeeFactory().create(this.getEmployeePackage().getEmployee());
        this.executiveDepartment.setManager(this.executive);
        this.executiveOffice = (Office)this.getEmployeeFactory().create(this.getEmployeePackage().getOffice());
        this.executiveOffice.setNumberOfWindows(1);
        this.executiveOffice.setHasDoor(true);
        this.executive.setOffice(this.executiveOffice);
        this.highSchoolStudent = (HighSchoolStudent)this.getEmployeeFactory().create(this.getEmployeePackage().getHighSchoolStudent());
    }

    protected void doModelSetupWithContext(Resource resource) {
        this.setFixture(ElementTypeRegistry.getInstance());
        this.cDepartment = (Department)this.getEmployeeFactory().create(this.getEmployeePackage().getDepartment());
        this.cDepartment.setName("DepartmentWithContext");
        resource.getContents().add((Object)this.cDepartment);
        this.cExecutiveDepartment = (Department)this.getEmployeeFactory().create(this.getEmployeePackage().getDepartment());
        this.cExecutiveDepartment.setName("ExecutiveDepartmentWithContext");
        resource.getContents().add((Object)this.cExecutiveDepartment);
        this.cFinanceDepartment = (Department)this.getEmployeeFactory().create(this.getEmployeePackage().getDepartment());
        this.cFinanceDepartment.setName("FinanceWithContext");
        resource.getContents().add((Object)this.cFinanceDepartment);
        this.cEmployee = (Employee)this.getEmployeeFactory().create(this.getEmployeePackage().getEmployee());
        this.cEmployee.setNumber(1);
        this.cDepartment.getMembers().add((Object)this.cEmployee);
        this.cEmployeeOffice = (Office)this.getEmployeeFactory().create(this.getEmployeePackage().getOffice());
        this.cEmployee.setOffice(this.cEmployeeOffice);
        this.cFinanceEmployee = (Employee)this.getEmployeeFactory().create(this.getEmployeePackage().getEmployee());
        this.cFinanceEmployee.setDepartment(this.cFinanceDepartment);
        this.cFinanceManager = (Employee)this.getEmployeeFactory().create(this.getEmployeePackage().getEmployee());
        this.cFinanceDepartment.setManager(this.cFinanceManager);
        Office financeManagerOffice = (Office)this.getEmployeeFactory().create(this.getEmployeePackage().getOffice());
        financeManagerOffice.setNumberOfWindows(1);
        financeManagerOffice.setHasDoor(false);
        this.cFinanceManager.setOffice(financeManagerOffice);
        this.cStudent = (Student)this.getEmployeeFactory().create(this.getEmployeePackage().getStudent());
        this.cStudent.setNumber(2);
        this.cDepartment.getMembers().add((Object)this.cStudent);
        this.cStudentOffice = (Office)this.getEmployeeFactory().create(this.getEmployeePackage().getOffice());
        this.cStudent.setOffice(this.cStudentOffice);
        this.cManager = (Employee)this.getEmployeeFactory().create(this.getEmployeePackage().getEmployee());
        this.cDepartment.setManager(this.cManager);
        this.cManagerOffice = (Office)this.getEmployeeFactory().create(this.getEmployeePackage().getOffice());
        this.cManagerOffice.setNumberOfWindows(1);
        this.cManagerOffice.setHasDoor(false);
        this.cManager.setOffice(this.cManagerOffice);
        this.cExecutive = (Employee)this.getEmployeeFactory().create(this.getEmployeePackage().getEmployee());
        this.cExecutiveDepartment.setManager(this.cExecutive);
        this.cExecutiveOffice = (Office)this.getEmployeeFactory().create(this.getEmployeePackage().getOffice());
        this.cExecutiveOffice.setNumberOfWindows(1);
        this.cExecutiveOffice.setHasDoor(true);
        this.cExecutive.setOffice(this.cExecutiveOffice);
    }

    protected ElementTypeRegistry getFixture() {
        return this.fixture;
    }

    protected void setFixture(ElementTypeRegistry fixture) {
        this.fixture = fixture;
    }

    protected IClientContext getClientContext() {
        if (this.clientContext == null) {
            this.clientContext = ClientContextManager.getInstance().getClientContext("org.eclipse.gmf.tests.runtime.emf.type.core.ClientContext1");
        }
        return this.clientContext;
    }

    protected IClientContext getUnboundClientContext() {
        if (this.unboundClientContext == null) {
            this.unboundClientContext = ClientContextManager.getInstance().getClientContext("org.eclipse.gmf.tests.runtime.emf.type.core.UnboundClientContext");
        }
        return this.unboundClientContext;
    }

    public void test_getSpecializationsOf_151097() {
        ISpecializationType[] specializations = ElementTypeRegistry.getInstance().getSpecializationsOf("org.eclipse.gmf.tests.runtime.emf.type.core.employee");
        ElementTypeRegistryTest.assertEquals((int)3, (int)specializations.length);
        int i = 0;
        while (i < specializations.length) {
            if (specializations[i].getId().equals("org.eclipse.gmf.tests.runtime.emf.type.core.manager") && specializations[i].getClass().equals("org.eclipse.gmf.tests.runtime.emf.type.core.topSecret") && specializations[i].getClass().equals("org.eclipse.gmf.tests.runtime.emf.type.core.executive")) {
                ElementTypeRegistryTest.fail((String)"expected manager, top-secret and executive specializations");
            }
            ++i;
        }
    }

    public void test_getAllTypesMatching_eObject_metamodel() {
        IElementType[] officeMatches = this.getFixture().getAllTypesMatching((EObject)this.employeeOffice);
        ElementTypeRegistryTest.assertTrue((officeMatches.length == 1 ? 1 : 0) != 0);
        ElementTypeRegistryTest.assertTrue((officeMatches[0] == EmployeeType.OFFICE ? 1 : 0) != 0);
    }

    public void test_getAllTypesMatching_eObject_metamodel_withContext() {
        IElementType[] officeMatches = this.getFixture().getAllTypesMatching((EObject)this.cEmployeeOffice);
        ElementTypeRegistryTest.assertTrue((officeMatches.length == 1 ? 1 : 0) != 0);
        ElementTypeRegistryTest.assertTrue((officeMatches[0] == EmployeeType.CONTEXT_OFFICE ? 1 : 0) != 0);
        officeMatches = this.getFixture().getAllTypesMatching((EObject)this.cEmployeeOffice, this.getClientContext());
        ElementTypeRegistryTest.assertTrue((officeMatches.length == 1 ? 1 : 0) != 0);
        ElementTypeRegistryTest.assertTrue((officeMatches[0] == EmployeeType.CONTEXT_OFFICE ? 1 : 0) != 0);
    }

    public void test_getAllTypesMatching_eObject_metamodel_unboundContext() {
        IElementType[] officeMatches = this.getFixture().getAllTypesMatching((EObject)this.cEmployeeOffice, this.getUnboundClientContext());
        ElementTypeRegistryTest.assertTrue((officeMatches.length == 1 ? 1 : 0) != 0);
        ElementTypeRegistryTest.assertTrue((officeMatches[0] == DefaultMetamodelType.getInstance() ? 1 : 0) != 0);
    }

    public void test_getAllTypesMatching_eObject_metamodelAndSpecializations() {
        IElementType[] managerMatches = this.getFixture().getAllTypesMatching((EObject)this.manager);
        ElementTypeRegistryTest.assertEquals((int)3, (int)managerMatches.length);
        List<IElementType> managerMatchList = Arrays.asList(managerMatches);
        ElementTypeRegistryTest.assertTrue((boolean)managerMatchList.contains(EmployeeType.MANAGER));
        ElementTypeRegistryTest.assertTrue((boolean)managerMatchList.contains(EmployeeType.TOP_SECRET));
        ElementTypeRegistryTest.assertEquals((Object)EmployeeType.EMPLOYEE, (Object)managerMatches[2]);
    }

    public void test_getAllTypesMatching_eObject_metamodelAndSpecializations_withContext() {
        IElementType[] managerMatches = this.getFixture().getAllTypesMatching((EObject)this.cManager);
        ElementTypeRegistryTest.assertEquals((int)3, (int)managerMatches.length);
        List<IElementType> managerMatchList = Arrays.asList(managerMatches);
        ElementTypeRegistryTest.assertTrue((boolean)managerMatchList.contains(EmployeeType.CONTEXT_MANAGER));
        ElementTypeRegistryTest.assertTrue((boolean)managerMatchList.contains(EmployeeType.CONTEXT_TOP_SECRET));
        ElementTypeRegistryTest.assertEquals((Object)EmployeeType.CONTEXT_EMPLOYEE, (Object)managerMatches[2]);
        managerMatches = this.getFixture().getAllTypesMatching((EObject)this.cManager, this.getClientContext());
        ElementTypeRegistryTest.assertEquals((int)3, (int)managerMatches.length);
        managerMatchList = Arrays.asList(managerMatches);
        ElementTypeRegistryTest.assertTrue((boolean)managerMatchList.contains(EmployeeType.CONTEXT_MANAGER));
        ElementTypeRegistryTest.assertTrue((boolean)managerMatchList.contains(EmployeeType.CONTEXT_TOP_SECRET));
        ElementTypeRegistryTest.assertEquals((Object)EmployeeType.CONTEXT_EMPLOYEE, (Object)managerMatches[2]);
    }

    public void test_getAllTypesMatching_eObject_metamodelAndSpecializations_unboundContext() {
        IElementType[] managerMatches = this.getFixture().getAllTypesMatching((EObject)this.cManager, this.getUnboundClientContext());
        ElementTypeRegistryTest.assertEquals((int)1, (int)managerMatches.length);
        ElementTypeRegistryTest.assertTrue((managerMatches[0] == DefaultMetamodelType.getInstance() ? 1 : 0) != 0);
    }

    public void test_getMetamodelTypes_155601() {
        IMetamodelType[] metamodelTypes = ElementTypeRegistry.getInstance().getMetamodelTypes(this.getClientContext());
        ElementTypeRegistryTest.assertEquals((int)EmployeeType.METAMODEL_TYPES_WITH_CONTEXT.length, (int)metamodelTypes.length);
        int i = 0;
        while (i < metamodelTypes.length) {
            boolean match = false;
            int j = 0;
            while (j < EmployeeType.METAMODEL_TYPES_WITH_CONTEXT.length) {
                if (metamodelTypes[i] == EmployeeType.METAMODEL_TYPES_WITH_CONTEXT[j]) {
                    match = true;
                    break;
                }
                ++j;
            }
            ElementTypeRegistryTest.assertTrue((String)"missing metamodel type", (boolean)match);
            ++i;
        }
    }

    public void test_getSpecializationTypes_155601() {
        ISpecializationType[] specializationTypes = ElementTypeRegistry.getInstance().getSpecializationTypes(this.getClientContext());
        ElementTypeRegistryTest.assertEquals((int)EmployeeType.SPECIALIZATION_TYPES_WITH_CONTEXT.length, (int)specializationTypes.length);
        int i = 0;
        while (i < specializationTypes.length) {
            boolean match = false;
            int j = 0;
            while (j < EmployeeType.SPECIALIZATION_TYPES_WITH_CONTEXT.length) {
                if (specializationTypes[i] == EmployeeType.SPECIALIZATION_TYPES_WITH_CONTEXT[j]) {
                    match = true;
                    break;
                }
                ++j;
            }
            ElementTypeRegistryTest.assertTrue((String)"missing specialization type", (boolean)match);
            ++i;
        }
    }

    public void test_getElementTypes_155601() {
        IElementType[] elementTypes = ElementTypeRegistry.getInstance().getElementTypes(this.getClientContext());
        ElementTypeRegistryTest.assertEquals((int)(EmployeeType.METAMODEL_TYPES_WITH_CONTEXT.length + EmployeeType.SPECIALIZATION_TYPES_WITH_CONTEXT.length), (int)elementTypes.length);
        int i = 0;
        while (i < elementTypes.length) {
            boolean match = false;
            int j = 0;
            while (j < EmployeeType.METAMODEL_TYPES_WITH_CONTEXT.length) {
                if (elementTypes[i] == EmployeeType.METAMODEL_TYPES_WITH_CONTEXT[j]) {
                    match = true;
                    break;
                }
                ++j;
            }
            if (!match) {
                j = 0;
                while (j < EmployeeType.SPECIALIZATION_TYPES_WITH_CONTEXT.length) {
                    if (elementTypes[i] == EmployeeType.SPECIALIZATION_TYPES_WITH_CONTEXT[j]) {
                        match = true;
                        break;
                    }
                    ++j;
                }
            }
            ElementTypeRegistryTest.assertTrue((String)"missing element type", (boolean)match);
            ++i;
        }
    }

    public void test_getContainedTypes_metamodel() {
        IElementType[] officeMatches = this.getFixture().getContainedTypes((EObject)this.employee, EmployeePackage.eINSTANCE.getEmployee_Office());
        ElementTypeRegistryTest.assertEquals((int)1, (int)officeMatches.length);
        List<IElementType> officeMatchList = Arrays.asList(officeMatches);
        ElementTypeRegistryTest.assertTrue((boolean)officeMatchList.contains(EmployeeType.OFFICE));
    }

    public void test_getContainedTypes_metamodel_withContext() {
        IElementType[] officeMatches = this.getFixture().getContainedTypes((EObject)this.cEmployee, EmployeePackage.eINSTANCE.getEmployee_Office());
        ElementTypeRegistryTest.assertEquals((int)1, (int)officeMatches.length);
        List<IElementType> officeMatchList = Arrays.asList(officeMatches);
        ElementTypeRegistryTest.assertTrue((boolean)officeMatchList.contains(EmployeeType.CONTEXT_OFFICE));
        officeMatches = this.getFixture().getContainedTypes((EObject)this.cEmployee, EmployeePackage.eINSTANCE.getEmployee_Office(), this.getClientContext());
        ElementTypeRegistryTest.assertEquals((int)1, (int)officeMatches.length);
        officeMatchList = Arrays.asList(officeMatches);
        ElementTypeRegistryTest.assertTrue((boolean)officeMatchList.contains(EmployeeType.CONTEXT_OFFICE));
    }

    public void test_getContainedTypes_metamodel_unboundContext() {
        IElementType[] officeMatches = this.getFixture().getContainedTypes((EObject)this.cEmployee, EmployeePackage.eINSTANCE.getEmployee_Office(), this.getUnboundClientContext());
        ElementTypeRegistryTest.assertEquals((int)0, (int)officeMatches.length);
    }

    public void test_getContainedTypes_metamodelAndSpecializations_departmentMembers() {
        IElementType[] memberMatches = this.getFixture().getContainedTypes((EObject)this.department, EmployeePackage.eINSTANCE.getDepartment_Members());
        List<IElementType> memberMatchList = Arrays.asList(memberMatches);
        List<Object> expected = Arrays.asList(EmployeeType.EMPLOYEE, EmployeeType.STUDENT, EmployeeType.HIGH_SCHOOL_STUDENT, EmployeeType.TOP_SECRET);
        ElementTypeRegistryTest.assertEquals((int)expected.size(), (int)memberMatches.length);
        ElementTypeRegistryTest.assertTrue((boolean)memberMatchList.containsAll(expected));
    }

    public void test_getContainedTypes_metamodelAndSpecializations_departmentMembers_withContext() {
        IElementType[] memberMatches = this.getFixture().getContainedTypes((EObject)this.cDepartment, EmployeePackage.eINSTANCE.getDepartment_Members());
        List<IElementType> memberMatchList = Arrays.asList(memberMatches);
        List<Object> expected = Arrays.asList(EmployeeType.CONTEXT_EMPLOYEE, EmployeeType.CONTEXT_STUDENT, EmployeeType.CONTEXT_TOP_SECRET);
        ElementTypeRegistryTest.assertEquals((int)expected.size(), (int)memberMatches.length);
        ElementTypeRegistryTest.assertTrue((boolean)memberMatchList.containsAll(expected));
        memberMatches = this.getFixture().getContainedTypes((EObject)this.cDepartment, EmployeePackage.eINSTANCE.getDepartment_Members(), this.getClientContext());
        memberMatchList = Arrays.asList(memberMatches);
        expected = Arrays.asList(EmployeeType.CONTEXT_EMPLOYEE, EmployeeType.CONTEXT_STUDENT, EmployeeType.CONTEXT_TOP_SECRET);
        ElementTypeRegistryTest.assertEquals((int)expected.size(), (int)memberMatches.length);
        ElementTypeRegistryTest.assertTrue((boolean)memberMatchList.containsAll(expected));
    }

    public void test_getContainedTypes_metamodelAndSpecializations_departmentMembers_unboundContext() {
        IElementType[] memberMatches = this.getFixture().getContainedTypes((EObject)this.cDepartment, EmployeePackage.eINSTANCE.getDepartment_Members(), this.getUnboundClientContext());
        ElementTypeRegistryTest.assertEquals((int)0, (int)memberMatches.length);
    }

    public void test_getContainedTypes_metamodelAndSpecializations_departmentManager() {
        IElementType[] managerMatches = this.getFixture().getContainedTypes((EObject)this.department, EmployeePackage.eINSTANCE.getDepartment_Manager());
        List<IElementType> managerMatchList = Arrays.asList(managerMatches);
        List<Object> expected = Arrays.asList(EmployeeType.EMPLOYEE, EmployeeType.STUDENT, EmployeeType.HIGH_SCHOOL_STUDENT, EmployeeType.MANAGER, EmployeeType.EXECUTIVE, EmployeeType.TOP_SECRET);
        ElementTypeRegistryTest.assertEquals((int)expected.size(), (int)managerMatches.length);
        ElementTypeRegistryTest.assertTrue((boolean)managerMatchList.containsAll(expected));
    }

    public void test_getContainedTypes_metamodelAndSpecializations_departmentManager_withContext() {
        IElementType[] managerMatches = this.getFixture().getContainedTypes((EObject)this.cDepartment, EmployeePackage.eINSTANCE.getDepartment_Manager());
        List<IElementType> managerMatchList = Arrays.asList(managerMatches);
        List<Object> expected = Arrays.asList(EmployeeType.CONTEXT_EMPLOYEE, EmployeeType.CONTEXT_STUDENT, EmployeeType.CONTEXT_MANAGER, EmployeeType.CONTEXT_EXECUTIVE, EmployeeType.CONTEXT_TOP_SECRET);
        ElementTypeRegistryTest.assertEquals((int)expected.size(), (int)managerMatches.length);
        ElementTypeRegistryTest.assertTrue((boolean)managerMatchList.containsAll(expected));
        managerMatches = this.getFixture().getContainedTypes((EObject)this.cDepartment, EmployeePackage.eINSTANCE.getDepartment_Manager(), this.getClientContext());
        managerMatchList = Arrays.asList(managerMatches);
        expected = Arrays.asList(EmployeeType.CONTEXT_EMPLOYEE, EmployeeType.CONTEXT_STUDENT, EmployeeType.CONTEXT_MANAGER, EmployeeType.CONTEXT_EXECUTIVE, EmployeeType.CONTEXT_TOP_SECRET);
        ElementTypeRegistryTest.assertEquals((int)expected.size(), (int)managerMatches.length);
        ElementTypeRegistryTest.assertTrue((boolean)managerMatchList.containsAll(expected));
    }

    public void test_getContainedTypes_metamodelAndSpecializations_departmentManager_unboundContext() {
        IElementType[] managerMatches = this.getFixture().getContainedTypes((EObject)this.cDepartment, EmployeePackage.eINSTANCE.getDepartment_Manager(), this.getUnboundClientContext());
        ElementTypeRegistryTest.assertEquals((int)0, (int)managerMatches.length);
    }

    public void test_getEditHelperAdvice_noAdvice() {
        IEditHelperAdvice[] advice = this.getNonWildcardAdvice(this.studentOffice);
        ElementTypeRegistryTest.assertEquals((int)0, (int)advice.length);
    }

    public void test_getEditHelperAdvice_noAdvice_withContext() {
        IEditHelperAdvice[] advice = this.getNonWildcardAdvice(this.cStudentOffice);
        ElementTypeRegistryTest.assertEquals((int)0, (int)advice.length);
        advice = this.getNonWildcardAdvice(this.cStudentOffice, this.getClientContext());
        ElementTypeRegistryTest.assertEquals((int)0, (int)advice.length);
    }

    public void test_getEditHelperAdvice_noAdvice_unboundContext() {
        IEditHelperAdvice[] advice = this.getNonWildcardAdvice(this.cStudentOffice, this.getUnboundClientContext());
        ElementTypeRegistryTest.assertEquals((int)0, (int)advice.length);
    }

    public void test_getEditHelperAdvice_eObject_directAdvice() {
        IEditHelperAdvice[] advice = this.getNonWildcardAdvice(this.financeEmployee);
        ElementTypeRegistryTest.assertEquals((int)2, (int)advice.length);
        int i = 0;
        while (i < advice.length) {
            Class<?> clazz = advice[i].getClass();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.FinanceEditHelperAdvice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                Class<?> clazz3 = advice[i].getClass();
                Class<?> clazz4 = class$2;
                if (clazz4 == null) {
                    try {
                        clazz4 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.NotInheritedEditHelperAdvice");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3 != clazz4) {
                    ElementTypeRegistryTest.fail((String)"expected finance and not inherited helper advice");
                }
            }
            ++i;
        }
    }

    public void test_getEditHelperAdvice_eObject_directAdvice_withContext() {
        IEditHelperAdvice[] advice = this.getNonWildcardAdvice(this.cFinanceEmployee);
        ElementTypeRegistryTest.assertEquals((int)2, (int)advice.length);
        int i = 0;
        while (i < advice.length) {
            Class<?> clazz = advice[i].getClass();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.FinanceEditHelperAdvice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                Class<?> clazz3 = advice[i].getClass();
                Class<?> clazz4 = class$2;
                if (clazz4 == null) {
                    try {
                        clazz4 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.NotInheritedEditHelperAdvice");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3 != clazz4) {
                    ElementTypeRegistryTest.fail((String)"expected finance and not inherited helper advice");
                }
            }
            ++i;
        }
        advice = this.getNonWildcardAdvice(this.cFinanceEmployee, this.getClientContext());
        ElementTypeRegistryTest.assertEquals((int)2, (int)advice.length);
        i = 0;
        while (i < advice.length) {
            Class<?> clazz = advice[i].getClass();
            Class<?> clazz5 = class$1;
            if (clazz5 == null) {
                try {
                    clazz5 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.FinanceEditHelperAdvice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz5) {
                Class<?> clazz6 = advice[i].getClass();
                Class<?> clazz7 = class$2;
                if (clazz7 == null) {
                    try {
                        clazz7 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.NotInheritedEditHelperAdvice");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz6 != clazz7) {
                    ElementTypeRegistryTest.fail((String)"expected finance and not inherited helper advice");
                }
            }
            ++i;
        }
    }

    public void test_getEditHelperAdvice_eObject_directAdvice_unboundContext() {
        IEditHelperAdvice[] advice = this.getNonWildcardAdvice(this.cFinanceEmployee, this.getUnboundClientContext());
        ElementTypeRegistryTest.assertEquals((int)0, (int)advice.length);
    }

    public void test_getEditHelperAdvice_eObject_indirectAdvice() {
        IEditHelperAdvice[] advice = this.getNonWildcardAdvice(this.financeManager);
        ElementTypeRegistryTest.assertEquals((int)3, (int)advice.length);
        int i = 0;
        while (i < advice.length) {
            Class<?> clazz = advice[i].getClass();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.FinanceEditHelperAdvice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                Class<?> clazz3 = advice[i].getClass();
                Class<?> clazz4 = class$3;
                if (clazz4 == null) {
                    try {
                        clazz4 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.ManagerEditHelperAdvice");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3 != clazz4) {
                    Class<?> clazz5 = advice[i].getClass();
                    Class<?> clazz6 = class$2;
                    if (clazz6 == null) {
                        try {
                            clazz6 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.NotInheritedEditHelperAdvice");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz5 != clazz6) {
                        ElementTypeRegistryTest.fail((String)"expected finance, manager and not inherited edit helper advice");
                    }
                }
            }
            ++i;
        }
    }

    public void test_getEditHelperAdvice_eObject_indirectAdvice_withContext() {
        IEditHelperAdvice[] advice = this.getNonWildcardAdvice(this.cFinanceManager);
        ElementTypeRegistryTest.assertEquals((int)3, (int)advice.length);
        int i = 0;
        while (i < advice.length) {
            Class<?> clazz = advice[i].getClass();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.FinanceEditHelperAdvice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                Class<?> clazz3 = advice[i].getClass();
                Class<?> clazz4 = class$3;
                if (clazz4 == null) {
                    try {
                        clazz4 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.ManagerEditHelperAdvice");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3 != clazz4) {
                    Class<?> clazz5 = advice[i].getClass();
                    Class<?> clazz6 = class$2;
                    if (clazz6 == null) {
                        try {
                            clazz6 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.NotInheritedEditHelperAdvice");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz5 != clazz6) {
                        ElementTypeRegistryTest.fail((String)"expected finance, manager and not inherited edit helper advice");
                    }
                }
            }
            ++i;
        }
        advice = this.getNonWildcardAdvice(this.cFinanceManager, this.getClientContext());
        ElementTypeRegistryTest.assertEquals((int)3, (int)advice.length);
        i = 0;
        while (i < advice.length) {
            Class<?> clazz = advice[i].getClass();
            Class<?> clazz7 = class$1;
            if (clazz7 == null) {
                try {
                    clazz7 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.FinanceEditHelperAdvice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz7) {
                Class<?> clazz8 = advice[i].getClass();
                Class<?> clazz9 = class$3;
                if (clazz9 == null) {
                    try {
                        clazz9 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.ManagerEditHelperAdvice");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz8 != clazz9) {
                    Class<?> clazz10 = advice[i].getClass();
                    Class<?> clazz11 = class$2;
                    if (clazz11 == null) {
                        try {
                            clazz11 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.NotInheritedEditHelperAdvice");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz10 != clazz11) {
                        ElementTypeRegistryTest.fail((String)"expected finance, manager and not inherited edit helper advice");
                    }
                }
            }
            ++i;
        }
    }

    public void test_getEditHelperAdvice_eObject_indirectAdvice_unboundContext() {
        IEditHelperAdvice[] advice = this.getNonWildcardAdvice(this.cFinanceManager, this.getUnboundClientContext());
        ElementTypeRegistryTest.assertEquals((int)0, (int)advice.length);
    }

    public void test_getEditHelperAdvice_elementType_directMatch() {
        IEditHelperAdvice[] advice = this.getNonWildcardAdvice((IElementType)EmployeeType.EMPLOYEE);
        ElementTypeRegistryTest.assertEquals((int)2, (int)advice.length);
        int i = 0;
        while (i < advice.length) {
            Class<?> clazz = advice[i].getClass();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.FinanceEditHelperAdvice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                Class<?> clazz3 = advice[i].getClass();
                Class<?> clazz4 = class$2;
                if (clazz4 == null) {
                    try {
                        clazz4 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.NotInheritedEditHelperAdvice");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3 != clazz4) {
                    ElementTypeRegistryTest.fail((String)"expected finance and notInherited edit helper advice");
                }
            }
            ++i;
        }
    }

    public void test_getEditHelperAdvice_elementType_directMatch_withContext() {
        IEditHelperAdvice[] advice = this.getNonWildcardAdvice((IElementType)EmployeeType.CONTEXT_EMPLOYEE);
        ElementTypeRegistryTest.assertEquals((int)2, (int)advice.length);
        int i = 0;
        while (i < advice.length) {
            Class<?> clazz = advice[i].getClass();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.FinanceEditHelperAdvice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                Class<?> clazz3 = advice[i].getClass();
                Class<?> clazz4 = class$2;
                if (clazz4 == null) {
                    try {
                        clazz4 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.NotInheritedEditHelperAdvice");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3 != clazz4) {
                    ElementTypeRegistryTest.fail((String)"expected finance and notInherited edit helper advice");
                }
            }
            ++i;
        }
        advice = this.getNonWildcardAdvice((IElementType)EmployeeType.CONTEXT_EMPLOYEE, this.getClientContext());
        ElementTypeRegistryTest.assertEquals((int)2, (int)advice.length);
        i = 0;
        while (i < advice.length) {
            Class<?> clazz = advice[i].getClass();
            Class<?> clazz5 = class$1;
            if (clazz5 == null) {
                try {
                    clazz5 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.FinanceEditHelperAdvice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz5) {
                Class<?> clazz6 = advice[i].getClass();
                Class<?> clazz7 = class$2;
                if (clazz7 == null) {
                    try {
                        clazz7 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.NotInheritedEditHelperAdvice");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz6 != clazz7) {
                    ElementTypeRegistryTest.fail((String)"expected finance and notInherited edit helper advice");
                }
            }
            ++i;
        }
    }

    public void test_getEditHelperAdvice_elementType_directMatch_unboundContext() {
        IEditHelperAdvice[] advice = this.getNonWildcardAdvice((IElementType)EmployeeType.CONTEXT_EMPLOYEE, this.getUnboundClientContext());
        ElementTypeRegistryTest.assertEquals((int)0, (int)advice.length);
    }

    public void test_getEditHelperAdvice_elementType_inheritedMatches() {
        IEditHelperAdvice[] advice = this.getNonWildcardAdvice((IElementType)EmployeeType.EXECUTIVE);
        ElementTypeRegistryTest.assertEquals((int)4, (int)advice.length);
        int i = 0;
        while (i < advice.length) {
            Class<?> clazz = advice[i].getClass();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.FinanceEditHelperAdvice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                Class<?> clazz3 = advice[i].getClass();
                Class<?> clazz4 = class$3;
                if (clazz4 == null) {
                    try {
                        clazz4 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.ManagerEditHelperAdvice");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3 != clazz4) {
                    Class<?> clazz5 = advice[i].getClass();
                    Class<?> clazz6 = class$4;
                    if (clazz6 == null) {
                        try {
                            clazz6 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.ExecutiveEditHelperAdvice");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz5 != clazz6) {
                        Class<?> clazz7 = advice[i].getClass();
                        Class<?> clazz8 = class$2;
                        if (clazz8 == null) {
                            try {
                                clazz8 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.NotInheritedEditHelperAdvice");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz7 != clazz8) {
                            ElementTypeRegistryTest.fail((String)"expected finance, manager, executive and not-inherited edit helper advice");
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void test_getEditHelperAdvice_elementType_inheritedMatches_withContext() {
        IEditHelperAdvice[] advice = this.getNonWildcardAdvice((IElementType)EmployeeType.CONTEXT_EXECUTIVE);
        ElementTypeRegistryTest.assertEquals((int)4, (int)advice.length);
        int i = 0;
        while (i < advice.length) {
            Class<?> clazz = advice[i].getClass();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.FinanceEditHelperAdvice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                Class<?> clazz3 = advice[i].getClass();
                Class<?> clazz4 = class$3;
                if (clazz4 == null) {
                    try {
                        clazz4 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.ManagerEditHelperAdvice");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3 != clazz4) {
                    Class<?> clazz5 = advice[i].getClass();
                    Class<?> clazz6 = class$4;
                    if (clazz6 == null) {
                        try {
                            clazz6 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.ExecutiveEditHelperAdvice");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz5 != clazz6) {
                        Class<?> clazz7 = advice[i].getClass();
                        Class<?> clazz8 = class$2;
                        if (clazz8 == null) {
                            try {
                                clazz8 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.NotInheritedEditHelperAdvice");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz7 != clazz8) {
                            ElementTypeRegistryTest.fail((String)"expected finance, manager, executive and not-inherited edit helper advice");
                        }
                    }
                }
            }
            ++i;
        }
        advice = this.getNonWildcardAdvice((IElementType)EmployeeType.CONTEXT_EXECUTIVE, this.getClientContext());
        ElementTypeRegistryTest.assertEquals((int)4, (int)advice.length);
        i = 0;
        while (i < advice.length) {
            Class<?> clazz = advice[i].getClass();
            Class<?> clazz9 = class$1;
            if (clazz9 == null) {
                try {
                    clazz9 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.FinanceEditHelperAdvice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz9) {
                Class<?> clazz10 = advice[i].getClass();
                Class<?> clazz11 = class$3;
                if (clazz11 == null) {
                    try {
                        clazz11 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.ManagerEditHelperAdvice");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz10 != clazz11) {
                    Class<?> clazz12 = advice[i].getClass();
                    Class<?> clazz13 = class$4;
                    if (clazz13 == null) {
                        try {
                            clazz13 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.ExecutiveEditHelperAdvice");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz12 != clazz13) {
                        Class<?> clazz14 = advice[i].getClass();
                        Class<?> clazz15 = class$2;
                        if (clazz15 == null) {
                            try {
                                clazz15 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.NotInheritedEditHelperAdvice");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz14 != clazz15) {
                            ElementTypeRegistryTest.fail((String)"expected finance, manager, executive and not-inherited edit helper advice");
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void test_getEditHelperAdvice_elementType_inheritedMatches_unboundContext() {
        IEditHelperAdvice[] advice = this.getNonWildcardAdvice((IElementType)EmployeeType.CONTEXT_EXECUTIVE, this.getUnboundClientContext());
        ElementTypeRegistryTest.assertEquals((int)0, (int)advice.length);
    }

    public void test_getEditHelperAdvice_elementType_noInheritedMatches() {
        IEditHelperAdvice[] advice = this.getNonWildcardAdvice((IElementType)EmployeeType.STUDENT);
        ElementTypeRegistryTest.assertEquals((int)1, (int)advice.length);
        int i = 0;
        while (i < advice.length) {
            Class<?> clazz = advice[i].getClass();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.FinanceEditHelperAdvice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                ElementTypeRegistryTest.fail((String)"expected finance edit helper advice");
            }
            ++i;
        }
    }

    public void test_getEditHelperAdvice_elementType_noInheritedMatches_withContext() {
        IEditHelperAdvice[] advice = this.getNonWildcardAdvice((IElementType)EmployeeType.CONTEXT_STUDENT);
        ElementTypeRegistryTest.assertEquals((int)1, (int)advice.length);
        int i = 0;
        while (i < advice.length) {
            Class<?> clazz = advice[i].getClass();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.FinanceEditHelperAdvice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                ElementTypeRegistryTest.fail((String)"expected finance edit helper advice");
            }
            ++i;
        }
        advice = this.getNonWildcardAdvice((IElementType)EmployeeType.CONTEXT_STUDENT, this.getClientContext());
        ElementTypeRegistryTest.assertEquals((int)1, (int)advice.length);
        i = 0;
        while (i < advice.length) {
            Class<?> clazz = advice[i].getClass();
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.FinanceEditHelperAdvice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz3) {
                ElementTypeRegistryTest.fail((String)"expected finance edit helper advice");
            }
            ++i;
        }
    }

    public void test_getEditHelperAdvice_elementType_noInheritedMatches_unboundContext() {
        IEditHelperAdvice[] advice = this.getNonWildcardAdvice((IElementType)EmployeeType.CONTEXT_STUDENT, this.getUnboundClientContext());
        ElementTypeRegistryTest.assertEquals((int)0, (int)advice.length);
    }

    public void test_getEditHelperAdvice_editHelperContext_withEObject() {
        EditHelperContext context = new EditHelperContext((EObject)this.cFinanceManager, this.getClientContext());
        IEditHelperAdvice[] advice = this.getNonWildcardAdvice((IEditHelperContext)context);
        ElementTypeRegistryTest.assertEquals((int)3, (int)advice.length);
        int i = 0;
        while (i < advice.length) {
            Class<?> clazz = advice[i].getClass();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.FinanceEditHelperAdvice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                Class<?> clazz3 = advice[i].getClass();
                Class<?> clazz4 = class$3;
                if (clazz4 == null) {
                    try {
                        clazz4 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.ManagerEditHelperAdvice");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3 != clazz4) {
                    Class<?> clazz5 = advice[i].getClass();
                    Class<?> clazz6 = class$2;
                    if (clazz6 == null) {
                        try {
                            clazz6 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.NotInheritedEditHelperAdvice");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz5 != clazz6) {
                        ElementTypeRegistryTest.fail((String)"expected finance, manager and not inherited edit helper advice");
                    }
                }
            }
            ++i;
        }
    }

    public void test_getEditHelperAdvice_editHelperContext_withElementType() {
        EditHelperContext context = new EditHelperContext((IElementType)EmployeeType.CONTEXT_EXECUTIVE, this.getClientContext());
        IEditHelperAdvice[] advice = this.getNonWildcardAdvice((IEditHelperContext)context);
        ElementTypeRegistryTest.assertEquals((int)4, (int)advice.length);
        int i = 0;
        while (i < advice.length) {
            Class<?> clazz = advice[i].getClass();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.FinanceEditHelperAdvice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                Class<?> clazz3 = advice[i].getClass();
                Class<?> clazz4 = class$3;
                if (clazz4 == null) {
                    try {
                        clazz4 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.ManagerEditHelperAdvice");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3 != clazz4) {
                    Class<?> clazz5 = advice[i].getClass();
                    Class<?> clazz6 = class$4;
                    if (clazz6 == null) {
                        try {
                            clazz6 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.ExecutiveEditHelperAdvice");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz5 != clazz6) {
                        Class<?> clazz7 = advice[i].getClass();
                        Class<?> clazz8 = class$2;
                        if (clazz8 == null) {
                            try {
                                clazz8 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.NotInheritedEditHelperAdvice");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz7 != clazz8) {
                            ElementTypeRegistryTest.fail((String)"expected finance, manager, executive and not-inherited edit helper advice");
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void test_getEditHelperAdvice_editHelperContext_noClientContext() {
        EditHelperContext context = new EditHelperContext((IElementType)EmployeeType.CONTEXT_EXECUTIVE, null);
        IEditHelperAdvice[] advice = this.getNonWildcardAdvice((IEditHelperContext)context);
        ElementTypeRegistryTest.assertEquals((int)4, (int)advice.length);
        int i = 0;
        while (i < advice.length) {
            Class<?> clazz = advice[i].getClass();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.FinanceEditHelperAdvice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                Class<?> clazz3 = advice[i].getClass();
                Class<?> clazz4 = class$3;
                if (clazz4 == null) {
                    try {
                        clazz4 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.ManagerEditHelperAdvice");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3 != clazz4) {
                    Class<?> clazz5 = advice[i].getClass();
                    Class<?> clazz6 = class$4;
                    if (clazz6 == null) {
                        try {
                            clazz6 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.ExecutiveEditHelperAdvice");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz5 != clazz6) {
                        Class<?> clazz7 = advice[i].getClass();
                        Class<?> clazz8 = class$2;
                        if (clazz8 == null) {
                            try {
                                clazz8 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.NotInheritedEditHelperAdvice");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz7 != clazz8) {
                            ElementTypeRegistryTest.fail((String)"expected finance, manager, executive and not-inherited edit helper advice");
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void test_getElementTypeFactory_none() {
        IElementTypeFactory factory = this.getFixture().getElementTypeFactory("noName");
        ElementTypeRegistryTest.assertNull((Object)factory);
    }

    public void test_getElementTypeFactory_default() {
        IElementTypeFactory factory = this.getFixture().getElementTypeFactory("org.eclipse.gmf.runtime.emf.type.core.IElementType");
        ElementTypeRegistryTest.assertNotNull((Object)factory);
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.gmf.runtime.emf.type.core.internal.impl.DefaultElementTypeFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ElementTypeRegistryTest.assertEquals((Object)clazz, factory.getClass());
    }

    public void test_getElementTypeFactory_custom() {
        IElementTypeFactory factory = this.getFixture().getElementTypeFactory("org.eclipse.gmf.tests.runtime.emf.type.core.internal.ISecurityCleared");
        ElementTypeRegistryTest.assertNotNull((Object)factory);
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.core.internal.SecurityClearedElementTypeFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ElementTypeRegistryTest.assertEquals((Object)clazz, factory.getClass());
    }

    public void test_getElementType_eClass() {
        IElementType metamodelType = this.getFixture().getElementType(this.getEmployeePackage().getDepartment());
        ElementTypeRegistryTest.assertNotNull((Object)metamodelType);
        ElementTypeRegistryTest.assertEquals((Object)EmployeeType.DEPARTMENT, (Object)metamodelType);
    }

    public void test_getElementType_eClass_withContext() {
        IElementType metamodelType = this.getFixture().getElementType(this.getEmployeePackage().getDepartment(), this.getClientContext());
        ElementTypeRegistryTest.assertNotNull((Object)metamodelType);
        ElementTypeRegistryTest.assertEquals((Object)EmployeeType.CONTEXT_DEPARTMENT, (Object)metamodelType);
    }

    public void test_getElementType_eClass_unboundContext() {
        IElementType metamodelType = this.getFixture().getElementType(this.getEmployeePackage().getDepartment(), this.getUnboundClientContext());
        ElementTypeRegistryTest.assertSame((Object)DefaultMetamodelType.getInstance(), (Object)metamodelType);
    }

    public void test_getElementType_eObject() {
        IElementType metamodelType = this.getFixture().getElementType((EObject)this.financeManager);
        ElementTypeRegistryTest.assertNotNull((Object)metamodelType);
        ElementTypeRegistryTest.assertEquals((Object)EmployeeType.EMPLOYEE, (Object)metamodelType);
    }

    public void test_getElementType_eObject_withContext() {
        IElementType metamodelType = this.getFixture().getElementType((EObject)this.cFinanceManager);
        ElementTypeRegistryTest.assertNotNull((Object)metamodelType);
        ElementTypeRegistryTest.assertEquals((Object)EmployeeType.CONTEXT_EMPLOYEE, (Object)metamodelType);
        metamodelType = this.getFixture().getElementType((EObject)this.cFinanceManager, this.getClientContext());
        ElementTypeRegistryTest.assertNotNull((Object)metamodelType);
        ElementTypeRegistryTest.assertEquals((Object)EmployeeType.CONTEXT_EMPLOYEE, (Object)metamodelType);
    }

    public void test_getElementType_eObject_unboundContext() {
        IElementType metamodelType = this.getFixture().getElementType((EObject)this.cFinanceManager, this.getUnboundClientContext());
        ElementTypeRegistryTest.assertSame((Object)DefaultMetamodelType.getInstance(), (Object)metamodelType);
    }

    public void test_getElementType_eObject_eClass() {
        MetamodelType eClassType = new MetamodelType("dynamic.org.eclipse.gmf.tests.runtime.emf.type.core.eclass", null, null, EcorePackage.eINSTANCE.getEClass(), null);
        this.getClientContext().bindId("dynamic.org.eclipse.gmf.tests.runtime.emf.type.core.eclass");
        boolean wasRegistered = this.getFixture().register((IMetamodelType)eClassType);
        EClass myEClassInstance = EcoreFactory.eINSTANCE.createEClass();
        IElementType metamodelType = this.getFixture().getElementType((EObject)myEClassInstance, this.getClientContext());
        ElementTypeRegistryTest.assertNotNull((Object)metamodelType);
        if (wasRegistered) {
            ElementTypeRegistryTest.assertSame((Object)eClassType, (Object)metamodelType);
        }
    }

    public void test_getElementType_overridesEditHelper() {
        IElementType elementType = this.getFixture().getElementType((Object)EmployeeType.TOP_SECRET);
        ElementTypeRegistryTest.assertNotNull((Object)elementType);
        ElementTypeRegistryTest.assertEquals((Object)EmployeeType.TOP_SECRET, (Object)elementType);
        ElementTypeRegistryTest.assertTrue((boolean)(elementType.getEditHelper() instanceof SecurityClearedElementTypeFactory.SecurityClearedEditHelper));
    }

    public void test_getElementType_overridesEditHelper_withContext() {
        IElementType elementType = this.getFixture().getElementType((Object)EmployeeType.CONTEXT_TOP_SECRET);
        ElementTypeRegistryTest.assertNotNull((Object)elementType);
        ElementTypeRegistryTest.assertEquals((Object)EmployeeType.CONTEXT_TOP_SECRET, (Object)elementType);
        ElementTypeRegistryTest.assertTrue((boolean)(elementType.getEditHelper() instanceof SecurityClearedElementTypeFactory.SecurityClearedEditHelper));
    }

    public void test_getElementType_metamodelType() {
        IElementType metamodelType = this.getFixture().getElementType((Object)EmployeeType.STUDENT);
        ElementTypeRegistryTest.assertNotNull((Object)metamodelType);
        ElementTypeRegistryTest.assertEquals((Object)EmployeeType.STUDENT, (Object)metamodelType);
    }

    public void test_getElementType_metamodelType_withContext() {
        IElementType metamodelType = this.getFixture().getElementType((Object)EmployeeType.CONTEXT_STUDENT);
        ElementTypeRegistryTest.assertNotNull((Object)metamodelType);
        ElementTypeRegistryTest.assertEquals((Object)EmployeeType.CONTEXT_STUDENT, (Object)metamodelType);
    }

    public void test_getElementType_specializationType() {
        IElementType specializationType = this.getFixture().getElementType((Object)EmployeeType.MANAGER);
        ElementTypeRegistryTest.assertNotNull((Object)specializationType);
        ElementTypeRegistryTest.assertEquals((Object)EmployeeType.MANAGER, (Object)specializationType);
    }

    public void test_getElementType_specializationType_withContext() {
        IElementType specializationType = this.getFixture().getElementType((Object)EmployeeType.CONTEXT_MANAGER);
        ElementTypeRegistryTest.assertNotNull((Object)specializationType);
        ElementTypeRegistryTest.assertEquals((Object)EmployeeType.CONTEXT_MANAGER, (Object)specializationType);
    }

    public void test_getElementType_editHelperContext_withEObject() {
        EditHelperContext context = new EditHelperContext((EObject)this.cFinanceManager, this.getClientContext());
        IElementType type = this.getFixture().getElementType((Object)context);
        ElementTypeRegistryTest.assertNotNull((Object)type);
        ElementTypeRegistryTest.assertEquals((Object)EmployeeType.CONTEXT_EMPLOYEE, (Object)type);
    }

    public void test_getElementType_editHelperContext_withElementType() {
        EditHelperContext context = new EditHelperContext((IElementType)EmployeeType.CONTEXT_STUDENT, ClientContextManager.getDefaultClientContext());
        IElementType type = this.getFixture().getElementType((Object)context);
        ElementTypeRegistryTest.assertNotNull((Object)type);
        ElementTypeRegistryTest.assertEquals((Object)EmployeeType.CONTEXT_STUDENT, (Object)type);
    }

    public void test_getElementType_editHelperContext_noClientContext() {
        EditHelperContext context = new EditHelperContext((EObject)this.financeManager, null);
        IElementType type = this.getFixture().getElementType((Object)context);
        ElementTypeRegistryTest.assertNotNull((Object)type);
        ElementTypeRegistryTest.assertEquals((Object)EmployeeType.EMPLOYEE, (Object)type);
    }

    public void test_getType_metamodel() {
        IElementType studentType = this.getFixture().getType(EmployeeType.STUDENT.getId());
        ElementTypeRegistryTest.assertNotNull((Object)studentType);
        ElementTypeRegistryTest.assertEquals((String)EmployeeType.STUDENT.getId(), (String)studentType.getId());
    }

    public void test_getType_specialization() {
        IElementType managerType = this.getFixture().getType(EmployeeType.MANAGER.getId());
        ElementTypeRegistryTest.assertNotNull((Object)managerType);
        ElementTypeRegistryTest.assertEquals((String)EmployeeType.MANAGER.getId(), (String)managerType.getId());
    }

    public void test_duplicateId_notRegistered() {
        IElementType employeeType = this.getFixture().getType("org.eclipse.gmf.tests.runtime.emf.type.core.employee");
        ElementTypeRegistryTest.assertFalse((boolean)employeeType.getDisplayName().equals("DuplicateEmployee"));
    }

    public void test_duplicateEClass_notRegistered() {
        IElementType employeeType = this.getFixture().getType("org.eclipse.gmf.tests.runtime.emf.type.ui.employee2");
        ElementTypeRegistryTest.assertNull((Object)employeeType);
    }

    public void test_multipleMetatmodelTypes_notRegistered() {
        IElementType employeeType = this.getFixture().getType("org.eclipse.gmf.tests.runtime.emf.type.ui.multipleMetamodelTypes");
        ElementTypeRegistryTest.assertNull((Object)employeeType);
    }

    public void test_noSuchType_notRegistered() {
        IElementType employeeType = this.getFixture().getType("org.eclipse.gmf.tests.runtime.emf.type.ui.SpecializesNoSuchType");
        ElementTypeRegistryTest.assertNull((Object)employeeType);
    }

    public void test_invalidMetatmodel_notRegistered() {
        IElementType employeeType = this.getFixture().getType("org.eclipse.gmf.tests.runtime.emf.type.ui.noMetamodel");
        ElementTypeRegistryTest.assertNull((Object)employeeType);
    }

    public void test_register_specializationType() {
        MySpecializationAdvice specialAdvice = new MySpecializationAdvice();
        String id = "dynamic.specialization.type";
        SpecializationType dynamicSpecializationType = new SpecializationType(id, null, id, new IElementType[]{EmployeeType.EMPLOYEE}, null, null, (IEditHelperAdvice)specialAdvice);
        final boolean[] listenerNotified = new boolean[1];
        IElementTypeRegistryListener listener = new IElementTypeRegistryListener((ISpecializationType)dynamicSpecializationType){
            private final /* synthetic */ ISpecializationType val$dynamicSpecializationType;
            {
                this.val$dynamicSpecializationType = iSpecializationType;
            }

            public void elementTypeAdded(ElementTypeAddedEvent elementTypeAddedEvent) {
                listenerNotified[0] = true;
                ElementTypeRegistryTest.assertEquals((String)this.val$dynamicSpecializationType.getId(), (String)elementTypeAddedEvent.getElementTypeId());
            }
        };
        ElementTypeRegistry.getInstance().addElementTypeRegistryListener(listener);
        boolean result = ElementTypeRegistry.getInstance().register((ISpecializationType)dynamicSpecializationType);
        ElementTypeRegistryTest.assertTrue((boolean)result);
        ElementTypeRegistryTest.assertTrue((boolean)listenerNotified[0]);
        ElementTypeRegistryTest.assertSame((Object)dynamicSpecializationType, (Object)this.getFixture().getType(id));
        IEditHelperAdvice[] advice = this.getFixture().getEditHelperAdvice((IElementType)dynamicSpecializationType);
        ElementTypeRegistryTest.assertTrue((boolean)Arrays.asList(advice).contains((Object)specialAdvice));
        ElementTypeRegistry.getInstance().removeElementTypeRegistryListener(listener);
    }

    public void test_register_metamodelType() {
        String id = "dynamic.metamodel.type";
        MetamodelType dynamicMetamodelType = new MetamodelType(id, null, id, EmployeePackage.eINSTANCE.getLocation(), null);
        final boolean[] listenerNotified = new boolean[1];
        IElementTypeRegistryListener listener = new IElementTypeRegistryListener((IMetamodelType)dynamicMetamodelType){
            private final /* synthetic */ IMetamodelType val$dynamicMetamodelType;
            {
                this.val$dynamicMetamodelType = iMetamodelType;
            }

            public void elementTypeAdded(ElementTypeAddedEvent elementTypeAddedEvent) {
                listenerNotified[0] = true;
                ElementTypeRegistryTest.assertEquals((String)this.val$dynamicMetamodelType.getId(), (String)elementTypeAddedEvent.getElementTypeId());
            }
        };
        ElementTypeRegistry.getInstance().addElementTypeRegistryListener(listener);
        boolean result = ElementTypeRegistry.getInstance().register((IMetamodelType)dynamicMetamodelType);
        ElementTypeRegistryTest.assertTrue((boolean)result);
        ElementTypeRegistryTest.assertTrue((boolean)listenerNotified[0]);
        ElementTypeRegistryTest.assertSame((Object)dynamicMetamodelType, (Object)ElementTypeRegistry.getInstance().getType(id));
        ElementTypeRegistry.getInstance().removeElementTypeRegistryListener(listener);
    }

    public void test_nullElementType_specialization() {
        IElementType nullSpecialization = this.getFixture().getType("org.eclipse.gmf.tests.runtime.emf.type.core.nullSpecialization");
        ElementTypeRegistryTest.assertNotNull((Object)nullSpecialization);
        RecordingCommand recordingCommand = new RecordingCommand(this.getEditingDomain()){

            protected void doExecute() {
                ElementTypeRegistryTest.this.department.setManager(null);
            }
        };
        try {
            ((TransactionalCommandStack)this.getEditingDomain().getCommandStack()).execute((Command)recordingCommand, null);
        }
        catch (RollbackException re) {
            ElementTypeRegistryTest.fail((String)("setUp() failed:" + re.getLocalizedMessage()));
        }
        catch (InterruptedException ie) {
            ElementTypeRegistryTest.fail((String)("setUp() failed:" + ie.getLocalizedMessage()));
        }
        ElementTypeRegistryTest.assertNull((Object)this.department.getManager());
        CreateElementRequest createRequest = new CreateElementRequest(this.getEditingDomain(), (EObject)this.department, nullSpecialization);
        createRequest.setParameter("MANAGER", (Object)this.manager);
        IElementType elementType = ElementTypeRegistry.getInstance().getElementType(createRequest.getEditHelperContext());
        ICommand command = elementType.getEditCommand((IEditCommandRequest)createRequest);
        ElementTypeRegistryTest.assertNotNull((Object)command);
        ElementTypeRegistryTest.assertTrue((boolean)command.canExecute());
        try {
            command.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            ElementTypeRegistryTest.fail((String)e.getLocalizedMessage());
        }
        ElementTypeRegistryTest.assertSame((Object)this.manager, (Object)this.department.getManager());
        ElementTypeRegistryTest.assertNull((Object)command.getCommandResult().getReturnValue());
    }

    public void test_getAllTypesMatching_146097() {
        IElementType[] superTypes = EmployeeType.HIGH_SCHOOL_STUDENT.getAllSuperTypes();
        ElementTypeRegistryTest.assertEquals((int)2, (int)superTypes.length);
        ElementTypeRegistryTest.assertEquals((Object)superTypes[0], (Object)EmployeeType.EMPLOYEE);
        ElementTypeRegistryTest.assertEquals((Object)superTypes[1], (Object)EmployeeType.STUDENT);
        IElementType[] highSchoolStudentMatches = this.getFixture().getAllTypesMatching((EObject)this.highSchoolStudent);
        ElementTypeRegistryTest.assertTrue((highSchoolStudentMatches.length == 3 ? 1 : 0) != 0);
        ElementTypeRegistryTest.assertTrue((highSchoolStudentMatches[0] == EmployeeType.HIGH_SCHOOL_STUDENT ? 1 : 0) != 0);
        ElementTypeRegistryTest.assertTrue((highSchoolStudentMatches[1] == EmployeeType.STUDENT ? 1 : 0) != 0);
        ElementTypeRegistryTest.assertTrue((highSchoolStudentMatches[2] == EmployeeType.EMPLOYEE ? 1 : 0) != 0);
        ElementTypeRegistryTest.assertEquals((Object)superTypes[0], (Object)EmployeeType.EMPLOYEE);
        ElementTypeRegistryTest.assertEquals((Object)superTypes[1], (Object)EmployeeType.STUDENT);
    }

    private class MySpecializationAdvice
    extends AbstractEditHelperAdvice {
        protected ICommand getBeforeCreateCommand(CreateElementRequest request) {
            return super.getBeforeCreateCommand(request);
        }
    }
}

