/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.internal.descriptors;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IElementTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePluginStatusCodes;
import org.eclipse.gmf.runtime.emf.type.core.internal.l10n.EMFTypeCoreMessages;
import org.osgi.framework.Bundle;

public abstract class ElementTypeDescriptor
implements IElementTypeDescriptor {
    private IConfigurationElement configElement;
    private final String id;
    private String name;
    private URL iconURL;
    private String kindName;
    private final Map params = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.ElementTypeDescriptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected ElementTypeDescriptor(IElementType elementType) {
        this.id = elementType.getId();
        this.iconURL = elementType.getIconURL();
        this.name = elementType.getDisplayName();
    }

    protected ElementTypeDescriptor(IConfigurationElement configElement) throws CoreException {
        String pluginId;
        if (!$assertionsDisabled && configElement == null) {
            throw new AssertionError();
        }
        this.configElement = configElement;
        this.id = configElement.getAttribute("id");
        if (this.id == null) {
            throw EMFTypePluginStatusCodes.getTypeInitException("", EMFTypeCoreMessages.type_reason_no_id_WARN_, null);
        }
        this.name = configElement.getAttribute("name");
        String imageFilePath = configElement.getAttribute("icon");
        if (imageFilePath != null && (pluginId = configElement.getDeclaringExtension().getContributor().getName()) != null) {
            this.iconURL = this.getUrlFromPlugin(pluginId, imageFilePath);
        }
        this.kindName = configElement.getAttribute("kind");
        if (this.kindName == null || this.kindName.length() < 1) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.gmf.runtime.emf.type.core.IElementType");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.kindName = clazz.getName();
        }
        IConfigurationElement[] paramConfigElements = configElement.getChildren("param");
        int i = 0;
        while (i < paramConfigElements.length) {
            IConfigurationElement nextParamConfig = paramConfigElements[i];
            String paramName = nextParamConfig.getAttribute("name");
            if (paramName == null) {
                throw EMFTypePluginStatusCodes.getTypeInitException(this.getId(), EMFTypeCoreMessages.type_reason_no_param_name_WARN_, null);
            }
            String paramValue = nextParamConfig.getAttribute("value");
            if (paramValue == null) {
                throw EMFTypePluginStatusCodes.getTypeInitException(this.getId(), EMFTypeCoreMessages.type_reason_no_param_value_WARN_, null);
            }
            this.params.put(paramName, paramValue);
            ++i;
        }
    }

    private URL getUrlFromPlugin(String pluginId, String imageFilePath) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        URL result = bundle.getEntry(imageFilePath);
        if (result == null) {
            try {
                result = new URL(imageFilePath);
            }
            catch (MalformedURLException malformedURLException) {
                result = null;
            }
        }
        return result;
    }

    public String getId() {
        return this.id;
    }

    public URL getIconURL() {
        return this.iconURL;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getKindName() {
        return this.kindName;
    }

    public IConfigurationElement getConfigElement() {
        return this.configElement;
    }

    public abstract IElementType getElementType();

    public String getParamValue(String paramName) {
        return (String)this.params.get(paramName);
    }
}

