/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.action.AbstractContributionItem;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public abstract class CustomContributionItem
extends AbstractContributionItem {
    private Request targetRequest;
    private List _operationSet = Collections.EMPTY_LIST;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CustomContributionItem(IWorkbenchPage workbenchPage, String id) {
        super(workbenchPage, id);
    }

    public void dispose() {
        this.targetRequest = null;
        this._operationSet = null;
        super.dispose();
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        this.updateTargetRequest();
        this.execute(this.getCommand(), progressMonitor);
    }

    public void refresh() {
        this._operationSet = null;
        this.updateTargetRequest();
        super.refresh();
    }

    protected boolean calculateEnabled() {
        Command command = this.getCommand();
        return command != null && command.canExecute();
    }

    protected final void execute(Command command, IProgressMonitor progressMonitor) {
        if (command == null || !command.canExecute()) {
            return;
        }
        if (this.getDiagramCommandStack() != null) {
            this.getDiagramCommandStack().execute(command, progressMonitor);
        }
    }

    protected DiagramCommandStack getDiagramCommandStack() {
        Object stack;
        IWorkbenchPart iWorkbenchPart = this.getWorkbenchPart();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.commands.CommandStack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (stack = iWorkbenchPart.getAdapter((Class)clazz)) instanceof DiagramCommandStack ? (DiagramCommandStack)((Object)stack) : null;
    }

    protected Command getCommand() {
        return this.getCommand(this.getTargetRequest());
    }

    protected Command getCommand(Request request) {
        List operationSet = this.getOperationSet();
        Iterator editParts = operationSet.iterator();
        CompoundCommand command = new CompoundCommand(this.getCommandLabel());
        while (editParts.hasNext()) {
            EditPart editPart = (EditPart)editParts.next();
            Command curCommand = editPart.getCommand(request);
            if (curCommand == null) continue;
            command.add(curCommand);
        }
        return command.isEmpty() || command.size() != operationSet.size() ? UnexecutableCommand.INSTANCE : command;
    }

    protected String getCommandLabel() {
        return null;
    }

    protected Request getTargetRequest() {
        if (this.targetRequest == null) {
            this.targetRequest = this.createTargetRequest();
        }
        return this.targetRequest;
    }

    protected abstract Request createTargetRequest();

    protected void updateTargetRequest() {
    }

    protected List getSelectedObjects() {
        return this.getStructuredSelection().toList();
    }

    protected final List getOperationSet() {
        if (this._operationSet == null) {
            this._operationSet = this.createOperationSet();
            if (this._operationSet == null) {
                this._operationSet = Collections.EMPTY_LIST;
            }
        }
        return this._operationSet;
    }

    protected List createOperationSet() {
        List selection = this.getSelectedObjects();
        if (selection.isEmpty() || !(selection.get(0) instanceof IGraphicalEditPart)) {
            return Collections.EMPTY_LIST;
        }
        Iterator selectedEPs = selection.iterator();
        ArrayList targetedEPs = new ArrayList();
        while (selectedEPs.hasNext()) {
            EditPart selectedEP = (EditPart)selectedEPs.next();
            targetedEPs.addAll(this.getTargetEditParts(selectedEP));
        }
        return targetedEPs.isEmpty() ? Collections.EMPTY_LIST : targetedEPs;
    }

    protected List getTargetEditParts(EditPart editpart) {
        EditPart targetEP = editpart.getTargetEditPart(this.getTargetRequest());
        return targetEP == null ? Collections.EMPTY_LIST : Collections.singletonList(targetEP);
    }

    protected IDiagramEditDomain getDiagramEditDomain() {
        IWorkbenchPart iWorkbenchPart = this.getWorkbenchPart();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IDiagramEditDomain)iWorkbenchPart.getAdapter((Class)clazz);
    }

    protected IDiagramWorkbenchPart getDiagramWorkbenchPart() {
        return this.getWorkbenchPart() instanceof IDiagramWorkbenchPart ? (IDiagramWorkbenchPart)this.getWorkbenchPart() : null;
    }

    protected DiagramEditPart getDiagramEditPart() {
        IDiagramWorkbenchPart editor = this.getDiagramWorkbenchPart();
        return editor != null ? editor.getDiagramEditPart() : null;
    }

    protected IDiagramGraphicalViewer getDiagramGraphicalViewer() {
        IDiagramWorkbenchPart part = this.getDiagramWorkbenchPart();
        return part != null ? part.getDiagramGraphicalViewer() : null;
    }

    protected List filterEditPartsMatching(List list, EditPartViewer.Conditional condition) {
        ArrayList<EditPart> matchList = new ArrayList<EditPart>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            EditPart ep = (EditPart)iter.next();
            if (!condition.evaluate(ep)) continue;
            matchList.add(ep);
        }
        return matchList;
    }
}

