/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.figures;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ScalableFreeformLayeredPane;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;

public class BorderItemContainerFigure
extends NodeFigure {
    private Rectangle extendedBounds = new Rectangle();

    protected void paintClientArea(Graphics graphics) {
        if (this.getChildren().isEmpty() || !this.isVisible()) {
            return;
        }
        Rectangle clip = this.getParentRectangle();
        graphics.setClip(clip);
        graphics.pushState();
        this.paintChildren(graphics);
        graphics.popState();
        graphics.restoreState();
    }

    public Rectangle getHandleBounds() {
        Rectangle handleRect = null;
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            Object object = listIterator.next();
            if (!(object instanceof NodeFigure) || !((NodeFigure)object).isVisible()) continue;
            if (handleRect == null) {
                handleRect = ((NodeFigure)object).getHandleBounds().getCopy();
                continue;
            }
            handleRect.union(((NodeFigure)object).getHandleBounds().getCopy());
        }
        return handleRect;
    }

    public boolean containsPoint(int x, int y) {
        int i = this.getChildren().size();
        while (i > 0) {
            IFigure fig = (IFigure)this.getChildren().get(--i);
            if (!fig.containsPoint(x, y)) continue;
            return true;
        }
        return false;
    }

    protected IFigure findDescendantAtExcluding(int x, int y, TreeSearch search) {
        Point pt = new Point(x, y);
        this.translateFromParent((Translatable)pt);
        int i = this.getChildren().size();
        while (i > 0) {
            IFigure fig = (IFigure)this.getChildren().get(--i);
            if (!fig.isVisible() || (fig = fig.findFigureAt(pt.x, pt.y, search)) == null) continue;
            return fig;
        }
        return null;
    }

    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        if (search.prune((IFigure)this)) {
            return null;
        }
        IFigure child = this.findDescendantAtExcluding(x, y, search);
        if (child != null) {
            return child;
        }
        return null;
    }

    public IFigure findMouseEventTargetAt(int x, int y) {
        IFigure f = this.findMouseEventTargetInDescendantsAt(x, y);
        if (f != null) {
            return f;
        }
        if (this.isMouseEventTarget()) {
            return this;
        }
        return null;
    }

    protected IFigure findMouseEventTargetInDescendantsAt(int x, int y) {
        Point pt = new Point(x, y);
        this.translateFromParent((Translatable)pt);
        int i = this.getChildren().size();
        while (i > 0) {
            IFigure fig = (IFigure)this.getChildren().get(--i);
            if (!fig.isVisible() || !fig.isEnabled() || !fig.containsPoint(pt.x, pt.y)) continue;
            fig = fig.findMouseEventTargetAt(pt.x, pt.y);
            return fig;
        }
        return null;
    }

    public boolean intersects(Rectangle rect) {
        Rectangle rectangle = this.getParentRectangle();
        return rectangle.intersects(rect);
    }

    private Rectangle getParentRectangle() {
        Rectangle rect = this._getParentRectangle();
        return rect.union(this.getExtendedBounds());
    }

    private Rectangle _getParentRectangle() {
        Rectangle rect = this.getParent().getParent().getClientArea().getCopy();
        IFigure port = this.getViewport();
        if (port != null) {
            Rectangle portRect = port.getClientArea().getCopy();
            if (portRect.height != 0 && portRect.width != 0) {
                rect = portRect;
            }
        }
        return rect;
    }

    private IFigure getMainFigure(BorderItemContainerFigure gf) {
        BorderedNodeFigure gpf = (BorderedNodeFigure)gf.getParent();
        return gpf.getMainFigure();
    }

    private IFigure getViewport() {
        IFigure fig = this.getMainFigure(this);
        while (fig != null) {
            if (fig instanceof Viewport || fig instanceof ScalableFreeformLayeredPane) {
                return fig;
            }
            if (!((fig = fig.getParent()) instanceof BorderItemContainerFigure)) continue;
            fig = this.getMainFigure((BorderItemContainerFigure)fig);
        }
        return null;
    }

    public void erase() {
        if (this.getChildren().isEmpty()) {
            super.erase();
        } else {
            if (this.getParent() == null || !this.isVisible()) {
                return;
            }
            this.repaint();
        }
    }

    public void repaint() {
        if (this.getChildren().isEmpty()) {
            super.repaint();
        } else {
            if (this.getParent() == null || !this.isVisible()) {
                return;
            }
            Rectangle rectBounds = this.getParentRectangle();
            this.getParent().getParent().repaint(rectBounds);
            if (this.getViewport() != null) {
                this.getViewport().repaint(rectBounds);
            }
        }
    }

    public void invalidate() {
        this.extendedBounds = null;
        super.invalidate();
    }

    public void validate() {
        this.extendedBounds = null;
        super.validate();
    }

    public Rectangle getExtendedBounds() {
        if (this.extendedBounds == null) {
            this.extendedBounds = this.getExtendedBounds(this.getParent()).getCopy();
        }
        return this.extendedBounds;
    }

    private Rectangle getExtendedBounds(IFigure figure) {
        BorderedNodeFigure borderedFigure;
        BorderItemContainerFigure borderedItemContainer;
        if (figure == null) {
            return this.getBounds().getCopy();
        }
        Rectangle _bounds = figure.getBounds().getCopy();
        if (figure instanceof BorderedNodeFigure && (borderedItemContainer = (BorderItemContainerFigure)(borderedFigure = (BorderedNodeFigure)figure).getBorderItemContainer()) != null) {
            Iterator iterator = borderedItemContainer.getChildren().iterator();
            while (iterator.hasNext()) {
                Figure element = (Figure)iterator.next();
                if (element instanceof BorderedNodeFigure) {
                    BorderedNodeFigure childbFigure = (BorderedNodeFigure)element;
                    BorderItemContainerFigure childBorderedItemContainer = (BorderItemContainerFigure)childbFigure.getBorderItemContainer();
                    if (childBorderedItemContainer != null) {
                        _bounds.union(childBorderedItemContainer.getExtendedBounds());
                        continue;
                    }
                    _bounds.union(childbFigure.getBounds());
                    continue;
                }
                _bounds.union(element.getBounds());
            }
        }
        return _bounds;
    }
}

