/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.tools;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DuplicateRequest;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;

public class DragEditPartsTrackerEx
extends DragEditPartsTracker {
    public DragEditPartsTrackerEx(EditPart sourceEditPart) {
        super(sourceEditPart);
    }

    protected Command getCommand() {
        CompoundCommand command;
        if (!this.isMove()) {
            command = new CompoundCommand();
            this.addSourceCommands(false, command);
            if (this.getTargetEditPart() != null) {
                command.add(this.getTargetEditPart().getCommand(this.getTargetRequest()));
                if (command.canExecute()) {
                    return command;
                }
            }
        }
        command = new CompoundCommand();
        this.addSourceCommands(true, command);
        return command;
    }

    protected void addSourceCommands(boolean isMove, CompoundCommand command) {
        Request request = this.getTargetRequest();
        if (this.isCloneActive()) {
            List editparts = ToolUtilities.getSelectionWithoutDependants((EditPartViewer)this.getCurrentViewer());
            DuplicateRequest duplicateRequest = new DuplicateRequest();
            duplicateRequest.setEditParts(editparts);
            duplicateRequest.setExtendedData(request.getExtendedData());
            if (request instanceof ChangeBoundsRequest) {
                Point delta = ((ChangeBoundsRequest)request).getMoveDelta();
                MapModeUtil.getMapMode((IFigure)((IGraphicalEditPart)this.getTargetEditPart()).getFigure()).DPtoLP((Translatable)delta);
                duplicateRequest.setOffset(delta);
            }
            command.add(this.getTargetEditPart().getCommand((Request)duplicateRequest));
        } else {
            request.setType((Object)(isMove ? "move" : "drag"));
            Iterator iter = this.getOperationSet().iterator();
            while (iter.hasNext()) {
                EditPart editPart = (EditPart)iter.next();
                command.add(editPart.getCommand(request));
            }
        }
        request.setType((Object)"drop");
    }

    protected String getCommandName() {
        if (!this.isMove()) {
            return "drop";
        }
        return super.getCommandName();
    }

    protected boolean isMove() {
        if (!this.getOperationSet().contains(this.getSourceEditPart())) {
            return false;
        }
        return super.isMove();
    }

    protected void executeCurrentCommand() {
        super.executeCurrentCommand();
        if (this.isActive() && this.getOperationSet().size() > 0 && this.getOperationSet().get(0) instanceof IGraphicalEditPart) {
            IGraphicalEditPart editpart = (IGraphicalEditPart)this.getOperationSet().get(0);
            if (editpart.getFigure() == null || editpart.getFigure().getParent() == null || editpart.getFigure().getParent().getLayoutManager() == null) {
                return;
            }
            editpart.getFigure().getParent().getLayoutManager().layout(editpart.getFigure().getParent());
            this.reveal((EditPart)editpart);
        }
    }

    protected void reveal(EditPart editpart) {
        editpart.getViewer().reveal(editpart);
    }
}

