/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.tools;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.contentassist.ContentAssistantHelper;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TextCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.gef.ui.internal.parts.TextCellEditorEx;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.CellEditorActionHandler;

public class TextDirectEditManager
extends DirectEditManager {
    private Color proposalPopupBackgroundColor = null;
    private Color proposalPopupForegroundColor = null;
    private boolean committed = false;
    private boolean listenersAttached = true;
    private StringBuffer initialString = new StringBuffer();
    private List cachedFontDescriptors = new ArrayList();
    private IActionBars actionBars;
    private CellEditorActionHandler actionHandler;
    private IAction copy;
    private IAction cut;
    private IAction paste;
    private IAction undo;
    private IAction redo;
    private IAction find;
    private IAction selectAll;
    private IAction delete;
    private Font zoomLevelFont = null;
    private CellEditorLocator locator;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public TextDirectEditManager(ITextAwareEditPart source) {
        this(source, TextDirectEditManager.getTextCellEditorClass(source), TextDirectEditManager.getTextCellEditorLocator(source));
    }

    public TextDirectEditManager(GraphicalEditPart source, Class editorType, CellEditorLocator locator) {
        super(source, editorType, locator);
        this.locator = locator;
    }

    public static CellEditorLocator getTextCellEditorLocator(ITextAwareEditPart source) {
        if (source instanceof TextCompartmentEditPart) {
            return new TextCellEditorLocator(((TextCompartmentEditPart)source).getLabel());
        }
        IFigure figure = source.getFigure();
        if (!$assertionsDisabled && !(figure instanceof Label)) {
            throw new AssertionError();
        }
        return new LabelCellEditorLocator((Label)figure);
    }

    public static Class getTextCellEditorClass(GraphicalEditPart source) {
        IFigure figure = source.getFigure();
        if (figure instanceof WrapLabel && ((WrapLabel)figure).isTextWrapped()) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.gmf.runtime.gef.ui.internal.parts.WrapTextCellEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.gmf.runtime.gef.ui.internal.parts.TextCellEditorEx");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected Font getScaledFont(IFigure label) {
        Font scaledFont = label.getFont();
        FontData data = scaledFont.getFontData()[0];
        Dimension fontSize = new Dimension(0, MapModeUtil.getMapMode((IFigure)label).DPtoLP(data.getHeight()));
        label.translateToAbsolute((Translatable)fontSize);
        if (Math.abs(data.getHeight() - fontSize.height) < 2) {
            fontSize.height = data.getHeight();
        }
        try {
            FontDescriptor fontDescriptor = FontDescriptor.createFrom((FontData)data);
            this.cachedFontDescriptors.add(fontDescriptor);
            return this.getResourceManager().createFont(fontDescriptor);
        }
        catch (DeviceResourceException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getScaledFont", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getScaledFont", (Throwable)e);
            return JFaceResources.getDefaultFont();
        }
    }

    protected void initCellEditor() {
        IContentAssistProcessor processor;
        this.committed = false;
        ITextAwareEditPart textEP = (ITextAwareEditPart)this.getEditPart();
        this.setEditText(textEP.getEditText());
        IFigure label = textEP.getFigure();
        Assert.isNotNull((Object)label);
        Text text = (Text)this.getCellEditor().getControl();
        text.setFont(this.getScaledFont(label));
        this.getCellEditor().setValidator(textEP.getEditTextValidator());
        if (textEP.getParser() != null && (processor = textEP.getCompletionProcessor()) != null) {
            this.proposalPopupBackgroundColor = new Color((Device)this.getCellEditor().getControl().getShell().getDisplay(), new RGB(254, 241, 233));
            this.proposalPopupForegroundColor = new Color((Device)this.getCellEditor().getControl().getShell().getDisplay(), new RGB(0, 0, 0));
            ContentAssistantHelper.createTextContentAssistant((Text)text, (Color)this.proposalPopupForegroundColor, (Color)this.proposalPopupBackgroundColor, (IContentAssistProcessor)processor);
        }
        this.actionBars = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getActionBars();
        this.saveCurrentActions(this.actionBars);
        this.actionHandler = new CellEditorActionHandler(this.actionBars);
        this.actionHandler.addCellEditor(this.getCellEditor());
        this.actionBars.updateActionBars();
    }

    protected void commit() {
        Control[] children;
        Shell activeShell = Display.getCurrent().getActiveShell();
        if (activeShell != null && this.getCellEditor().getControl().getShell().equals(activeShell.getParent()) && (children = activeShell.getChildren()).length == 1 && children[0] instanceof Table) {
            this.getCellEditor().getControl().setVisible(true);
            ((TextCellEditorEx)this.getCellEditor()).setDeactivationLock(true);
            return;
        }
        if (this.committed) {
            this.bringDown();
            return;
        }
        this.committed = true;
        super.commit();
    }

    protected void bringDown() {
        if (this.proposalPopupForegroundColor != null) {
            this.proposalPopupForegroundColor.dispose();
            this.proposalPopupForegroundColor = null;
        }
        if (this.proposalPopupBackgroundColor != null) {
            this.proposalPopupBackgroundColor.dispose();
            this.proposalPopupBackgroundColor = null;
        }
        this.eraseFeedback();
        this.initialString = new StringBuffer();
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                TextDirectEditManager.super.bringDown();
            }
        });
        Iterator iter = this.cachedFontDescriptors.iterator();
        while (iter.hasNext()) {
            this.getResourceManager().destroyFont((FontDescriptor)iter.next());
        }
        this.cachedFontDescriptors.clear();
        if (this.actionHandler != null) {
            this.actionHandler.dispose();
            this.actionHandler = null;
        }
        if (this.actionBars != null) {
            this.restoreSavedActions(this.actionBars);
            this.actionBars.updateActionBars();
            this.actionBars = null;
        }
    }

    public void setEditText(String toEdit) {
        CellEditor cellEditor = this.getCellEditor();
        if (cellEditor == null) {
            return;
        }
        ITextAwareEditPart textEP = (ITextAwareEditPart)this.getEditPart();
        Text textControl = (Text)cellEditor.getControl();
        textEP.setLabelText(toEdit);
        if (cellEditor instanceof TextCellEditorEx) {
            ((TextCellEditorEx)cellEditor).setValueAndProcessEditOccured((Object)toEdit);
        } else {
            cellEditor.setValue((Object)toEdit);
        }
        textControl.setSelection(toEdit.length());
    }

    public void show(char initialChar) {
        this.initialString = this.initialString.append(initialChar);
        this.show();
        if (SWT.getPlatform() != "carbon") {
            this.setEditText(this.initialString.toString());
        }
    }

    private Font getZoomLevelFont(Font actualFont, Display display) {
        Object zoom;
        EditPartViewer editPartViewer = this.getEditPart().getViewer();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.gef.editparts.ZoomManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((zoom = editPartViewer.getProperty(clazz.toString())) != null) {
            double zoomLevel = ((ZoomManager)zoom).getZoom();
            if (zoomLevel == 1.0) {
                return actualFont;
            }
            FontData[] fd = new FontData[actualFont.getFontData().length];
            FontData tempFD = null;
            int i = 0;
            while (i < fd.length) {
                tempFD = actualFont.getFontData()[i];
                fd[i] = new FontData(tempFD.getName(), (int)(zoomLevel * (double)tempFD.getHeight()), tempFD.getStyle());
                ++i;
            }
            try {
                FontDescriptor fontDescriptor = FontDescriptor.createFrom((FontData[])fd);
                this.cachedFontDescriptors.add(fontDescriptor);
                return this.getResourceManager().createFont(fontDescriptor);
            }
            catch (DeviceResourceException e) {
                Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getZoomLevelFonts", (Throwable)e);
                Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getZoomLevelFonts", (Throwable)e);
                return actualFont;
            }
        }
        return actualFont;
    }

    private Dimension getTextExtents(String s, Font font, IMapMode mm) {
        Dimension d = FigureUtilities.getTextExtents((String)s, (Font)font);
        int lineCount = this.getLineCount(s);
        d.height = FigureUtilities.getFontMetrics((Font)font).getHeight() * lineCount;
        return new Dimension(mm.DPtoLP(d.width), mm.DPtoLP(d.height));
    }

    private int getLineCount(String s) {
        StringTokenizer tokenizer = new StringTokenizer(s, "\n");
        return tokenizer.countTokens();
    }

    public void show() {
        super.show();
        IFigure fig = this.getEditPart().getFigure();
        Control control = this.getCellEditor().getControl();
        this.zoomLevelFont = this.getZoomLevelFont(fig.getFont(), control.getDisplay());
        control.setFont(this.zoomLevelFont);
        this.locator.relocate(this.getCellEditor());
    }

    public void show(org.eclipse.swt.graphics.Point location) {
        String text;
        String subStringText;
        int textPlacement;
        Image icon;
        Rectangle iconBounds;
        WrapLabel label;
        this.show();
        IFigure fig = this.getEditPart().getFigure();
        if (fig instanceof WrapLabel) {
            label = (WrapLabel)fig;
            iconBounds = label.getIconBounds().getCopy();
            icon = label.getIcon();
            textPlacement = label.getTextPlacement();
            subStringText = label.getSubStringText();
            text = label.getText();
        } else if (fig instanceof Label) {
            label = (Label)fig;
            iconBounds = label.getIconBounds().getCopy();
            icon = label.getIcon();
            textPlacement = label.getTextPlacement();
            subStringText = label.getSubStringText();
            text = label.getText();
        } else {
            this.sendClickToCellEditor(location);
            return;
        }
        Text textControl = (Text)this.getCellEditor().getControl();
        Rectangle restoreRect = fig.getBounds().getCopy();
        Rectangle rect = fig.getBounds();
        fig.translateToAbsolute((Translatable)rect);
        if (!rect.contains(new Point(location.x, location.y))) {
            textControl.setSelection(0, textControl.getText().length());
            fig.setBounds(restoreRect);
            return;
        }
        fig.translateToAbsolute((Translatable)iconBounds);
        double avrLines = (double)fig.getBounds().height / (double)FigureUtilities.getFontMetrics((Font)this.zoomLevelFont).getHeight();
        int xWidth = location.x - rect.x;
        if (icon != null && textPlacement == 16) {
            xWidth -= iconBounds.width;
        }
        double yPercentage = (double)(location.y - rect.y) / (double)rect.height;
        int lineNum = (int)Math.ceil(avrLines * yPercentage);
        int charCount = 0;
        StringTokenizer tokenizer = new StringTokenizer(subStringText, "\n");
        int lineCount = 1;
        while (lineCount < lineNum) {
            if (tokenizer.hasMoreTokens()) {
                String newLineCheck;
                if ((newLineCheck = text.substring(charCount += tokenizer.nextToken().length(), charCount + 1)).equals("\r") || newLineCheck.equals("\n")) {
                    ++charCount;
                }
            } else {
                this.sendClickToCellEditor(location);
                fig.setBounds(restoreRect);
                return;
            }
            ++lineCount;
        }
        if (tokenizer.hasMoreTokens()) {
            String currentLineText = tokenizer.nextToken();
            IMapMode mm = MapModeUtil.getMapMode((IFigure)fig);
            int i = 1;
            while (i <= currentLineText.length()) {
                Dimension textExtent = this.getTextExtents(currentLineText.substring(0, i), this.zoomLevelFont, mm);
                fig.translateToAbsolute((Translatable)textExtent);
                ++charCount;
                if (textExtent.width >= xWidth) break;
                ++i;
            }
            textControl.setSelection(charCount);
            fig.setBounds(restoreRect);
        } else {
            this.sendClickToCellEditor(location);
            fig.setBounds(restoreRect);
        }
    }

    private void sendClickToCellEditor(org.eclipse.swt.graphics.Point location) {
        this.getCellEditor().getControl().setCapture(true);
        if (this.getCellEditor() != null && this.getCellEditor().getControl().getBounds().contains(location)) {
            this.sendMouseClick(location);
        }
    }

    private void sendMouseClick(final org.eclipse.swt.graphics.Point location) {
        final Display currDisplay = Display.getCurrent();
        new Thread(){
            Event event;

            public void run() {
                this.event = new Event();
                this.event.type = 3;
                this.event.button = 1;
                this.event.x = location.x;
                this.event.y = location.y;
                currDisplay.post(this.event);
                this.event.type = 4;
                currDisplay.post(this.event);
            }
        }.start();
    }

    protected void unhookListeners() {
        if (this.listenersAttached) {
            this.listenersAttached = false;
            super.unhookListeners();
        }
    }

    protected void setCellEditor(CellEditor editor) {
        super.setCellEditor(editor);
        if (editor != null) {
            this.listenersAttached = true;
        }
    }

    public void showFeedback() {
        try {
            this.getEditPart().getRoot();
            super.showFeedback();
        }
        catch (Exception exception) {}
    }

    protected ResourceManager getResourceManager() {
        return ((DiagramGraphicalViewer)this.getEditPart().getViewer()).getResourceManager();
    }

    private void saveCurrentActions(IActionBars _actionBars) {
        this.copy = _actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
        this.paste = _actionBars.getGlobalActionHandler(ActionFactory.PASTE.getId());
        this.delete = _actionBars.getGlobalActionHandler(ActionFactory.DELETE.getId());
        this.selectAll = _actionBars.getGlobalActionHandler(ActionFactory.SELECT_ALL.getId());
        this.cut = _actionBars.getGlobalActionHandler(ActionFactory.CUT.getId());
        this.find = _actionBars.getGlobalActionHandler(ActionFactory.FIND.getId());
        this.undo = _actionBars.getGlobalActionHandler(ActionFactory.UNDO.getId());
        this.redo = _actionBars.getGlobalActionHandler(ActionFactory.REDO.getId());
    }

    private void restoreSavedActions(IActionBars _actionBars) {
        _actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copy);
        _actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.paste);
        _actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.delete);
        _actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.selectAll);
        _actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.cut);
        _actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.find);
        _actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.undo);
        _actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.redo);
    }

    public void setLocator(CellEditorLocator locator) {
        super.setLocator(locator);
        this.locator = locator;
    }

    private static class TextCellEditorLocator
    implements CellEditorLocator {
        private WrapLabel wrapLabel;

        public TextCellEditorLocator(WrapLabel wrapLabel) {
            this.wrapLabel = wrapLabel;
        }

        public WrapLabel getWrapLabel() {
            return this.wrapLabel;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            WrapLabel fig = this.getWrapLabel();
            Rectangle rect = fig.getTextBounds().getCopy();
            fig.translateToAbsolute((Translatable)rect);
            int avrWidth = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
            if (fig.isTextWrapped() && fig.getText().length() > 0) {
                rect.setSize(new Dimension(rect.width, rect.height + FigureUtilities.getFontMetrics((Font)text.getFont()).getDescent()));
            } else {
                rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avrWidth * 2, 0));
            }
            org.eclipse.swt.graphics.Rectangle newRect = text.computeTrim(rect.x, rect.y, rect.width, rect.height);
            Rectangle textBounds = new Rectangle(text.getBounds());
            if (!newRect.equals((Object)textBounds)) {
                if (fig.getTextWrapAlignment() != 1 && fig.getTextAlignment() != 1) {
                    text.setBounds(newRect.x, newRect.y, newRect.width + avrWidth * 3, newRect.height);
                } else if (text.getBounds().x == 0 || Math.abs(text.getBounds().x - newRect.x) >= avrWidth) {
                    text.setBounds(newRect.x, newRect.y, newRect.width + avrWidth * 3, newRect.height);
                } else {
                    text.setBounds(text.getBounds().x, newRect.y, newRect.width + avrWidth * 3, newRect.height);
                }
            }
        }
    }

    private static class LabelCellEditorLocator
    implements CellEditorLocator {
        private Label label;

        public LabelCellEditorLocator(Label label) {
            this.label = label;
        }

        public Label getLabel() {
            return this.label;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getLabel().getTextBounds().getCopy();
            this.getLabel().translateToAbsolute((Translatable)rect);
            int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
            rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
            org.eclipse.swt.graphics.Rectangle newRect = text.computeTrim(rect.x, rect.y, rect.width, rect.height);
            if (!newRect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(newRect.x, newRect.y, newRect.width, newRect.height);
            }
        }
    }
}

