/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.internal.util;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.PageBreakEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.PageBreaksFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.pagesetup.PageInfoHelper;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.HeaderAndFooterHelper;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.PrintHelper;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.MapModeGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.PrinterGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.ScaledGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class DiagramPrinter
implements Runnable {
    protected Printer printer;
    private org.eclipse.swt.graphics.Point display_dpi;
    private boolean isScaledPercent = false;
    private int rows = 1;
    private int columns = 1;
    private boolean printRangePageSelection = false;
    private int pageFrom = 1;
    private int pageTo = 1;
    private GC gc;
    private Graphics swtGraphics;
    private Graphics graphics;
    private PrinterGraphics printerGraphics;
    protected org.eclipse.swt.graphics.Point printerOffset;
    protected Rectangle logicalClientArea;
    private float userScale;
    private boolean fitToPage = false;
    protected Collection diagrams;
    private org.eclipse.swt.graphics.Point translated = null;
    private PreferencesHint preferencesHint;
    private IMapMode mm;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.DiagramPrinter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public void setFitToPage(boolean fitToPage) {
        this.fitToPage = fitToPage;
    }

    public DiagramPrinter(PreferencesHint preferencesHint, IMapMode mm) {
        this.preferencesHint = preferencesHint;
        this.mm = mm;
    }

    public DiagramPrinter(PreferencesHint preferencesHint) {
        this(preferencesHint, MapModeUtil.getMapMode());
    }

    protected IMapMode getMapMode() {
        return this.mm;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public void setDiagrams(Collection diagrams) {
        this.diagrams = diagrams;
    }

    public void setDisplayDPI(org.eclipse.swt.graphics.Point display_dpi) {
        this.display_dpi = new org.eclipse.swt.graphics.Point(display_dpi.x, display_dpi.y);
    }

    public void setPrinter(Printer printer) {
        this.printer = printer;
    }

    public void setPrintRangePageSelection(boolean isPrintRangePageSelected) {
        this.printRangePageSelection = isPrintRangePageSelected;
    }

    public void setPrintRangePages(int pageFrom, int pageTo) {
        if (!$assertionsDisabled && pageFrom <= 0) {
            throw new AssertionError((Object)"From page in print range page selection must be bigger than zero.");
        }
        if (!($assertionsDisabled || pageTo > 0 && pageTo >= pageFrom)) {
            throw new AssertionError((Object)"To page in print range page selection must be bigger than zero and from page.");
        }
        this.pageFrom = pageFrom;
        this.pageTo = pageTo;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setScaledPercent(int scalePercent) {
        this.isScaledPercent = true;
        this.userScale = (float)scalePercent / 100.0f;
    }

    public void run() {
        if (!$assertionsDisabled && this.printer == null) {
            throw new AssertionError((Object)"printer must be set");
        }
        if (!this.printer.startJob("Printing")) {
            return;
        }
        if (!$assertionsDisabled && this.diagrams == null) {
            throw new AssertionError();
        }
        Iterator it = this.diagrams.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Assert.isTrue((boolean)(obj instanceof Diagram));
            DiagramEditPart dgrmEP = PrintHelper.createDiagramEditPart((Diagram)obj, this.preferencesHint);
            RootEditPart rep = dgrmEP.getRoot();
            if (rep instanceof DiagramRootEditPart) {
                this.mm = ((DiagramRootEditPart)rep).getMapMode();
            }
            this.initialize();
            boolean loadedPreferences = PrintHelper.initializePreferences(dgrmEP, this.preferencesHint);
            IPreferenceStore pref = null;
            if (!$assertionsDisabled && !(dgrmEP.getViewer() instanceof DiagramGraphicalViewer)) {
                throw new AssertionError();
            }
            pref = ((DiagramGraphicalViewer)dgrmEP.getViewer()).getWorkspaceViewerPreferenceStore();
            if (pref.getBoolean("print.useWorkspaceSettings") && dgrmEP.getDiagramPreferencesHint().getPreferenceStore() != null) {
                pref = (IPreferenceStore)dgrmEP.getDiagramPreferencesHint().getPreferenceStore();
            }
            this.doPrintDiagram(dgrmEP, loadedPreferences, pref);
            this.dispose();
        }
        this.printer.endJob();
    }

    private int calculateRowFromPage(int pageNum, int totalNumColumns) {
        int row = pageNum / totalNumColumns;
        if (pageNum % totalNumColumns != 0) {
            ++row;
        }
        return row;
    }

    private int calculateColumnFromPage(int pageNum, int totalNumColumns, int cRow) {
        int col = pageNum - (cRow - 1) * totalNumColumns;
        return col;
    }

    private Point getPageCount(DiagramEditPart dgrmEP, Rectangle figureBounds, Point pageSize, boolean applyUserScale) {
        RootEditPart rootEditPart = dgrmEP.getRoot();
        if (rootEditPart instanceof DiagramRootEditPart) {
            DiagramRootEditPart diagramRootEditPart = (DiagramRootEditPart)rootEditPart;
            PageBreakEditPart pageBreakEditPart = diagramRootEditPart.getPageBreakEditPart();
            float fNumCols = (float)((PageBreaksFigure)pageBreakEditPart.getFigure()).getPageCount().y * (applyUserScale ? this.userScale : 1.0f);
            float fNumRows = (float)((PageBreaksFigure)pageBreakEditPart.getFigure()).getPageCount().x * (applyUserScale ? this.userScale : 1.0f);
            int numCols = (int)Math.ceil(fNumCols);
            int numRows = (int)Math.ceil(fNumRows);
            return new Point(numCols, numRows);
        }
        float fNumRows = (float)figureBounds.height * (applyUserScale ? this.userScale : 1.0f) / (float)pageSize.y;
        int numRows = (int)Math.ceil(fNumRows);
        float fNumCols = (float)figureBounds.width * (applyUserScale ? this.userScale : 1.0f) / (float)pageSize.x;
        int numCols = (int)Math.ceil(fNumCols);
        return new Point(numCols, numRows);
    }

    private void doPrintDiagram(DiagramEditPart dgrmEP, boolean loadedPreferences, IPreferenceStore fPreferences) {
        this.graphics.pushState();
        if (this.isScaledPercent) {
            this.printToScale(dgrmEP, loadedPreferences, fPreferences);
        } else {
            this.printToPages(dgrmEP, loadedPreferences, fPreferences);
        }
        this.graphics.popState();
    }

    private void initialize() {
        if (!$assertionsDisabled && this.printer == null) {
            throw new AssertionError((Object)"printer must be set");
        }
        int style = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getStyle();
        this.gc = (style & 0x8000000) != 0 ? new GC((Drawable)this.printer, 0x4000000) : new GC((Drawable)this.printer);
        this.gc.setXORMode(false);
        this.swtGraphics = new SWTGraphics(this.gc);
        this.printerGraphics = this.createPrinterGraphics(this.swtGraphics);
        this.graphics = this.createMapModeGraphics((Graphics)this.printerGraphics);
        this.graphics.scale((double)this.computePrinterDisplayScale());
        this.logicalClientArea = this.graphics.getClip(new Rectangle(this.printer.getClientArea()));
    }

    protected org.eclipse.swt.graphics.Point getPrinterOffset() {
        if (this.printerOffset == null) {
            int offsetX = this.printer.getBounds().width - this.printer.getClientArea().width;
            int offsetY = this.printer.getBounds().height - this.printer.getClientArea().height;
            offsetX = (int)((float)this.getMapMode().DPtoLP((int)((float)offsetX / 2.0f * (float)this.display_dpi.x / (float)this.printer.getDPI().x)) / this.userScale);
            offsetY = (int)((float)this.getMapMode().DPtoLP((int)((float)offsetY / 2.0f * (float)this.display_dpi.y / (float)this.printer.getDPI().y)) / this.userScale);
            this.printerOffset = new org.eclipse.swt.graphics.Point(offsetX, offsetY);
        }
        return this.printerOffset;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void printToScale(DiagramEditPart dgrmEP, boolean loadedPreferences, IPreferenceStore fPreferences) {
        if (!DiagramPrinter.$assertionsDisabled && this.printer == null) {
            throw new AssertionError((Object)"printer must be set");
        }
        figureBounds = PrintHelper.getPageBreakBounds(dgrmEP, loadedPreferences);
        pageSize = PageInfoHelper.getPageSize((IPreferenceStore)fPreferences, (boolean)false, (IMapMode)this.getMapMode());
        this.translated = new org.eclipse.swt.graphics.Point((int)((float)(-figureBounds.x) * this.userScale), (int)((float)(-figureBounds.y) * this.userScale));
        numRows = 0;
        numCols = 0;
        margins = PageInfoHelper.getPageMargins((IPreferenceStore)fPreferences, (IMapMode)this.getMapMode());
        this.adjustMargins(margins, this.userScale, this.getPrinterOffset());
        gc_ = new GC((Drawable)Display.getDefault(), this.gc.getStyle());
        gc_.setAntialias(this.gc.getAntialias());
        fontData = JFaceResources.getDefaultFont().getFontData()[0];
        font = new Font((Device)this.printer, fontData);
        pageCount = this.getPageCount(dgrmEP, figureBounds, pageSize, true);
        numCols = pageCount.x;
        numRows = pageCount.y;
        row = 1;
        col = 1;
        finalRow = 0;
        finalColumn = 0;
        if (!this.printRangePageSelection) ** GOTO lbl-1000
        row = this.calculateRowFromPage(this.pageFrom, numCols);
        col = this.calculateColumnFromPage(this.pageFrom, numCols, row);
        finalRow = this.calculateRowFromPage(this.pageTo, numCols);
        finalColumn = this.calculateColumnFromPage(this.pageTo, numCols, finalRow);
        try lbl-1000:
        // 3 sources

        {
            while (row <= numRows) {
                while (col <= numCols) {
                    this.printer.startPage();
                    this.drawPage(gc_, dgrmEP, fPreferences, figureBounds, margins, font, row, col);
                    this.printer.endPage();
                    if (row == finalRow && col == finalColumn && this.printRangePageSelection) break;
                    ++col;
                }
                if (row != finalRow || col != finalColumn || !this.printRangePageSelection) {
                    col = 1;
                    ++row;
                    continue;
                }
                break;
            }
        }
        catch (Throwable var18_17) {
            var17_18 = null;
            font.dispose();
            gc_.dispose();
            throw var18_17;
        }
        {
            var17_19 = null;
        }
        font.dispose();
        gc_.dispose();
    }

    protected void drawHeaderAndFooter(GC gc_, DiagramEditPart dgrmEP, Rectangle figureBounds, Font font, int rowIndex, int colIndex) {
        int width = this.logicalClientArea.width;
        int height = this.logicalClientArea.height;
        this.graphics.pushState();
        this.graphics.setFont(font);
        this.graphics.scale((double)(1.0f / this.userScale));
        this.graphics.translate(-this.translated.x, -this.translated.y);
        String headerOrFooter = HeaderAndFooterHelper.makeHeaderOrFooterString("header", rowIndex, colIndex, dgrmEP);
        this.graphics.drawText(headerOrFooter, this.getMapMode().DPtoLP(5) + (width - this.getMapMode().DPtoLP(gc_.textExtent((String)headerOrFooter).x)) / 2, this.getMapMode().DPtoLP(5));
        headerOrFooter = HeaderAndFooterHelper.makeHeaderOrFooterString("footer", rowIndex, colIndex, dgrmEP);
        this.graphics.drawText(headerOrFooter, this.getMapMode().DPtoLP(5) + (width - this.getMapMode().DPtoLP(gc_.textExtent((String)headerOrFooter).x)) / 2, height - this.getMapMode().DPtoLP(20));
        this.graphics.popState();
    }

    protected void drawPage(GC gc_, DiagramEditPart dgrmEP, IPreferenceStore fPreferences, Rectangle figureBounds, PageInfoHelper.PageMargins margins, Font font, int rowIndex, int colIndex) {
        Point pageSize = PageInfoHelper.getPageSize((IPreferenceStore)fPreferences, (boolean)false, (IMapMode)this.getMapMode());
        boolean rtlEnabled = (this.gc.getStyle() & 0x8000000) != 0;
        int width = pageSize.x;
        int height = pageSize.y;
        Image image = new Image((Device)Display.getDefault(), this.getMapMode().LPtoDP(pageSize.x), this.getMapMode().LPtoDP(pageSize.y));
        GC imgGC = new GC((Drawable)image, rtlEnabled ? 0x4000000 : 0x2000000);
        imgGC.setXORMode(false);
        SWTGraphics sg = new SWTGraphics(imgGC);
        ScaledGraphics g1 = new ScaledGraphics((Graphics)sg);
        MapModeGraphics mmg = this.createMapModeGraphics((Graphics)g1);
        imgGC.setFont(mmg.getFont());
        mmg.translate(this.translated.x, this.translated.y);
        mmg.scale((double)this.userScale);
        mmg.pushState();
        int translateX = -(width * (colIndex - 1));
        int translateY = -(height * (rowIndex - 1));
        int scaledTranslateX = (int)((float)translateX / this.userScale);
        int scaledTranslateY = (int)((float)translateY / this.userScale);
        int scaledWidth = (int)((float)width / this.userScale);
        int scaledHeight = (int)((float)height / this.userScale);
        if (rtlEnabled) {
            scaledTranslateX += margins.left * (colIndex - 1) + margins.right * colIndex;
            scaledTranslateY += margins.top * rowIndex + margins.bottom * (rowIndex - 1);
        } else {
            scaledTranslateX += margins.left * colIndex + margins.right * (colIndex - 1);
            scaledTranslateY += margins.top * rowIndex + margins.bottom * (rowIndex - 1);
        }
        mmg.translate(scaledTranslateX, scaledTranslateY);
        Rectangle clip = new Rectangle((scaledWidth - margins.left - margins.right) * (colIndex - 1) + figureBounds.x, (scaledHeight - margins.bottom - margins.top) * (rowIndex - 1) + figureBounds.y, scaledWidth - margins.right - margins.left, scaledHeight - margins.top - margins.bottom);
        mmg.clipRect(clip);
        dgrmEP.getLayer((Object)"Printable Layers").paint((Graphics)mmg);
        mmg.popState();
        this.graphics.pushState();
        this.graphics.drawImage(image, 0, 0);
        this.graphics.popState();
        this.drawHeaderAndFooter(gc_, dgrmEP, figureBounds, font, rowIndex, colIndex);
        this.disposeImageVars(imgGC, image, sg, g1, mmg);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void printToPages(DiagramEditPart dgrmEP, boolean loadedPreferences, IPreferenceStore fPreferences) {
        if (!DiagramPrinter.$assertionsDisabled && this.printer == null) {
            throw new AssertionError((Object)"printer must be set");
        }
        figureBounds = PrintHelper.getPageBreakBounds(dgrmEP, loadedPreferences);
        margins = PageInfoHelper.getPageMargins((IPreferenceStore)fPreferences, (IMapMode)this.getMapMode());
        pageSize = PageInfoHelper.getPageSize((IPreferenceStore)fPreferences, (boolean)false, (IMapMode)this.getMapMode());
        pageCount = this.getPageCount(dgrmEP, figureBounds, pageSize, false);
        numCols = pageCount.x;
        numRows = pageCount.y;
        actualWidth = 0.0f;
        actualHeight = 0.0f;
        if (this.rows == 1 && this.columns == 1 && this.fitToPage) {
            rectangle = dgrmEP.getChildrenBounds();
            figureBounds.width = rectangle.x + rectangle.width + numCols * margins.right + numCols * margins.left;
            figureBounds.height = rectangle.y + rectangle.height + numRows * margins.top + numRows * margins.bottom;
            actualWidth = figureBounds.width;
            actualHeight = figureBounds.height;
        } else {
            actualWidth = numCols * pageSize.x;
            actualHeight = numRows * pageSize.y;
        }
        pageBounds = PageInfoHelper.getPageSize((IPreferenceStore)fPreferences, (IMapMode)this.getMapMode());
        translate = new Rectangle(Math.min(0, figureBounds.x), Math.min(0, figureBounds.y), Math.max(pageBounds.x, numCols * pageSize.x), Math.max(pageBounds.y, numRows * pageSize.y));
        totalHeight = this.rows * pageSize.y;
        totalWidth = this.columns * pageSize.x;
        vScale = (float)totalHeight / actualHeight;
        hScale = (float)totalWidth / actualWidth;
        this.userScale = Math.min(hScale, vScale);
        this.translated = new org.eclipse.swt.graphics.Point((int)((float)(-translate.x) * this.userScale), (int)((float)(-translate.y) * this.userScale));
        this.adjustMargins(margins, this.userScale, this.getPrinterOffset());
        gc_ = new GC((Drawable)Display.getDefault());
        fontData = JFaceResources.getDefaultFont().getFontData()[0];
        font = new Font((Device)this.printer, fontData);
        row = 1;
        col = 1;
        finalRow = 0;
        finalColumn = 0;
        if (!this.printRangePageSelection) ** GOTO lbl-1000
        row = this.calculateRowFromPage(this.pageFrom, this.columns);
        col = this.calculateColumnFromPage(this.pageFrom, this.columns, row);
        finalRow = this.calculateRowFromPage(this.pageTo, this.columns);
        finalColumn = this.calculateColumnFromPage(this.pageTo, this.columns, finalRow);
        try lbl-1000:
        // 3 sources

        {
            while (row <= this.rows) {
                while (col <= this.columns) {
                    this.printer.startPage();
                    this.drawPage(gc_, dgrmEP, fPreferences, translate, margins, font, row, col);
                    this.printer.endPage();
                    if (row == finalRow && col == finalColumn && this.printRangePageSelection) break;
                    ++col;
                }
                if (row != finalRow || col != finalColumn || !this.printRangePageSelection) {
                    col = 1;
                    ++row;
                    continue;
                }
                break;
            }
        }
        catch (Throwable var26_25) {
            var25_26 = null;
            font.dispose();
            gc_.dispose();
            throw var26_25;
        }
        {
            var25_27 = null;
        }
        font.dispose();
        gc_.dispose();
    }

    private float computePrinterDisplayScale() {
        if (!$assertionsDisabled && this.printer == null) {
            throw new AssertionError((Object)"printer must be set");
        }
        if (!$assertionsDisabled && this.display_dpi == null) {
            throw new AssertionError((Object)"display_dpi must be set");
        }
        org.eclipse.swt.graphics.Point dpi = this.printer.getDPI();
        float scale = (float)dpi.x / (float)this.display_dpi.x;
        return scale;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dispose() {
        Object var1_6;
        if (this.graphics != null) {
            try {
                try {
                    this.graphics.dispose();
                }
                catch (NullPointerException nullPointerException) {}
            }
            catch (Throwable throwable) {
                Object var1_5 = null;
                this.graphics = null;
                throw throwable;
            }
            {
                var1_6 = null;
                this.graphics = null;
            }
        }
        if (this.printerGraphics != null) {
            try {
                try {
                    this.printerGraphics.dispose();
                }
                catch (NullPointerException nullPointerException) {}
            }
            catch (Throwable throwable) {
                var1_6 = null;
                this.printerGraphics = null;
                throw throwable;
            }
            {
                var1_6 = null;
                this.printerGraphics = null;
            }
        }
        if (this.swtGraphics != null) {
            try {
                try {
                    this.swtGraphics.dispose();
                }
                catch (NullPointerException nullPointerException) {}
            }
            catch (Throwable throwable) {
                var1_6 = null;
                this.swtGraphics = null;
                throw throwable;
            }
            {
                var1_6 = null;
                this.swtGraphics = null;
            }
        }
        if (this.gc != null) {
            try {
                try {
                    this.gc.dispose();
                }
                catch (NullPointerException nullPointerException) {}
            }
            catch (Throwable throwable) {
                var1_6 = null;
                this.gc = null;
                throw throwable;
            }
            {
                var1_6 = null;
                this.gc = null;
            }
        }
        this.printerOffset = null;
    }

    /*
     * Exception decompiling
     */
    private void disposeImageVars(GC imgGC, Image image, SWTGraphics sg, ScaledGraphics g1, MapModeGraphics mmg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 32->35)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected MapModeGraphics createMapModeGraphics(Graphics theGraphics) {
        return new MapModeGraphics(theGraphics, this.getMapMode());
    }

    protected PrinterGraphics createPrinterGraphics(Graphics theGraphics) {
        return new PrinterGraphics(theGraphics, this.printer, true);
    }

    protected PreferencesHint getPreferencesHint() {
        return this.preferencesHint;
    }

    protected void adjustMargins(PageInfoHelper.PageMargins margins, float scale, org.eclipse.swt.graphics.Point offset) {
        margins.left = (int)((float)margins.left / scale);
        margins.top = (int)((float)margins.top / scale);
        margins.right = (int)((float)margins.right / scale);
        margins.bottom = (int)((float)margins.bottom / scale);
        margins.left -= offset.x;
        margins.right += offset.x;
        margins.top -= offset.y;
        margins.bottom += offset.y;
        if (margins.left < 0) {
            margins.left = 0;
        }
        if (margins.right < 0) {
            margins.right = 0;
        }
        if (margins.top < 0) {
            margins.top = 0;
        }
        if (margins.bottom < 0) {
            margins.bottom = 0;
        }
    }
}

