/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.core.clipboard;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.emf.core.clipboard.CopyingResourceSet;
import org.eclipse.gmf.runtime.emf.core.internal.plugin.EMFCoreDebugOptions;
import org.eclipse.gmf.runtime.emf.core.internal.plugin.EMFCorePlugin;
import org.eclipse.gmf.runtime.emf.core.internal.util.Util;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;

public class CopyingResource
extends XMIResourceImpl {
    private XMLResource xmlResource;
    private CopyingResourceSet copyingResourceSet;

    public CopyingResource(XMLResource resource, URI uri, CopyingResourceSet copyingResourceSet) {
        this(resource, uri, copyingResourceSet, true);
    }

    public CopyingResource(XMLResource resource, URI uri, CopyingResourceSet copyingResourceSet, boolean regenerateIds) {
        super(uri);
        this.xmlResource = resource;
        this.copyingResourceSet = copyingResourceSet;
        this.setEncoding(resource.getEncoding());
        this.setLoaded(true);
        this.getDefaultSaveOptions().putAll(resource.getDefaultSaveOptions());
        copyingResourceSet.getResources().add((Object)this);
        copyingResourceSet.getResourcesMap().put(resource, this);
        if (regenerateIds) {
            this.createNewIDs();
        } else {
            this.copyIDs();
        }
    }

    private void createNewIDs() {
        TreeIterator it = this.getXMLResource().getAllContents();
        while (it.hasNext()) {
            this.setID((EObject)it.next(), EcoreUtil.generateUUID());
        }
    }

    protected XMLLoad createXMLLoad() {
        this.throwUnsupportedOperationException("createXMLLoad", new UnsupportedOperationException("Can't call load on CopyingResource resource"));
        return null;
    }

    protected XMLHelper createXMLHelper() {
        return new CopyingHelper((XMLResource)this);
    }

    protected void unloaded(InternalEObject internalEObject) {
    }

    public boolean eNotificationRequired() {
        return false;
    }

    private void throwUnsupportedOperationException(String methodName, UnsupportedOperationException ex) {
        Trace.throwing((Plugin)EMFCorePlugin.getDefault(), (String)EMFCoreDebugOptions.EXCEPTIONS_THROWING, ((Object)((Object)this)).getClass(), (String)methodName, (Throwable)ex);
        throw ex;
    }

    private Map getResourcesMap() {
        return this.getMslCopyingResourceSet().getResourcesMap();
    }

    public void doLoad(InputStream inputStream, Map options) throws IOException {
        this.throwUnsupportedOperationException("doLoad", new UnsupportedOperationException("Can't call load on CopyingResource resource"));
    }

    protected XMLSave createXMLSave() {
        return new CopyingSave(this.createXMLHelper());
    }

    private boolean isInResource(EObject eObject) {
        while (eObject != null) {
            if (((InternalEObject)eObject).eDirectResource() == this.getXMLResource()) {
                return true;
            }
            eObject = eObject.eContainer();
        }
        return false;
    }

    public EList getContents() {
        return this.getXMLResource().getContents();
    }

    protected void doUnload() {
    }

    public EObject getEObject(String uriFragment) {
        int index = uriFragment.indexOf(63);
        if (-1 != index) {
            uriFragment = uriFragment.substring(0, index);
        }
        return super.getEObject(uriFragment);
    }

    protected EObject getEObjectByID(String id) {
        EObject eObj = this.getXMLResource().getEObject(id);
        if (eObj == null) {
            return super.getEObjectByID(id);
        }
        return eObj;
    }

    public CopyingResourceSet getMslCopyingResourceSet() {
        return this.copyingResourceSet;
    }

    public ResourceSet getResourceSet() {
        return this.getMslCopyingResourceSet();
    }

    public void attached(EObject eObject) {
    }

    public void detached(EObject eObject) {
    }

    public Map getEObjectToExtensionMap() {
        return this.getXMLResource().getEObjectToExtensionMap();
    }

    public boolean isTrackingModification() {
        return false;
    }

    private void copyIDs() {
        XMLResource lastRes = null;
        TreeIterator iter = this.getXMLResource().getAllContents();
        while (iter.hasNext()) {
            InternalEObject eObject = (InternalEObject)iter.next();
            if (eObject.eDirectResource() != null) {
                lastRes = (XMLResource)eObject.eDirectResource();
            }
            this.getEObjectToIDMap().put(eObject, lastRes.getID((EObject)eObject));
            this.getIDToEObjectMap().put(lastRes.getID((EObject)eObject), eObject);
        }
    }

    protected XMLResource getXMLResource() {
        return this.xmlResource;
    }

    protected class CopyingHelper
    extends XMIHelperImpl {
        public CopyingHelper() {
        }

        public CopyingHelper(XMLResource resource) {
            super(resource);
        }

        public URI deresolve(URI anUri) {
            if ("platform".equals(anUri.scheme()) && "platform".equals(this.resourceURI.scheme()) && anUri.segmentCount() > 2 && this.resourceURI.segmentCount() > 2 && (!anUri.segments()[0].equals(this.resourceURI.segments()[0]) || !anUri.segments()[1].equals(this.resourceURI.segments()[1]))) {
                return anUri;
            }
            return super.deresolve(anUri);
        }

        public String getHREF(EObject obj) {
            Resource resource;
            EObject eObj = obj;
            if (obj.eIsProxy() && (eObj = EcoreUtil.resolve((EObject)obj, (Resource)CopyingResource.this.getXMLResource())) == obj) {
                eObj = null;
            }
            if (eObj != null && (resource = eObj.eResource()) != null) {
                URI objectURI = this.getHREF(resource, eObj);
                objectURI = this.deresolve(objectURI);
                return objectURI.toString();
            }
            return super.getHREF(obj);
        }

        protected URI getHREF(Resource otherResource, EObject obj) {
            String qName;
            CopyingResource copyingResource;
            if (!(otherResource instanceof CopyingResource) && (copyingResource = (CopyingResource)((Object)CopyingResource.this.getResourcesMap().get(otherResource))) != null) {
                otherResource = copyingResource;
            }
            if ((qName = EMFCoreUtil.getQualifiedName(obj, true)).length() > 0) {
                StringBuffer buffer = new StringBuffer(otherResource.getURIFragment(obj));
                buffer.append('?');
                buffer.append(Util.encodeQualifiedName(qName));
                buffer.append('?');
                return otherResource.getURI().appendFragment(buffer.toString());
            }
            return super.getHREF(otherResource, obj);
        }
    }

    public class CopyingSave
    extends XMISaveImpl {
        public CopyingSave(XMLHelper helper) {
            super(helper);
        }

        public CopyingSave(Map options, XMLHelper helper, String encoding) {
            super(options, helper, encoding);
        }

        public CopyingSave(Map options, XMLHelper helper, String encoding, String xmlVersion) {
            super(options, helper, encoding, xmlVersion);
        }

        protected int sameDocMany(EObject o, EStructuralFeature f) {
            InternalEList values = (InternalEList)this.helper.getValue(o, f);
            if (values.isEmpty()) {
                return 0;
            }
            Iterator i = values.basicIterator();
            while (i.hasNext()) {
                EObject value = (EObject)i.next();
                if (!value.eIsProxy() && CopyingResource.this.isInResource(value)) continue;
                return 2;
            }
            return 1;
        }

        protected int sameDocSingle(EObject o, EStructuralFeature f) {
            EObject value = (EObject)this.helper.getValue(o, f);
            if (value == null) {
                return 0;
            }
            if (value.eIsProxy()) {
                return 2;
            }
            return CopyingResource.this.isInResource(value) ? 1 : 2;
        }
    }
}

